/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.form;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.DomEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.PreviewEvent;
import com.extjs.gxt.ui.client.util.BaseEventPreview;
import com.extjs.gxt.ui.client.util.DateWrapper;
import com.extjs.gxt.ui.client.util.Format;
import com.extjs.gxt.ui.client.util.KeyNav;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.DatePicker;
import com.extjs.gxt.ui.client.widget.form.DateTimePropertyEditor;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.TriggerField;
import com.extjs.gxt.ui.client.widget.menu.DateMenu;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import java.util.Date;
import org.jahia.ajax.gwt.client.widget.calendar.CalendarPicker;
import org.jahia.ajax.gwt.client.widget.menu.CalendarMenu;

public class CalendarField
extends TriggerField<Date> {
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy HH:mm";
    private Date minValue;
    private Date maxValue;
    private Menu menu;
    private boolean formatValue;
    private boolean displayTime;
    private BaseEventPreview eventPreview;

    public CalendarField() {
        this(DEFAULT_DATE_FORMAT, true, false, null, false, null);
    }

    public CalendarField(Date date) {
        this(DEFAULT_DATE_FORMAT, true, false, null, false, date);
    }

    public CalendarField(String datePattern, boolean displayTime, boolean readOnly, String fieldName, boolean shadow, Date value) {
        this.autoValidate = false;
        this.propertyEditor = new DateTimePropertyEditor(datePattern);
        this.messages = new DateFieldMessages();
        this.setTriggerStyle("x-form-date-trigger");
        this.displayTime = displayTime;
        if (value != null) {
            this.setValue(value);
        }
        if (fieldName != null && fieldName.length() > 0) {
            this.setName(fieldName);
            this.setItemId(fieldName);
        }
        this.setReadOnly(readOnly);
        this.setHideTrigger(readOnly);
        this.setShadow(shadow);
    }

    public DatePicker getDatePicker() {
        if (this.menu == null) {
            this.menu = this.displayTime ? new CalendarMenu() : new DateMenu();
            this.getMenuDatePicker().addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent ce) {
                    Date date;
                    CalendarField.this.focusValue = CalendarField.this.getValue();
                    Date date2 = date = CalendarField.this.menu instanceof DateMenu ? ((DateMenu)CalendarField.this.menu).getDate() : ((CalendarMenu)CalendarField.this.menu).getDate();
                    if (CalendarField.this.displayTime) {
                        date.setHours(((CalendarPicker)CalendarField.this.getMenuDatePicker()).getSelectedHour());
                        date.setMinutes(((CalendarPicker)CalendarField.this.getMenuDatePicker()).getSelectedMinute());
                    }
                    CalendarField.this.setValue(date);
                    CalendarField.this.menu.hide();
                }
            });
            this.menu.addListener(Events.Hide, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent be) {
                    CalendarField.this.eventPreview.remove();
                    CalendarField.this.focus();
                }
            });
        }
        return this.getMenuDatePicker();
    }

    public Date getMaxValue() {
        return this.maxValue;
    }

    public DateFieldMessages getMessages() {
        return (DateFieldMessages)this.messages;
    }

    public Date getMinValue() {
        return this.minValue;
    }

    public DateTimePropertyEditor getPropertyEditor() {
        return (DateTimePropertyEditor)this.propertyEditor;
    }

    public boolean isFormatValue() {
        return this.formatValue;
    }

    public void setFormatValue(boolean formatValue) {
        this.formatValue = formatValue;
    }

    public void setMaxValue(Date maxValue) {
        if (maxValue != null) {
            maxValue = new DateWrapper(maxValue).clearTime().asDate();
        }
        this.maxValue = maxValue;
    }

    public void setMinValue(Date minValue) {
        if (minValue != null) {
            minValue = new DateWrapper(minValue).clearTime().asDate();
        }
        this.minValue = minValue;
    }

    public void setRawValue(String value) {
        super.setRawValue(value);
    }

    protected void collapseIf(PreviewEvent pe) {
    }

    protected void expand() {
        DatePicker picker = this.getDatePicker();
        Object v = this.getValue();
        Date d = null;
        d = v instanceof Date ? (Date)v : new Date();
        picker.setValue(d, true);
        picker.setMinDate(this.minValue);
        picker.setMaxDate(this.maxValue);
        this.eventPreview.add();
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                CalendarField.this.menu.show(CalendarField.this.el().dom, "tl-bl?");
                CalendarField.this.getMenuDatePicker().focus();
            }
        });
    }

    protected void onDetach() {
        super.onDetach();
        if (this.eventPreview != null) {
            this.eventPreview.remove();
        }
    }

    protected void onKeyDown(FieldEvent fe) {
        super.onKeyDown(fe);
        if (fe.getKeyCode() == 40) {
            fe.stopEvent();
            if (this.menu == null || !this.menu.isAttached()) {
                this.expand();
            }
        }
    }

    protected void onRender(Element target, int index) {
        super.onRender(target, index);
        this.eventPreview = new BaseEventPreview(){

            protected boolean onPreview(PreviewEvent pe) {
                switch (pe.getType().getEventCode()) {
                    case 4: 
                    case 16384: 
                    case 131072: {
                        CalendarField.this.collapseIf(pe);
                    }
                }
                return true;
            }
        };
        this.eventPreview.setAutoHide(false);
        new KeyNav<FieldEvent>((Component)this){

            public void onEsc(FieldEvent fe) {
                if (CalendarField.this.menu != null && CalendarField.this.menu.isAttached()) {
                    CalendarField.this.menu.hide();
                }
            }
        };
        if (GXT.isAriaEnabled()) {
            this.getInputEl().dom.setAttribute("title", this.getMessages().getAriaText());
        }
    }

    protected void onTriggerClick(ComponentEvent ce) {
        super.onTriggerClick(ce);
        if (this.isReadOnly()) {
            return;
        }
        this.expand();
    }

    protected boolean validateBlur(DomEvent e, Element target) {
        return this.menu == null || !this.menu.isVisible();
    }

    protected boolean validateValue(String value) {
        if (!super.validateValue(value)) {
            return false;
        }
        if (value.length() < 1) {
            return true;
        }
        DateTimeFormat format = this.getPropertyEditor().getFormat();
        Date date = null;
        try {
            date = this.getPropertyEditor().convertStringValue(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            String error = null;
            error = this.getMessages().getInvalidText() != null ? Format.substitute((String)this.getMessages().getInvalidText(), (int)0) : GXT.MESSAGES.dateField_invalidText(value, format.getPattern().toUpperCase());
            this.markInvalid(error);
            return false;
        }
        if (this.minValue != null && date.before(this.minValue)) {
            String error = null;
            error = this.getMessages().getMinText() != null ? Format.substitute((String)this.getMessages().getMinText(), (Object[])new Object[]{format.format(this.minValue)}) : GXT.MESSAGES.dateField_minText(format.format(this.minValue));
            this.markInvalid(error);
            return false;
        }
        if (this.maxValue != null && date.after(this.maxValue)) {
            String error = null;
            error = this.getMessages().getMaxText() != null ? Format.substitute((String)this.getMessages().getMaxText(), (Object[])new Object[]{format.format(this.maxValue)}) : GXT.MESSAGES.dateField_maxText(format.format(this.maxValue));
            this.markInvalid(error);
            return false;
        }
        if (this.formatValue && this.getPropertyEditor().getFormat() != null) {
            this.setRawValue(this.getPropertyEditor().getFormat().format(date));
        }
        return true;
    }

    private DatePicker getMenuDatePicker() {
        return this.menu instanceof DateMenu ? ((DateMenu)this.menu).getDatePicker() : ((CalendarMenu)this.menu).getDatePicker();
    }

    public class DateFieldMessages
    extends TextField.TextFieldMessages {
        private String minText;
        private String maxText;
        private String invalidText;
        private String ariaText;

        public DateFieldMessages() {
            super((TextField)CalendarField.this);
            this.ariaText = "Press Down arrow to select date from a calendar grid";
        }

        public String getAriaText() {
            return this.ariaText;
        }

        public String getInvalidText() {
            return this.invalidText;
        }

        public String getMaxText() {
            return this.maxText;
        }

        public String getMinText() {
            return this.minText;
        }

        public void setAriaText(String ariaText) {
            this.ariaText = ariaText;
        }

        public void setInvalidText(String invalidText) {
            this.invalidText = invalidText;
        }

        public void setMaxText(String maxText) {
            this.maxText = maxText;
        }

        public void setMinText(String minText) {
            this.minText = minText;
        }
    }
}

