/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.publication;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflow;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineCards;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.contentengine.EnginePanel;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineWindow;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.publication.PublicationStatusGrid;
import org.jahia.ajax.gwt.client.widget.publication.PublicationStatusWindow;
import org.jahia.ajax.gwt.client.widget.publication.UnpublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.WorkInProgressActionItem;
import org.jahia.ajax.gwt.client.widget.workflow.CustomWorkflow;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowActionDialog;

public class PublicationWorkflow
implements CustomWorkflow {
    public static final List<Integer> STATUS = Arrays.asList(12, 3, 4, 5, 6, 10);
    protected List<GWTJahiaPublicationInfo> publicationInfos;
    private static transient boolean doRefresh;
    private static final long serialVersionUID = -4916142720074054130L;

    public PublicationWorkflow() {
    }

    public PublicationWorkflow(List<GWTJahiaPublicationInfo> publicationInfos) {
        this.publicationInfos = publicationInfos;
    }

    @Override
    public void initStartWorkflowDialog(GWTJahiaWorkflowDefinition workflow, WorkflowActionDialog dialog) {
        this.initDialog(dialog);
        dialog.getButtonsBar().remove(dialog.getButtonsBar().getItem(0));
        Button button = this.getBypassWorkflowButton(workflow, dialog);
        if (button != null) {
            dialog.getButtonsBar().insert((Component)button, 0);
        }
        if ((button = this.getStartWorkflowButton(workflow, dialog)) != null) {
            dialog.getButtonsBar().insert((Component)button, 0);
        }
    }

    @Override
    public void initExecuteActionDialog(GWTJahiaWorkflow workflow, WorkflowActionDialog dialog) {
        this.initDialog(dialog);
    }

    protected void initDialog(WorkflowActionDialog dialog) {
        TabItem tab = new TabItem("Publication infos");
        tab.setLayout((Layout)new FitLayout());
        doRefresh = false;
        PublicationStatusGrid g = new PublicationStatusGrid(this.publicationInfos, true, dialog.getLinker(), dialog.getContainer());
        tab.add((Widget)g);
        dialog.getTabPanel().add(tab);
        TabItem p = (TabItem)dialog.getTabPanel().getItem(0);
        LayoutContainer layoutContainer = new LayoutContainer((Layout)new RowLayout());
        layoutContainer.setStyleAttribute("margin", "5px");
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (GWTJahiaPublicationInfo info : this.publicationInfos) {
            Integer status = info.getStatus();
            if (status == 11) {
                status = 12;
            }
            if (!results.containsKey(status)) {
                results.put(status, 1);
                continue;
            }
            results.put(status, (Integer)results.get(status) + 1);
        }
        int i = 0;
        for (Integer status : STATUS) {
            if (!results.containsKey(status)) continue;
            ++i;
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)GWTJahiaPublicationInfo.renderPublicationStatusImage(status));
            String labelKey = GWTJahiaPublicationInfo.statusToLabel.get(status);
            h.add((Widget)new Html("&nbsp;" + Messages.get("label.publication." + labelKey, labelKey) + " : " + results.get(status) + " " + ((Integer)results.get(status) > 1 ? Messages.get("label.items", "Items") : Messages.get("label.item", "Item"))));
            layoutContainer.add((Widget)h);
        }
        if (i > 0) {
            p.add((Widget)layoutContainer, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, (float)(5 + i * 20)));
        }
    }

    public Button getStartWorkflowButton(final GWTJahiaWorkflowDefinition wf, final WorkflowActionDialog dialog) {
        final boolean unpublish = this instanceof UnpublicationWorkflow;
        Button button = new Button(Messages.get(unpublish ? "label.workflow.unpublish.start" : "label.workflow.start", unpublish ? "Request unpublication" : "Request publication"));
        button.addStyleName("button-start");
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                dialog.disableButtons();
                ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList();
                PropertiesEditor propertiesEditor = dialog.getPropertiesEditor();
                if (propertiesEditor != null) {
                    for (PropertiesEditor.PropertyAdapterField adapterField : propertiesEditor.getFieldsMap().values()) {
                        Field<?> field = adapterField.getField();
                        if (!field.isEnabled() || field.isReadOnly() || field.validate() || !((FieldSet)adapterField.getParent()).isExpanded()) continue;
                        String status = Messages.get("label.workflow.form.error", "Your form is not valid");
                        Info.display((String)status, (String)status);
                        dialog.enableButtons();
                        return;
                    }
                    nodeProperties = propertiesEditor.getProperties();
                }
                dialog.enableButtons();
                PublicationWorkflow.closeDialog(dialog);
                Info.display((String)Messages.get(unpublish ? "label.workflow.unpublish.start" : "label.workflow.start", unpublish ? "Request unpublication" : "Request publication"), (String)Messages.get("message.workflow.starting", "Starting publication workflow"));
                final String status = Messages.get("label.workflow.task", "Executing workflow task");
                WorkInProgressActionItem.setStatus(status);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("customWorkflowInfo", PublicationWorkflow.this);
                String workflowGroup = PublicationWorkflow.this.publicationInfos.get(0).getWorkflowGroup();
                String locale = workflowGroup.substring(0, workflowGroup.indexOf("/"));
                JahiaContentManagementService.App.getInstance().startWorkflow(PublicationWorkflow.this.getAllUuids(), wf, nodeProperties, dialog.getComments(), map, locale, new BaseAsyncCallback<Object>(){

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        WorkInProgressActionItem.removeStatus(status);
                        Log.error((String)Messages.get("label.workflow.cannotStart", "Cannot start workflow"), (Throwable)caught);
                        Window.alert((String)(Messages.get("label.workflow.cannotStart", "Cannot start workflow") + caught.getMessage()));
                    }

                    public void onSuccess(Object result) {
                        Info.display((String)Messages.get(unpublish ? "label.workflow.unpublish.start" : "label.workflow.start", unpublish ? "Request unpublication" : "Request publication"), (String)Messages.get("message.workflow.started", "Workflow started"));
                        WorkInProgressActionItem.removeStatus(status);
                        doRefresh = true;
                        if (dialog.getContainer() instanceof EngineCards && ((EngineCards)dialog.getContainer()).getComponents().isEmpty()) {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("refreshMain", true);
                            data.put("event", "workflowStarted");
                            dialog.getLinker().refresh(data);
                        }
                    }
                });
            }
        });
        return button;
    }

    public Button getBypassWorkflowButton(GWTJahiaWorkflowDefinition wf, final WorkflowActionDialog dialog) {
        if (!this.publicationInfos.isEmpty() && this.publicationInfos.get(0).isAllowedToPublishWithoutWorkflow().booleanValue()) {
            Button button = new Button(Messages.get(this instanceof UnpublicationWorkflow ? "label.bypassUnpublishWorkflow" : "label.bypassWorkflow", this instanceof UnpublicationWorkflow ? "Unpublish" : "Publish"));
            button.addStyleName("button-bypassworkflow");
            button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent ce) {
                    dialog.disableButtons();
                    ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList();
                    if (dialog.getPropertiesEditor() != null) {
                        nodeProperties = dialog.getPropertiesEditor().getProperties();
                    }
                    PublicationWorkflow.closeDialog(dialog);
                    PublicationWorkflow.this.doPublish(nodeProperties, dialog);
                }
            });
            return button;
        }
        return null;
    }

    private static void closeDialog(WorkflowActionDialog dialog) {
        ((EngineCards)dialog.getContainer()).closeEngine((Component)dialog);
    }

    protected void doPublish(List<GWTJahiaNodeProperty> nodeProperties, WorkflowActionDialog dialog) {
        final String status = Messages.get("label.publication.task", "Publishing content");
        Info.display((String)status, (String)status);
        WorkInProgressActionItem.setStatus(status);
        List<String> allUuids = this.getAllUuids();
        JahiaContentManagementService.App.getInstance().publish(allUuids, nodeProperties, null, new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                WorkInProgressActionItem.removeStatus(status);
                Info.display((String)"Cannot publish", (String)"Cannot publish");
                Window.alert((String)("Cannot publish " + caught.getMessage()));
            }

            public void onSuccess(Object result) {
                WorkInProgressActionItem.removeStatus(status);
            }
        });
    }

    public List<String> getAllUuids() {
        return PublicationWorkflow.getAllUuids(this.publicationInfos);
    }

    public static List<String> getAllUuids(List<GWTJahiaPublicationInfo> publicationInfos) {
        return PublicationWorkflow.getAllUuids(publicationInfos, false);
    }

    public static List<String> getAllUuids(List<GWTJahiaPublicationInfo> publicationInfos, boolean onlyAllowedToPublishWithoutWorkflow) {
        ArrayList<String> l = new ArrayList<String>();
        for (GWTJahiaPublicationInfo info : publicationInfos) {
            if (info.getStatus() == 11 || onlyAllowedToPublishWithoutWorkflow && !info.isAllowedToPublishWithoutWorkflow().booleanValue()) continue;
            if (info.getUuid() != null) {
                l.add(info.getUuid());
            }
            if (info.getI18nUuid() != null) {
                l.add(info.getI18nUuid());
            }
            if (info.getDeletedI18nUuid() == null) continue;
            for (String s : info.getDeletedI18nUuid().split(" ")) {
                l.add(s);
            }
        }
        return l;
    }

    public static void create(List<GWTJahiaPublicationInfo> all, final Linker linker, final boolean unpublish) {
        final TreeMap<String, List<GWTJahiaPublicationInfo>> infosListByWorflowGroup = new TreeMap<String, List<GWTJahiaPublicationInfo>>();
        ArrayList<String> keys = new ArrayList<String>();
        for (GWTJahiaPublicationInfo info : all) {
            String workflowGroupKey = info.getWorkflowGroup();
            if (!infosListByWorflowGroup.containsKey(workflowGroupKey)) {
                infosListByWorflowGroup.put(workflowGroupKey, new ArrayList());
            }
            ((List)infosListByWorflowGroup.get(workflowGroupKey)).add(info);
            if (info.getWorkflowDefinition() == null || keys.contains(info.getWorkflowDefinition())) continue;
            keys.add(info.getWorkflowDefinition());
        }
        if (keys.size() > 0) {
            JahiaContentManagementService.App.getInstance().getWorkflowDefinitions(keys, (AsyncCallback<Map<String, GWTJahiaWorkflowDefinition>>)new BaseAsyncCallback<Map<String, GWTJahiaWorkflowDefinition>>(){

                public void onSuccess(Map<String, GWTJahiaWorkflowDefinition> definitions) {
                    PublicationWorkflow.create(infosListByWorflowGroup, definitions, linker, unpublish);
                }
            });
        } else {
            PublicationWorkflow.create(infosListByWorflowGroup, new HashMap<String, GWTJahiaWorkflowDefinition>(), linker, unpublish);
        }
    }

    private static void create(SortedMap<String, List<GWTJahiaPublicationInfo>> infosListByWorflowGroup, Map<String, GWTJahiaWorkflowDefinition> definitions, final Linker linker, boolean unpublish) {
        EngineContainer container = linker instanceof ManagerLinker ? new EngineWindow() : new EnginePanel();
        final EngineCards cards = new EngineCards(container, linker);
        if (infosListByWorflowGroup.entrySet().isEmpty()) {
            new PublicationStatusWindow(linker, null, null, cards, unpublish);
        }
        for (Map.Entry<String, List<GWTJahiaPublicationInfo>> entry : infosListByWorflowGroup.entrySet()) {
            List<GWTJahiaPublicationInfo> infoList = entry.getValue();
            String workflowDefinition = infoList.get(0).getWorkflowDefinition();
            if (workflowDefinition != null) {
                PublicationWorkflow custom = unpublish ? new UnpublicationWorkflow(infoList) : new PublicationWorkflow(infoList);
                new WorkflowActionDialog(infoList.get(0).getMainPath(), Messages.getWithArgs("label.workflow.start.message", "{0} started by {1} on {2} - {3} content items involved", new Object[]{definitions.get(workflowDefinition).getDisplayName(), JahiaGWTParameters.getCurrentUser(), DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT).format(new Date()), infoList.size()}), definitions.get(workflowDefinition), linker, custom, cards, infoList.get(0).getLanguage());
                continue;
            }
            new PublicationStatusWindow(linker, PublicationWorkflow.getAllUuids(infoList), infoList, cards, unpublish);
        }
        cards.addGlobalButton(PublicationWorkflow.getStartAllWorkflows(cards, linker, unpublish));
        cards.addGlobalButton(PublicationWorkflow.getBypassAllWorkflowsButton(cards, linker, unpublish));
        Button button = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                cards.closeAllEngines();
                if (doRefresh) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshMain", true);
                    data.put("event", "workflowStarted");
                    linker.refresh(data);
                }
            }
        });
        button.addStyleName("button-cancel");
        cards.addGlobalButton(button);
        cards.showEngine();
    }

    private static Button getBypassAllWorkflowsButton(final EngineCards cards, final Linker linker, boolean unpublish) {
        boolean hasBypassAll = false;
        for (Component component : cards.getComponents()) {
            if (component instanceof WorkflowActionDialog) {
                List<GWTJahiaPublicationInfo> thisWFInfo = ((PublicationWorkflow)((WorkflowActionDialog)component).getCustomWorkflow()).getPublicationInfos();
                if (!thisWFInfo.get(0).isAllowedToPublishWithoutWorkflow().booleanValue()) continue;
                hasBypassAll = true;
                break;
            }
            if (!(component instanceof PublicationStatusWindow)) continue;
            hasBypassAll = true;
            break;
        }
        if (!hasBypassAll) {
            return null;
        }
        Button button = unpublish ? new Button(Messages.get(cards.getComponents().size() == 1 ? "label.bypassUnpublishWorkflow" : "label.bypassUnpublishWorkflow.all", cards.getComponents().size() == 1 ? "Unpublish" : "Unpublish all")) : new Button(Messages.get(cards.getComponents().size() == 1 ? "label.bypassWorkflow" : "label.bypassWorkflow.all", cards.getComponents().size() == 1 ? "Publish" : "Publish all"));
        button.addStyleName("button-bypassworkflow");
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                String status = Messages.get("label.publication.task", "Publishing content");
                Info.display((String)status, (String)status);
                WorkInProgressActionItem.setStatus(status);
                ArrayList<Component> components = new ArrayList<Component>(cards.getComponents());
                int[] nbWF = new int[]{components.size()};
                for (Component component : components) {
                    LayoutContainer dialog;
                    if (component instanceof WorkflowActionDialog) {
                        dialog = (WorkflowActionDialog)component;
                        dialog.disableButtons();
                        ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList<GWTJahiaNodeProperty>();
                        if (!PublicationWorkflow.fillDialogProperties((WorkflowActionDialog)dialog, nodeProperties)) {
                            return;
                        }
                        dialog.getContainer().closeEngine();
                        PublicationWorkflow customWorkflow = (PublicationWorkflow)dialog.getCustomWorkflow();
                        List<GWTJahiaPublicationInfo> thisWFInfo = customWorkflow.getPublicationInfos();
                        if (thisWFInfo.get(0).isAllowedToPublishWithoutWorkflow().booleanValue()) {
                            if (customWorkflow instanceof UnpublicationWorkflow) {
                                JahiaContentManagementService.App.getInstance().unpublish(PublicationWorkflow.getAllUuids(thisWFInfo), PublicationWorkflow.getCallback(cards, nbWF, Messages.get("message.content.unpublished", "Content unpublished"), Messages.get("message.content.unpublished.error", "Cannot unpublish"), status, linker, null));
                                continue;
                            }
                            JahiaContentManagementService.App.getInstance().publish(PublicationWorkflow.getAllUuids(thisWFInfo), nodeProperties, null, PublicationWorkflow.getCallback(cards, nbWF, Messages.get("message.content.published", "Content published"), Messages.get("message.content.published.error", "Cannot publish"), status, linker, null));
                            continue;
                        }
                        PublicationWorkflow.close(cards, nbWF, Messages.get("message.content.published", "Content published"), status, dialog.getLinker(), null);
                        continue;
                    }
                    if (component instanceof PublicationStatusWindow) {
                        dialog = (PublicationStatusWindow)component;
                        if (dialog.isUnpublish()) {
                            JahiaContentManagementService.App.getInstance().unpublish(dialog.getUuids(), PublicationWorkflow.getCallback(cards, nbWF, Messages.get("message.content.unpublished", "Content unpublished"), Messages.get("message.content.unpublished.error", "Cannot unpublish"), status, linker, null));
                            continue;
                        }
                        JahiaContentManagementService.App.getInstance().publish(dialog.getUuids(), null, null, PublicationWorkflow.getCallback(cards, nbWF, Messages.get("message.content.published", "Content published"), Messages.get("message.content.published.error", "Cannot publish"), status, linker, null));
                        continue;
                    }
                    PublicationWorkflow.close(cards, nbWF, Messages.get("label.workflow.start", "Start Workflow"), status, linker, null);
                }
            }
        });
        return button;
    }

    private static Button getStartAllWorkflows(final EngineCards cards, final Linker linker, boolean unpublish) {
        boolean hasWorkflow = false;
        for (Component component : cards.getComponents()) {
            if (!(component instanceof WorkflowActionDialog)) continue;
            hasWorkflow = true;
            break;
        }
        if (!hasWorkflow) {
            return null;
        }
        Button button = new Button(Messages.get(cards.getComponents().size() == 1 ? (unpublish ? "label.workflow.unpublish.start" : "label.workflow.start") : "label.workflow.start.all", cards.getComponents().size() == 1 ? (unpublish ? "Request unpublication" : "Request publication") : "Request publication for all"));
        button.addStyleName("button-start");
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                Info.display((String)Messages.get("label.workflow.start", "Request publication"), (String)Messages.get("message.workflow.starting", "Starting publication workflow"));
                String status = Messages.get("label.workflow.task", "Executing workflow task");
                WorkInProgressActionItem.setStatus(status);
                ArrayList<Component> components = new ArrayList<Component>(cards.getComponents());
                int[] nbWF = new int[]{components.size()};
                HashMap<String, Object> refreshData = new HashMap<String, Object>();
                refreshData.put("refreshMain", true);
                refreshData.put("event", "workflowStarted");
                for (Component component : components) {
                    if (component instanceof WorkflowActionDialog) {
                        WorkflowActionDialog dialog = (WorkflowActionDialog)component;
                        dialog.disableButtons();
                        ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList<GWTJahiaNodeProperty>();
                        if (!PublicationWorkflow.fillDialogProperties(dialog, nodeProperties)) {
                            return;
                        }
                        PublicationWorkflow customWorkflow = (PublicationWorkflow)dialog.getCustomWorkflow();
                        List<GWTJahiaPublicationInfo> thisWFInfo = customWorkflow.getPublicationInfos();
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("customWorkflowInfo", customWorkflow);
                        String workflowGroup = thisWFInfo.get(0).getWorkflowGroup();
                        String locale = workflowGroup.substring(0, workflowGroup.indexOf("/"));
                        JahiaContentManagementService.App.getInstance().startWorkflow(PublicationWorkflow.getAllUuids(thisWFInfo), dialog.getWfDefinition(), nodeProperties, dialog.getComments(), map, locale, PublicationWorkflow.getCallback(cards, nbWF, Messages.get("label.workflow.start", "Start Workflow"), Messages.get("label.workflow.cannotStart", "Cannot start workflow"), status, linker, refreshData));
                        continue;
                    }
                    PublicationWorkflow.close(cards, nbWF, Messages.get("label.workflow.start", "Request publication"), status, linker, refreshData);
                }
            }
        });
        return button;
    }

    private static BaseAsyncCallback<Object> getCallback(final EngineCards cards, final int[] nbWF, final String successMessage, final String errorMessage, final String statusMessage, final Linker linker, final Map<String, Object> refreshData) {
        return new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                PublicationWorkflow.close(cards, nbWF, errorMessage, statusMessage, linker, refreshData);
                Log.error((String)errorMessage, (Throwable)caught);
                Window.alert((String)(errorMessage + caught.getMessage()));
            }

            public void onSuccess(Object result) {
                PublicationWorkflow.close(cards, nbWF, successMessage, statusMessage, linker, refreshData);
            }
        };
    }

    private static void close(EngineCards cards, int[] nbWF, String message, String statusMessage, Linker linker, Map<String, Object> refreshData) {
        nbWF[0] = nbWF[0] - 1;
        if (nbWF[0] == 0) {
            Info.display((String)message, (String)message);
            WorkInProgressActionItem.removeStatus(statusMessage);
            if (refreshData != null) {
                linker.refresh(refreshData);
            }
            cards.closeAllEngines();
        }
    }

    private static boolean fillDialogProperties(WorkflowActionDialog dialog, List<GWTJahiaNodeProperty> nodeProperties) {
        PropertiesEditor propertiesEditor = dialog.getPropertiesEditor();
        if (propertiesEditor != null) {
            for (PropertiesEditor.PropertyAdapterField adapterField : propertiesEditor.getFieldsMap().values()) {
                Field<?> field = adapterField.getField();
                if (!field.isEnabled() || field.isReadOnly() || field.validate() || !((FieldSet)adapterField.getParent()).isExpanded()) continue;
                String error = Messages.get("label.workflow.form.error", "Your form is not valid");
                Info.display((String)error, (String)error);
                dialog.enableButtons();
                return false;
            }
            nodeProperties.addAll(propertiesEditor.getProperties());
        }
        return true;
    }

    public List<GWTJahiaPublicationInfo> getPublicationInfos() {
        return this.publicationInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicationWorkflow that = (PublicationWorkflow)o;
        return !(this.publicationInfos != null ? !this.publicationInfos.equals(that.publicationInfos) : that.publicationInfos != null);
    }

    public int hashCode() {
        int result = this.publicationInfos != null ? this.publicationInfos.hashCode() : 0;
        return result;
    }

    public static void openPublicationWorkflow(List<String> uuids, final Linker linker, boolean allSubTree, boolean allLanguages, final boolean checkForUnpublication) {
        BaseAsyncCallback<List<GWTJahiaPublicationInfo>> asyncCallback = new BaseAsyncCallback<List<GWTJahiaPublicationInfo>>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                if (linker != null) {
                    linker.loaded();
                }
                Window.alert((String)("Cannot get status: " + caught.getMessage()));
            }

            public void onSuccess(final List<GWTJahiaPublicationInfo> result) {
                if (linker != null) {
                    linker.loaded();
                }
                if (result.isEmpty()) {
                    MessageBox.info((String)Messages.get("label.publish", "Publication"), (String)Messages.get("label.publication.nothingToPublish", "Nothing to publish"), null);
                } else {
                    ArrayList<GWTJahiaPublicationInfo> unpublishable = new ArrayList<GWTJahiaPublicationInfo>();
                    for (GWTJahiaPublicationInfo info : result) {
                        Integer status = info.getStatus();
                        if (status != 6 && status != 9) continue;
                        unpublishable.add(info);
                    }
                    result.removeAll(unpublishable);
                    if (unpublishable.isEmpty()) {
                        PublicationWorkflow.create(result, linker, checkForUnpublication);
                    } else {
                        Integer status;
                        StringBuilder message = new StringBuilder();
                        HashMap unpublishableMap = new HashMap();
                        for (GWTJahiaPublicationInfo gWTJahiaPublicationInfo : unpublishable) {
                            status = gWTJahiaPublicationInfo.getStatus();
                            if (!unpublishableMap.containsKey(status)) {
                                unpublishableMap.put(status, new ArrayList());
                            }
                            ((List)unpublishableMap.get(status)).add(gWTJahiaPublicationInfo.getTitle() + " (" + gWTJahiaPublicationInfo.getPath() + ")");
                        }
                        for (Map.Entry entry : unpublishableMap.entrySet()) {
                            int i;
                            status = (Integer)entry.getKey();
                            List values = (List)entry.getValue();
                            String labelKey = GWTJahiaPublicationInfo.statusToLabel.get(status);
                            message.append(Messages.get("label.publication." + labelKey, labelKey)).append(" : ").append((String)values.get(0));
                            if (values.size() > 10) {
                                for (i = 1; i < 10; ++i) {
                                    message.append(", ").append((String)values.get(i));
                                }
                                message.append(", ...");
                                continue;
                            }
                            for (i = 1; i < values.size(); ++i) {
                                message.append(", ").append((String)values.get(i));
                            }
                        }
                        if (!result.isEmpty()) {
                            message.append("<br/>").append(Messages.get("message.continue"));
                            MessageBox.confirm((String)Messages.get("label.publish", "Publication"), (String)message.toString(), (Listener)new Listener<MessageBoxEvent>(){

                                public void handleEvent(MessageBoxEvent be) {
                                    if (be.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                                        PublicationWorkflow.create(result, linker, checkForUnpublication);
                                    }
                                }
                            });
                        } else {
                            MessageBox.info((String)Messages.get("label.publish", "Publication"), (String)message.toString(), null);
                        }
                    }
                }
            }
        };
        if (!allLanguages) {
            JahiaContentManagementService.App.getInstance().getPublicationInfo(uuids, allSubTree, checkForUnpublication, (AsyncCallback<List<GWTJahiaPublicationInfo>>)asyncCallback);
        } else {
            HashSet<String> languages = new HashSet<String>();
            for (GWTJahiaLanguage gwtJahiaLanguage : JahiaGWTParameters.getSiteLanguages()) {
                if (!gwtJahiaLanguage.isActive().booleanValue()) continue;
                languages.add(gwtJahiaLanguage.getLanguage());
            }
            JahiaContentManagementService.App.getInstance().getPublicationInfo(uuids, allSubTree, checkForUnpublication, languages, (AsyncCallback<List<GWTJahiaPublicationInfo>>)asyncCallback);
        }
    }
}

