/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowType;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class PublishActionItem
extends NodeTypeAwareBaseActionItem {
    protected transient String workflowType = "publish";
    protected transient boolean checkForUnpublication = false;
    protected boolean allSubTree = false;
    protected boolean allLanguages = false;

    public static boolean isChildOfMarkedForDeletion(LinkerSelectionContext selection) {
        GWTJahiaNode node;
        if (selection.getMultipleSelection().size() == 0) {
            return false;
        }
        boolean markedForDeletion = false;
        Iterator<GWTJahiaNode> iterator = selection.getMultipleSelection().iterator();
        while (iterator.hasNext() && (markedForDeletion = (node = iterator.next()).isMarkedForDeletion() && !node.isMarkedForDeletionRoot())) {
        }
        return markedForDeletion;
    }

    @Override
    public void handleNewLinkerSelection() {
        boolean hasOnlyOneLanguage;
        this.setEnabled(false);
        this.getGwtToolbarItem().setHideWhenDisabled(true);
        LinkerSelectionContext ctx = this.linker.getSelectionContext();
        boolean bl = hasOnlyOneLanguage = JahiaGWTParameters.getSiteLanguages().size() == 1;
        if (this.allLanguages) {
            if (hasOnlyOneLanguage) {
                this.setEnabled(false);
                return;
            }
            if (ctx.getMultipleSelection() != null && ctx.getMultipleSelection().size() > 1) {
                if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && this.hasPermission(ctx.getSelectionPermissions()) && this.supportPublication(ctx.getMultipleSelection()) && this.isNodeTypeAllowed(ctx.getMultipleSelection())) {
                    this.setEnabled(true);
                    if (this.allSubTree) {
                        this.updateTitle(Messages.get("label.publish.all.selected.items.all.languages", "Publish all under selected items in all languages"));
                    } else {
                        this.updateTitle(Messages.get("label.publish.selected.items.all.languages", "Publish all selected items in all languages"));
                    }
                }
            } else {
                GWTJahiaNode gwtJahiaNode = ctx.getSingleSelection();
                if (this.isWorkInProgress(gwtJahiaNode)) {
                    this.setEnabled(false);
                } else if (gwtJahiaNode != null) {
                    String title = this.allSubTree ? Messages.getWithArgs("label.publishall.all.languages", "Publish all under {0} in all languages", new String[]{gwtJahiaNode.getDisplayName()}) : Messages.getWithArgs("label.publish.languages", "Publish {0} in all languages", new String[]{gwtJahiaNode.getDisplayName()});
                    this.updateItem(ctx, gwtJahiaNode, title);
                }
            }
        } else if (this.allSubTree) {
            if (ctx.getMultipleSelection() != null && ctx.getMultipleSelection().size() > 1) {
                if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && this.hasPermission(ctx.getSelectionPermissions()) && this.supportPublication(ctx.getMultipleSelection()) && this.isNodeTypeAllowed(ctx.getMultipleSelection())) {
                    this.setEnabled(true);
                    this.updateTitle(Messages.get("label.publish.all.selected.items"));
                }
            } else {
                GWTJahiaNode gwtJahiaNode = ctx.getSingleSelection();
                if (this.isWorkInProgress(gwtJahiaNode)) {
                    this.setEnabled(false);
                } else if (gwtJahiaNode != null) {
                    String title = Messages.get("label.publishall") + " " + gwtJahiaNode.getDisplayName() + " - " + JahiaGWTParameters.getLanguageDisplayName();
                    this.updateItem(ctx, gwtJahiaNode, title);
                }
            }
        } else if (ctx.getMultipleSelection() != null && ctx.getMultipleSelection().size() > 1) {
            if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && this.hasPermission(ctx.getSelectionPermissions()) && this.supportPublication(ctx.getMultipleSelection()) && this.isNodeTypeAllowed(ctx.getMultipleSelection())) {
                this.setEnabled(true);
                this.updateTitle(this.getGwtToolbarItem().getTitle());
            }
        } else {
            GWTJahiaNode gwtJahiaNode = ctx.getSingleSelection();
            if (this.isWorkInProgress(gwtJahiaNode)) {
                this.setEnabled(false);
            } else if (gwtJahiaNode != null && !PublishActionItem.isChildOfMarkedForDeletion(ctx) && Boolean.TRUE.equals(gwtJahiaNode.get("supportsPublication")) && this.hasPermission(gwtJahiaNode) && this.isNodeTypeAllowed(gwtJahiaNode)) {
                this.setEnabled(true);
                if (this.checkForUnpublication) {
                    GWTJahiaPublicationInfo publicationInfo;
                    GWTJahiaPublicationInfo gWTJahiaPublicationInfo = publicationInfo = gwtJahiaNode.getAggregatedPublicationInfo() != null ? gwtJahiaNode.getAggregatedPublicationInfo() : gwtJahiaNode.getQuickPublicationInfo();
                    if (publicationInfo != null && !publicationInfo.isUnpublishable()) {
                        this.setEnabled(false);
                    }
                } else if (gwtJahiaNode.getAggregatedPublicationInfo() != null) {
                    GWTJahiaPublicationInfo info = gwtJahiaNode.getAggregatedPublicationInfo();
                    GWTJahiaWorkflowDefinition def = null;
                    if (gwtJahiaNode.getWorkflowInfo() != null) {
                        def = gwtJahiaNode.getWorkflowInfo().getPossibleWorkflows().get(new GWTJahiaWorkflowType(this.workflowType));
                    }
                    this.setEnabled(info.isPublishable() && (def != null || info.isAllowedToPublishWithoutWorkflow() != false));
                }
                if (gwtJahiaNode.isFile().booleanValue() || gwtJahiaNode.isNodeType("nt:folder")) {
                    this.updateTitle(this.getGwtToolbarItem().getTitle() + " " + gwtJahiaNode.getDisplayName());
                } else {
                    this.updateTitle(this.getGwtToolbarItem().getTitle() + " " + gwtJahiaNode.getDisplayName() + " - " + JahiaGWTParameters.getLanguageDisplayName());
                }
            }
        }
    }

    protected boolean isWorkInProgress(GWTJahiaNode gwtJahiaNode) {
        return gwtJahiaNode != null && !gwtJahiaNode.isMarkedForDeletion() && gwtJahiaNode.isInWorkInProgress(JahiaGWTParameters.getLanguage());
    }

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.getGwtToolbarItem().setHideWhenDisabled(true);
        this.setEnabled(false);
    }

    @Override
    public void onComponentSelection() {
        LinkerSelectionContext ctx = this.linker.getSelectionContext();
        if (!ctx.getMultipleSelection().isEmpty()) {
            ArrayList<String> uuids = new ArrayList<String>();
            List<GWTJahiaNode> jahiaNodes = ctx.getMultipleSelection();
            if (jahiaNodes.size() > 1) {
                for (GWTJahiaNode jahiaNode : jahiaNodes) {
                    uuids.add(jahiaNode.getUUID());
                }
            } else {
                uuids.add(ctx.getSingleSelection().getUUID());
            }
            this.linker.loading(Messages.get("label.gettingPublicationInfo", "Getting publication information"));
            PublicationWorkflow.openPublicationWorkflow(uuids, this.linker, this.allSubTree, this.allLanguages, this.checkForUnpublication);
        }
    }

    public void setAllSubTree(boolean allSubTree) {
        this.allSubTree = allSubTree;
    }

    public void setAllLanguages(boolean allLanguages) {
        this.allLanguages = allLanguages;
    }

    private void updateItem(LinkerSelectionContext ctx, GWTJahiaNode gwtJahiaNode, String title) {
        if (!PublishActionItem.isChildOfMarkedForDeletion(ctx) && Boolean.TRUE.equals(gwtJahiaNode.get("supportsPublication")) && this.hasPermission(gwtJahiaNode) && this.isNodeTypeAllowed(gwtJahiaNode)) {
            this.setEnabled(true);
            this.updateTitle(title);
        }
    }

    private boolean supportPublication(List<GWTJahiaNode> multipleSelection) {
        for (GWTJahiaNode gwtJahiaNode : multipleSelection) {
            if (Boolean.TRUE.equals(gwtJahiaNode.get("supportsPublication"))) continue;
            return false;
        }
        return true;
    }
}

