/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.data.RpcMap;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTModuleReleaseInfo;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.DistributionServerWindow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ReleaseModuleWindow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.SiteSwitcherActionItem;

public class ReleaseModuleActionItem
extends BaseActionItem {
    private static final long serialVersionUID = 4466321584782980102L;

    protected boolean areModuleSourcesAvailable() {
        return JahiaGWTParameters.getSiteNode().get("j:sourcesFolder") != null;
    }

    protected void doRelease(final GWTModuleReleaseInfo info, final ReleaseModuleWindow window) {
        JahiaContentManagementService.App.getInstance().releaseModule(JahiaGWTParameters.getSiteKey(), info, (AsyncCallback<RpcMap>)new BaseAsyncCallback<RpcMap>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                ReleaseModuleActionItem.this.linker.loaded();
                MessageBox.alert((String)Messages.get("label.releaseModule.failure", "Module release failed"), (String)Messages.get(caught.getMessage()), null);
            }

            public void onSuccess(RpcMap result) {
                ReleaseModuleActionItem.this.linker.loaded();
                GWTJahiaNode newModule = (GWTJahiaNode)result.get("newModule");
                String filename = (String)result.get("filename");
                String artifactUrl = (String)result.get("artifactUrl");
                String url = (String)result.get("downloadUrl");
                String catalogModulePageUrl = (String)result.get("catalogModulePageUrl");
                JahiaGWTParameters.getSitesMap().remove(JahiaGWTParameters.getSiteNode().getUUID());
                JahiaGWTParameters.getSitesMap().put(newModule.getUUID(), newModule);
                JahiaGWTParameters.setSiteNode(newModule);
                if (((EditLinker)ReleaseModuleActionItem.this.linker).getSidePanel() != null) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshAll", true);
                    ((EditLinker)ReleaseModuleActionItem.this.linker).getSidePanel().refresh(data);
                }
                MainModule.staticGoTo(newModule.getPath(), null);
                SiteSwitcherActionItem.refreshAllSitesList(ReleaseModuleActionItem.this.linker);
                window.removeAll();
                window.setHeight(150);
                if (artifactUrl != null) {
                    window.add((Widget)new HTML(Messages.get("downloadMessage.label") + "<br /><br /><a href=\"" + artifactUrl + "\" target=\"_new\">" + artifactUrl + "</a>"));
                } else {
                    window.add((Widget)new HTML(Messages.get("downloadMessage.label") + "<br /><br /><a href=\"" + url + "\" target=\"_new\">" + filename + "</a>"));
                }
                window.layout();
                window.show();
                if (catalogModulePageUrl != null && catalogModulePageUrl.length() > 0) {
                    if (info.getUsername() != null && info.getPassword() != null) {
                        catalogModulePageUrl = catalogModulePageUrl + "?username=" + info.getUsername() + "&password=" + info.getPassword() + "&doLogin=true";
                    }
                    MainModule.getInstance().goToExternalUrl(catalogModulePageUrl);
                }
            }
        });
    }

    @Override
    public void handleNewLinkerSelection() {
        GWTJahiaNode siteNode = JahiaGWTParameters.getSiteNode();
        String s = (String)siteNode.get("j:versionInfo");
        if (s != null && s.endsWith("-SNAPSHOT") && siteNode.get("j:sourcesFolder") != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void onComponentSelection() {
        this.linker.loading(Messages.get("label.releaseModule.loadingInfo", "Loading release information for module..."));
        JahiaContentManagementService.App.getInstance().getInfoForModuleRelease(JahiaGWTParameters.getSiteKey(), (AsyncCallback<GWTModuleReleaseInfo>)new BaseAsyncCallback<GWTModuleReleaseInfo>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                ReleaseModuleActionItem.this.linker.loaded();
                Info.display((String)Messages.get("label.error", "Error"), (String)(Messages.get("label.releaseModule.loadingInfo.failure", "Cannot load module information for release") + ":\n" + caught.getMessage()));
            }

            public void onSuccess(GWTModuleReleaseInfo result) {
                ReleaseModuleActionItem.this.linker.loaded();
                ReleaseModuleActionItem.this.onInfoLoaded(result);
            }
        });
    }

    protected void onInfoLoaded(final GWTModuleReleaseInfo result) {
        if ((result == null || result.getRepositoryUrl() == null) && this.areModuleSourcesAvailable()) {
            DistributionServerWindow distributionServerDialog = new DistributionServerWindow(){

                @Override
                protected void callback(GWTModuleReleaseInfo info) {
                    if (info != null) {
                        ReleaseModuleActionItem.this.linker.loading(Messages.get("label.releaseModule.distributionServer.updating", "Updating distribution management server information for module..."));
                        JahiaContentManagementService.App.getInstance().setDistributionServerForModule(JahiaGWTParameters.getSiteKey(), info, (AsyncCallback<GWTModuleReleaseInfo>)new BaseAsyncCallback<GWTModuleReleaseInfo>(){

                            @Override
                            public void onApplicationFailure(Throwable caught) {
                                ReleaseModuleActionItem.this.linker.loaded();
                                MessageBox.alert((String)Messages.get("label.error", "Error"), (String)(Messages.get("label.releaseModule.distributionServer.updating.failure", "Cannot update distribution server information") + ":\n" + caught.getMessage()), null);
                            }

                            public void onSuccess(GWTModuleReleaseInfo newInfo) {
                                ReleaseModuleActionItem.this.linker.loaded();
                                ReleaseModuleActionItem.this.showReleaseModuleWindo(newInfo);
                            }
                        });
                    } else {
                        ReleaseModuleActionItem.this.showReleaseModuleWindo(result);
                    }
                }
            };
            distributionServerDialog.show();
        } else {
            this.showReleaseModuleWindo(result);
        }
    }

    private void showReleaseModuleWindo(GWTModuleReleaseInfo result) {
        final ReleaseModuleWindow window = new ReleaseModuleWindow(result);
        window.setCallback(new ReleaseModuleWindow.Callback(){

            @Override
            public void handle(GWTModuleReleaseInfo info) {
                window.hide();
                ReleaseModuleActionItem.this.linker.loading(Messages.get("label.releaseModule.releasing", "Releasing module..."));
                ReleaseModuleActionItem.this.doRelease(info, window);
            }
        });
        window.show();
    }
}

