/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.workflow;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaCreateEngineInitBean;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflow;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowComment;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowOutcome;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowTask;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineCards;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.toolbar.action.WorkInProgressActionItem;
import org.jahia.ajax.gwt.client.widget.workflow.CustomWorkflow;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowDashboardEngine;

public class WorkflowActionDialog
extends LayoutContainer {
    private JahiaContentManagementServiceAsync contentManagement;
    private WorkflowDashboardEngine workflowDashboard;
    private TabPanel tabPanel;
    private TabItem actionTab;
    private TabItem commentsTab;
    private EngineContainer container;
    private String title;
    private List<GWTJahiaWorkflowComment> comments;
    private String nodePath;
    private GWTJahiaWorkflow workflow;
    private transient GWTJahiaWorkflowDefinition wfDefinition;
    private transient CustomWorkflow customWorkflow;
    private Linker linker;
    private PropertiesEditor propertiesEditor;
    private ButtonBar buttonsBar;

    public WorkflowActionDialog(String nodePath, String title, GWTJahiaWorkflowDefinition wfDefinition, Linker linker, CustomWorkflow custom, EngineContainer container) {
        this(nodePath, linker, container, title, null, wfDefinition.getFormResourceName(), null);
        this.wfDefinition = wfDefinition;
        this.initStartWorkflowDialog(wfDefinition);
        if (custom != null) {
            custom.initStartWorkflowDialog(wfDefinition, this);
        }
    }

    public WorkflowActionDialog(String nodePath, GWTJahiaWorkflow workflow, GWTJahiaWorkflowTask task, Linker linker, CustomWorkflow custom, EngineContainer container) {
        this(nodePath, linker, container, workflow.getVariables().get("jcr_title") != null && workflow.getVariables().get("jcr_title").getValues().size() == 1 ? workflow.getVariables().get("jcr_title").getValues().get(0).getString() : null, null, (String)task.get("formResourceName"), workflow);
        this.initExecuteActionDialog(task);
        if (custom != null) {
            custom.initExecuteActionDialog(workflow, this);
        }
    }

    public WorkflowActionDialog(String nodePath, String title, GWTJahiaWorkflowDefinition wfDefinition, Linker linker, CustomWorkflow custom, EngineContainer container, String language) {
        this(nodePath, linker, container, title, language, wfDefinition.getFormResourceName(), null);
        this.wfDefinition = wfDefinition;
        this.customWorkflow = custom;
        this.initStartWorkflowDialog(wfDefinition);
        if (custom != null) {
            custom.initStartWorkflowDialog(wfDefinition, this);
        }
    }

    private WorkflowActionDialog(String nodePath, Linker linker, EngineContainer container, String title, String language, String wfDefinitionNodeType, GWTJahiaWorkflow workflow) {
        this.addStyleName("workflow-action-dialog");
        this.nodePath = nodePath;
        this.workflow = workflow;
        this.contentManagement = JahiaContentManagementService.App.getInstance();
        this.linker = linker;
        this.title = title;
        this.tabPanel = new TabPanel();
        this.setLayout((Layout)new FitLayout());
        this.add((Component)this.tabPanel);
        this.buttonsBar = new ButtonBar();
        this.buttonsBar.setAlignment(Style.HorizontalAlignment.CENTER);
        this.actionTab = new TabItem();
        this.container = container;
        this.initTabs(wfDefinitionNodeType, workflow != null ? workflow.getVariables() : new HashMap<String, GWTJahiaNodeProperty>(), language);
        container.setEngine((Component)this, this.title, this.buttonsBar, JahiaGWTParameters.getLanguage(language), this.linker);
        this.addCancelButton(container);
    }

    private void addCancelButton(final EngineContainer container) {
        if (!(container instanceof EngineCards)) {
            Button cancel = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent event) {
                    container.closeEngine();
                }
            });
            cancel.addStyleName("button-cancel");
            this.buttonsBar.insert((Component)cancel, 0);
        }
    }

    public EngineContainer getContainer() {
        return this.container;
    }

    public Linker getLinker() {
        return this.linker;
    }

    public PropertiesEditor getPropertiesEditor() {
        return this.propertiesEditor;
    }

    public void initStartWorkflowDialog(GWTJahiaWorkflowDefinition workflowDefinition) {
        this.buttonsBar.add((Component)this.generateStartWorkflowButton(workflowDefinition));
    }

    public void initExecuteActionDialog(GWTJahiaWorkflowTask task) {
        for (Button button : this.generateActionButtons(task)) {
            this.buttonsBar.add((Component)button);
        }
    }

    private void initTabs(String formResourceName, Map<String, GWTJahiaNodeProperty> variables, String language) {
        if (this.title != null) {
            if (language != null) {
                variables.put("jcr:title", new GWTJahiaNodeProperty("jcr:title", new GWTJahiaNodePropertyValue(language + " - " + this.title, 1)));
            } else {
                variables.put("jcr:title", new GWTJahiaNodeProperty("jcr:title", new GWTJahiaNodePropertyValue(this.title, 1)));
            }
        }
        TabItem action = this.initActionTab(formResourceName, variables);
        this.tabPanel.add(action);
        TabItem comments = this.initCommentTab();
        this.tabPanel.add(comments);
    }

    private TabItem initActionTab(String formResourceName, final Map<String, GWTJahiaNodeProperty> variables) {
        this.actionTab = new TabItem(Messages.get("label.action", "Action"));
        this.actionTab.setLayout((Layout)new BorderLayout());
        if (formResourceName != null && !"".equals(formResourceName)) {
            NodeTypeCreationCaller nodeTypeCreationCaller = new NodeTypeCreationCaller(formResourceName, this.nodePath);
            nodeTypeCreationCaller.add((AsyncCallback<NodeTypeCreationInfo>)new BaseAsyncCallback<NodeTypeCreationInfo>(){

                public void onSuccess(NodeTypeCreationInfo result) {
                    WorkflowActionDialog.this.propertiesEditor = new PropertiesEditor(Arrays.asList(result.getNodeType()), variables, Arrays.asList("content"));
                    WorkflowActionDialog.this.propertiesEditor.setChoiceListInitializersValues(result.getEngine().getChoiceListInitializersValues());
                    WorkflowActionDialog.this.propertiesEditor.setViewInheritedItems(true);
                    WorkflowActionDialog.this.propertiesEditor.renderNewFormPanel();
                    WorkflowActionDialog.this.propertiesEditor.setFrame(true);
                    WorkflowActionDialog.this.propertiesEditor.setBorders(false);
                    WorkflowActionDialog.this.propertiesEditor.setBodyBorder(false);
                    WorkflowActionDialog.this.actionTab.add((Widget)WorkflowActionDialog.this.propertiesEditor, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
                    WorkflowActionDialog.this.actionTab.layout();
                }
            });
        }
        return this.actionTab;
    }

    private TabItem initCommentTab() {
        this.commentsTab = new TabItem(Messages.get("label.comments", "Comments"));
        this.commentsTab.setLayout((Layout)new BorderLayout());
        final LayoutContainer commentsContainer = new LayoutContainer((Layout)new RowLayout(Style.Orientation.VERTICAL));
        this.commentsTab.add((Widget)commentsContainer, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        commentsContainer.setScrollMode(Style.Scroll.AUTOY);
        commentsContainer.setBorders(false);
        if (this.workflow != null) {
            this.contentManagement.getWorkflowComments(this.workflow, (AsyncCallback<List<GWTJahiaWorkflowComment>>)new BaseAsyncCallback<List<GWTJahiaWorkflowComment>>(){

                public void onSuccess(List<GWTJahiaWorkflowComment> result) {
                    WorkflowActionDialog.this.displayComments(result, commentsContainer);
                }
            });
        }
        FormPanel formPanel = new FormPanel();
        formPanel.setHeaderVisible(false);
        formPanel.setBorders(false);
        formPanel.setBodyBorder(false);
        formPanel.setLayout((Layout)new FormLayout(FormPanel.LabelAlign.LEFT));
        final TextArea textArea = new TextArea();
        textArea.setFieldLabel(Messages.get("label.comment", "Comment"));
        textArea.setPreventScrollbars(false);
        textArea.setHeight(50);
        textArea.setWidth(750);
        textArea.setAllowBlank(false);
        FormData data = new FormData("-20");
        formPanel.add((Widget)textArea, (LayoutData)data);
        Button button = new Button(Messages.get("label.addComment", "Add comment"));
        button.addStyleName("button-comment");
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                if (WorkflowActionDialog.this.workflow != null) {
                    WorkflowActionDialog.this.contentManagement.addCommentToWorkflow(WorkflowActionDialog.this.workflow, (String)textArea.getValue(), (AsyncCallback<List<GWTJahiaWorkflowComment>>)new BaseAsyncCallback<List<GWTJahiaWorkflowComment>>(){

                        public void onSuccess(List<GWTJahiaWorkflowComment> result) {
                            commentsContainer.removeAll();
                            WorkflowActionDialog.this.displayComments(result, commentsContainer);
                            Info.display((String)Messages.get("label.commentAdded", "Comment Added"), (String)Messages.get("label.commentAdded", "Comment Added"));
                        }

                        @Override
                        public void onApplicationFailure(Throwable caught) {
                            Info.display((String)"Adding comment failed", (String)"Adding comment failed");
                        }
                    });
                } else {
                    GWTJahiaWorkflowComment wfComment = new GWTJahiaWorkflowComment();
                    wfComment.setComment((String)textArea.getValue());
                    wfComment.setUser(JahiaGWTParameters.getCurrentUser());
                    wfComment.setTime(new Date());
                    if (WorkflowActionDialog.this.comments == null) {
                        WorkflowActionDialog.this.comments = new ArrayList();
                    }
                    WorkflowActionDialog.this.comments.add(wfComment);
                    commentsContainer.removeAll();
                    WorkflowActionDialog.this.displayComments(WorkflowActionDialog.this.comments, commentsContainer);
                }
            }
        });
        formPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        formPanel.add((Widget)button, (LayoutData)data);
        FormButtonBinding buttonBinding = new FormButtonBinding(formPanel);
        buttonBinding.addButton(button);
        this.commentsTab.add((Widget)formPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.SOUTH, 100.0f));
        return this.commentsTab;
    }

    private void displayComments(List<GWTJahiaWorkflowComment> comments, LayoutContainer commentsPanel) {
        int i = 0;
        for (GWTJahiaWorkflowComment comment : comments) {
            Text text = new Text(comment.getComment());
            text.setWidth(450);
            Text time = new Text(Messages.get("label.at", "at") + " " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM).format(comment.getTime()));
            Text user = new Text(Messages.get("label.by", "by") + " " + comment.getUser());
            HorizontalPanel commentPanel = new HorizontalPanel();
            commentPanel.setBorders(false);
            commentPanel.setWidth("100%");
            TableData data = new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.MIDDLE);
            data.setPadding(5);
            commentPanel.add((Widget)text, (LayoutData)data);
            commentPanel.setScrollMode(Style.Scroll.NONE);
            commentPanel.setStyleAttribute("background-color", i % 2 == 0 ? "#e9eff3" : "white");
            VerticalPanel verticalPanel = new VerticalPanel();
            verticalPanel.add((Widget)time, (LayoutData)data);
            verticalPanel.add((Widget)user);
            verticalPanel.setWidth(250);
            verticalPanel.setBorders(false);
            commentPanel.add((Widget)verticalPanel);
            commentsPanel.add((Widget)commentPanel);
            ++i;
        }
        commentsPanel.layout();
    }

    public void disableButtons() {
        for (Component component : this.buttonsBar.getItems()) {
            if (!(component instanceof Button)) continue;
            ((Button)component).setEnabled(false);
        }
    }

    public void enableButtons() {
        for (Component component : this.buttonsBar.getItems()) {
            if (!(component instanceof Button)) continue;
            ((Button)component).setEnabled(true);
        }
    }

    public Button generateStartWorkflowButton(final GWTJahiaWorkflowDefinition wf) {
        Button button = new Button(Messages.get("label.workflow.start", "Start Workflow") + ":" + wf.getDisplayName());
        button.addStyleName("button-start");
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent buttonEvent) {
                WorkflowActionDialog.this.disableButtons();
                ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList();
                if (WorkflowActionDialog.this.propertiesEditor != null) {
                    for (PropertiesEditor.PropertyAdapterField adapterField : WorkflowActionDialog.this.propertiesEditor.getFieldsMap().values()) {
                        Field<?> field = adapterField.getField();
                        if (!field.isEnabled() || field.isReadOnly() || field.validate() || !((FieldSet)adapterField.getParent()).isExpanded()) continue;
                        String status = Messages.get("label.workflow.form.error", "Your form is not valid");
                        Info.display((String)status, (String)status);
                        WorkflowActionDialog.this.enableButtons();
                        return;
                    }
                    nodeProperties = WorkflowActionDialog.this.propertiesEditor.getProperties();
                }
                WorkflowActionDialog.this.container.closeEngine();
                final String status = Messages.get("label.workflow.task", "Executing workflow task");
                Info.display((String)status, (String)status);
                WorkInProgressActionItem.setStatus(status);
                WorkflowActionDialog.this.contentManagement.startWorkflow(WorkflowActionDialog.this.nodePath, wf, nodeProperties, WorkflowActionDialog.this.getComments(), new BaseAsyncCallback<Object>(){

                    public void onSuccess(Object result) {
                        Info.display((String)status, (String)Messages.get("message.workflow.task.success", "Workflow task executed successfully"));
                        WorkInProgressActionItem.removeStatus(status);
                    }

                    @Override
                    public void onApplicationFailure(Throwable caught) {
                        Info.display((String)status, (String)Messages.get("message.workflow.task.failure", "Workflow task failed to execute"));
                        WorkInProgressActionItem.removeStatus(status);
                    }
                });
            }
        });
        return button;
    }

    private List<Button> generateActionButtons(final GWTJahiaWorkflowTask task) {
        List<GWTJahiaWorkflowOutcome> outcomes = task.getOutcomes();
        ArrayList<Button> allButtons = new ArrayList<Button>();
        for (final GWTJahiaWorkflowOutcome outcome : outcomes) {
            Button button = new Button(outcome.getLabel());
            if (outcome.getIcon() != null) {
                button.setIcon(ToolbarIconProvider.getInstance().getIcon(outcome.getIcon()));
            }
            allButtons.add(button);
            button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                public void componentSelected(ButtonEvent buttonEvent) {
                    WorkflowActionDialog.this.disableButtons();
                    ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList();
                    if (WorkflowActionDialog.this.propertiesEditor != null) {
                        for (PropertiesEditor.PropertyAdapterField adapterField : WorkflowActionDialog.this.propertiesEditor.getFieldsMap().values()) {
                            Field<?> field = adapterField.getField();
                            if (!field.isEnabled() || field.isReadOnly() || field.validate() || !((FieldSet)adapterField.getParent()).isExpanded()) continue;
                            String status = Messages.get("label.workflow.form.error", "Your form is not valid");
                            Info.display((String)status, (String)status);
                            WorkflowActionDialog.this.enableButtons();
                            return;
                        }
                        nodeProperties = WorkflowActionDialog.this.propertiesEditor.getProperties();
                    }
                    final String status = Messages.get("label.workflow.task", "Executing workflow task");
                    Info.display((String)status, (String)status);
                    WorkInProgressActionItem.setStatus(status);
                    WorkflowActionDialog.this.contentManagement.assignAndCompleteTask(task, outcome, nodeProperties, new BaseAsyncCallback<Object>(){

                        public void onSuccess(Object result) {
                            WorkInProgressActionItem.removeStatus(status);
                            Info.display((String)Messages.get("label.information", "Information"), (String)Messages.get("label.workflow.finished", "Workflow executed"));
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("refreshMain", true);
                            data.put("event", "workflowExecuted");
                            if (WorkflowActionDialog.this.linker != null) {
                                WorkflowActionDialog.this.linker.refresh(data);
                            }
                            WorkflowActionDialog.this.container.closeEngine();
                        }

                        @Override
                        public void onApplicationFailure(Throwable caught) {
                            WorkInProgressActionItem.removeStatus(status);
                            Window.alert((String)(Messages.get("label.workflow.failed", "Workflow failed") + ": " + caught.getMessage()));
                            WorkflowActionDialog.this.container.closeEngine();
                        }
                    });
                }
            });
        }
        return allButtons;
    }

    public CustomWorkflow getCustomWorkflow() {
        return this.customWorkflow;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public GWTJahiaWorkflowDefinition getWfDefinition() {
        return this.wfDefinition;
    }

    public void setWorkflowDashboard(WorkflowDashboardEngine workflowDashboard) {
        this.workflowDashboard = workflowDashboard;
    }

    public List<String> getComments() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.comments != null && this.comments.size() > 0) {
            for (GWTJahiaWorkflowComment c : this.comments) {
                result.add(c.getComment());
            }
        }
        return result;
    }

    public TabPanel getTabPanel() {
        return this.tabPanel;
    }

    public ButtonBar getButtonsBar() {
        return this.buttonsBar;
    }

    protected void onHide() {
        super.onHide();
        if (this.workflowDashboard != null) {
            this.workflowDashboard.hide();
        }
    }

    class NodeTypeCreationInfo {
        private GWTJahiaNodeType nodeType;
        private GWTJahiaCreateEngineInitBean engine;

        public NodeTypeCreationInfo(GWTJahiaNodeType nodeType, GWTJahiaCreateEngineInitBean engine) {
            this.nodeType = nodeType;
            this.engine = engine;
        }

        public GWTJahiaCreateEngineInitBean getEngine() {
            return this.engine;
        }

        public void setEngine(GWTJahiaCreateEngineInitBean engine) {
            this.engine = engine;
        }

        public GWTJahiaNodeType getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(GWTJahiaNodeType nodeType) {
            this.nodeType = nodeType;
        }
    }

    class NodeTypeCreationCaller {
        private NodeTypeCreationInfo result;
        private List<AsyncCallback<NodeTypeCreationInfo>> deferredCallbacks = new ArrayList<AsyncCallback<NodeTypeCreationInfo>>();

        public NodeTypeCreationCaller(String nodeTypeName, final String path) {
            WorkflowActionDialog.this.contentManagement.getWFFormForNodeAndNodeType(nodeTypeName, (AsyncCallback<GWTJahiaNodeType>)new BaseAsyncCallback<GWTJahiaNodeType>(){

                public void onSuccess(final GWTJahiaNodeType nodeType) {
                    JahiaContentManagementService.App.getInstance().initializeCreateEngine(nodeType.getName(), path, null, (AsyncCallback<GWTJahiaCreateEngineInitBean>)new BaseAsyncCallback<GWTJahiaCreateEngineInitBean>(){

                        public void onSuccess(GWTJahiaCreateEngineInitBean engine) {
                            NodeTypeCreationCaller.this.result = new NodeTypeCreationInfo(nodeType, engine);
                            for (AsyncCallback callback : NodeTypeCreationCaller.this.deferredCallbacks) {
                                callback.onSuccess((Object)NodeTypeCreationCaller.this.result);
                            }
                            NodeTypeCreationCaller.this.deferredCallbacks.clear();
                        }
                    });
                }
            });
        }

        public void add(final AsyncCallback<NodeTypeCreationInfo> async) {
            if (this.result != null) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        async.onSuccess((Object)NodeTypeCreationCaller.this.result);
                    }
                });
            } else {
                this.deferredCallbacks.add(async);
            }
        }
    }
}

