/*
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *                                 http://www.jahia.com
 *
 *     Copyright (C) 2002-2019 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/GPL OR 2/JSEL
 *
 *     1/ GPL
 *     ==================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE GPL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ===================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 */
 package org.jahia.data.applications;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;

import java.util.List;

/**
 * <p>Title: EntryPointDefinition for a web application</p>
 * <p>Description: A web application may contain multiple entry point
 * definitions, depending on the type of web application we are dealing with.
 * Servlet-based web application will for example have multiple servlet
 * mappings that will all be possible entry points into the application.
 * Portlet-based web applications will have multiple portlets in an application.
 * Note that the data contain in this object is generated by the
 * ApplicationManagerProvider, and it not meant to be stored in Jahia's
 * database, but provided by the implementation of each provider (in the case
 * of servlet-based web apps we parse the web.xml and for portlets we use
 * Jetspeed 2's registry sub-system).</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Jahia Ltd</p>
 * @author Serge Huber
 * @version 1.0
 */
public interface EntryPointDefinition {

    /**
     * Get the context
     * @return
     */
    public String getContext();

    /**
     * Get the name
     * @return  name
     */
    public String getName ();

    /**
     * Get display name depending on the locale
     * @param locale
     * @return display name
     */
    public String getDisplayName(java.util.Locale locale);

    /**
     * Get description depending on the locale
     * @param locale
     * @return
     */
    public String getDescription(java.util.Locale locale);

    /**
     * Get the application id
     * @return
     */
    public String getApplicationID();

    /**
     * Get the supported PortletMode for this entry point definition.
     * @return List a list of PortletMode objects
     */
    public List<PortletMode> getPortletModes();

    /**
     * Get the supported WindowState for this entry point definition.
     * @return List a list of WindowState objects.
     */
    public List<WindowState> getWindowStates();
}
