/*
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *                                 http://www.jahia.com
 *
 *     Copyright (C) 2002-2020 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/GPL OR 2/JSEL
 *
 *     1/ GPL
 *     ==================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE GPL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ===================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 */
package org.jahia.services.importexport.validation;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProviderAvailabilityValidatorResult implements ValidationResult, Serializable {

    private final Set<String> unavailableProviders;

    public ProviderAvailabilityValidatorResult(Set<String> unavailableProviders) {
        this.unavailableProviders = unavailableProviders;
    }

    public ProviderAvailabilityValidatorResult(ProviderAvailabilityValidatorResult result, ProviderAvailabilityValidatorResult toBeMergedWith) {
        this.unavailableProviders = new LinkedHashSet<String>(result.getUnavailableProviders());
        this.unavailableProviders.addAll(toBeMergedWith.getUnavailableProviders());
    }

    @Override
    public boolean isSuccessful() {
        return unavailableProviders.isEmpty();
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith == null || toBeMergedWith.isSuccessful()
                || !(toBeMergedWith instanceof ProviderAvailabilityValidatorResult) ? this
                : new ProviderAvailabilityValidatorResult(this,
                (ProviderAvailabilityValidatorResult) toBeMergedWith);
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append("[").append(StringUtils.substringAfterLast(getClass().getName(), "."))
                .append("=").append(isSuccessful() ? "successful" : "failure");
        out.append(", unavailableProviders=").append(unavailableProviders);
        out.append("]");

        return out.toString();
    }

    public Set<String> getUnavailableProviders() {
        return unavailableProviders;
    }
}
