/*
 * ==========================================================================================
 * =                            JAHIA'S ENTERPRISE DISTRIBUTION                             =
 * ==========================================================================================
 *
 *                                  http://www.jahia.com
 *
 * JAHIA'S ENTERPRISE DISTRIBUTIONS LICENSING - IMPORTANT INFORMATION
 * ==========================================================================================
 *
 *     Copyright (C) 2002-2020 Jahia Solutions Group. All rights reserved.
 *
 *     This file is part of a Jahia's Enterprise Distribution.
 *
 *     Jahia's Enterprise Distributions must be used in accordance with the terms
 *     contained in the Jahia Solutions Group Terms & Conditions as well as
 *     the Jahia Sustainable Enterprise License (JSEL).
 *
 *     For questions regarding licensing, support, production usage...
 *     please contact our team at sales@jahia.com or go to http://www.jahia.com/license.
 *
 * ==========================================================================================
 */
package org.jahia.services.hazelcast;

/**
 * Lock/unlock with hazelcast locks
 */
public interface HazelcastCP {
    /**
     * Lock
     *
     * @param key lock key
     */
    void lock(String key);

    /**
     * Unlock
     *
     * @param key lock key
     */
    void unlock(String key);

    /**
     * Get atomic long value from CP
     * @param key atomic long key
     * @return value value
     */
    Long getAtomic(String key);

    /**
     * Set atomic long from CP
     * @param key atomic long key
     * @param value value
     */
    void setAtomic(String key, long value);
}
