/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaSearchIndex;
import org.apache.jackrabbit.core.query.lucene.JahiaSingleColumnQueryResult;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.jahia.utils.LuceneUtils;

public class JahiaQueryImpl
extends QueryImpl {
    public static boolean checkAclUuidInIndex = Boolean.valueOf(System.getProperty("jahia.jackrabbit.query.xpath.checkAclUuidInIndex", "true"));
    private Constraint constraint = null;
    private String statement = null;

    public JahiaQueryImpl(SessionContext sessionContext, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language, QueryNodeFactory factory) throws InvalidQueryException {
        super(sessionContext, index, propReg, statement, language, factory);
        this.statement = statement;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public boolean needsSystemTree() {
        return this.statement.contains("jcr:system");
    }

    protected Analyzer getTextAnalyzer() {
        String lang = LuceneUtils.extractLanguageOrNullFromStatement(this.statement);
        if (lang != null) {
            Analyzer analyzer = this.index.getAnalyzerRegistry().getAnalyzer((Object)lang);
            return analyzer != null ? analyzer : super.getTextAnalyzer();
        }
        return super.getTextAnalyzer();
    }

    protected QueryResult createQueryResult(long offset, long limit, Query query, Path[] orderProperties, boolean[] ascSpecs, String[] orderFuncs) throws RepositoryException {
        if (checkAclUuidInIndex && JahiaSearchIndex.isAclUuidInIndex(this.index)) {
            return new JahiaSingleColumnQueryResult(this.index, this.sessionContext, (AbstractQueryImpl)this, query, new SpellSuggestion(this.index.getSpellChecker(), this.root), this.getColumns(), orderProperties, ascSpecs, orderFuncs, orderProperties.length == 0 && this.getRespectDocumentOrder(), offset, limit);
        }
        return super.createQueryResult(offset, limit, query, orderProperties, ascSpecs, orderFuncs);
    }
}

