/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.jackrabbit.j2ee.DavLocatorFactoryImpl;
import org.apache.jackrabbit.j2ee.JahiaResourceFactoryImpl;
import org.apache.jackrabbit.j2ee.JahiaSessionCredentials;
import org.apache.jackrabbit.j2ee.SimpleWebdavServlet;
import org.apache.jackrabbit.server.CredentialsProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaWebdavServlet
extends SimpleWebdavServlet {
    private static final long serialVersionUID = 43821067248762234L;
    private static transient Logger logger = LoggerFactory.getLogger(JahiaWebdavServlet.class);
    private static final String RESOURCE_PATH_PREFIX = "/repository";

    protected CredentialsProvider getCredentialsProvider() {
        return new JahiaSessionCredentials();
    }

    protected boolean execute(WebdavRequest request, WebdavResponse response, int method, DavResource resource) throws ServletException, IOException, DavException {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling {} method {}", (Object)JahiaWebdavServlet.getDavMethod(method), (Object)request.getPathTranslated());
        }
        if (method != 2 && Boolean.TRUE.equals(request.getAttribute("isGuest"))) {
            throw new DavException(401);
        }
        return super.execute(request, response, method, resource);
    }

    public void init() throws ServletException {
        super.init();
        this.setLocatorFactory((DavLocatorFactory)new DavLocatorFactoryImpl(RESOURCE_PATH_PREFIX));
        this.setResourceFactory((DavResourceFactory)new JahiaResourceFactoryImpl(this.getLockManager(), this.getResourceConfig()));
    }

    private static String getDavMethod(int code) {
        switch (code) {
            case 2: {
                return "GET";
            }
            case 3: {
                return "HEAD";
            }
            case 7: {
                return "PROPFIND";
            }
            case 8: {
                return "PROPPATCH";
            }
            case 4: {
                return "POST";
            }
            case 6: {
                return "PUT";
            }
            case 5: {
                return "DELETE";
            }
            case 10: {
                return "COPY";
            }
            case 11: {
                return "MOVE";
            }
            case 9: {
                return "MKCOL";
            }
            case 1: {
                return "OPTIONS";
            }
            case 12: {
                return "LOCK";
            }
            case 13: {
                return "UNLOCK";
            }
            case 14: {
                return "ORDERPATCH";
            }
            case 15: {
                return "SUBSCRIBE";
            }
            case 16: {
                return "UNSUBSCRIBE";
            }
            case 17: {
                return "POLL";
            }
            case 18: {
                return "SEARCH";
            }
            case 20: {
                return "VERSION-CONTROL";
            }
            case 24: {
                return "LABEL";
            }
            case 19: {
                return "REPORT";
            }
            case 21: {
                return "CHECKIN";
            }
            case 22: {
                return "CHECKOUT";
            }
            case 23: {
                return "UNCHECKOUT";
            }
            case 25: {
                return "MERGE";
            }
            case 26: {
                return "UPDATE";
            }
            case 27: {
                return "MKWORKSPACE";
            }
            case 29: {
                return "MKACTIVITY";
            }
            case 28: {
                return "BASELINE-CONTROL";
            }
            case 30: {
                return "ACL";
            }
            case 31: {
                return "REBIND";
            }
            case 32: {
                return "UNBIND";
            }
            case 33: {
                return "BIND";
            }
        }
        return "unknown";
    }
}

