/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.jahia.ajax.gwt.commons.server.ChannelHolder;
import org.jahia.ajax.gwt.commons.server.JGroupsChannelImpl;
import org.jahia.settings.SettingsBean;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ChannelHolderImpl
implements InitializingBean,
DisposableBean,
ChannelHolder {
    private static final String JMX_DOMAIN_NAME = "JGroupsReplication";
    private static final Logger logger = LoggerFactory.getLogger(ChannelHolderImpl.class);
    private JGroupsChannelImpl channel;
    private String clusterName;

    public void afterPropertiesSet() throws Exception {
        if (SettingsBean.getInstance().isClusterActivated() && SettingsBean.getInstance().getBoolean("atmosphere.jgroups", true)) {
            JChannel jChannel = new JChannel(System.getProperty("cluster.configFile.jahia", "tcp.xml"));
            this.channel = new JGroupsChannelImpl(jChannel, this.clusterName);
            this.channel.init();
            this.registerMBeans();
        }
    }

    public void destroy() throws Exception {
        this.unregisterMBeans();
        this.channel.destroy();
    }

    @Override
    public JGroupsChannelImpl getChannel() {
        return this.channel;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private void registerMBeans() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer != null) {
            try {
                JmxConfigurator.registerChannel((JChannel)this.channel.jChannel, (MBeanServer)mBeanServer, (String)JMX_DOMAIN_NAME, (String)this.clusterName, (boolean)true);
            }
            catch (Exception e) {
                logger.warn("Unable to register JMX beans for the JGroups channel {} due to {}", (Object)this.clusterName, (Object)e.getMessage());
            }
        }
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    private void unregisterMBeans() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer != null) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)this.channel.jChannel, (MBeanServer)mBeanServer, (String)JMX_DOMAIN_NAME, (String)this.clusterName);
            }
            catch (Exception e) {
                logger.warn("Unable to unregister JMX beans for the JGroups channel {} due to {}", (Object)this.clusterName, (Object)e.getMessage());
            }
        }
    }
}

