/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.ajax.gwt.commons.server.JahiaRPC;
import org.jahia.ajax.gwt.commons.server.RequestResponseAware;
import org.jahia.bin.JahiaControllerUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class GWTController
extends RemoteServiceServlet
implements Controller,
ServletContextAware,
ApplicationContextAware {
    private static final String SESSION_ATTRIBUTE_PERMISSION_CHECK = "org.jahia.gwt.requiredPermission.ok";
    private static final long serialVersionUID = -74193665963116797L;
    private static final Logger logger = LoggerFactory.getLogger(GWTController.class);
    private String remoteServiceName;
    private Integer sessionExpiryTime = null;
    private ServletContext servletContext;
    private ApplicationContext applicationContext;
    private boolean allowPostMethodOnly = true;
    private boolean requireAuthenticatedUser = true;
    private String requiredPermission;
    private boolean requiredPermissionCheckCache = true;

    public void setSessionExpiryTime(int sessionExpiryTime) {
        this.sessionExpiryTime = sessionExpiryTime;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.allowPostMethodOnly && !"POST".equals(request.getMethod())) {
            response.sendError(404);
            return null;
        }
        if (this.requireAuthenticatedUser && JahiaUserManagerService.isGuest(JCRSessionFactory.getInstance().getCurrentUser()) || StringUtils.isNotEmpty((String)this.requiredPermission) && !this.isAllowed(request)) {
            if (logger.isDebugEnabled()) {
                JCRNodeWrapper targetNodeForPermissionCheck = this.getTargetNodeForPermissionCheck(request);
                logger.debug("Access rejected to {}, authentication is required {} and user is {} or user is not allowed to access {} with permission {}", new Object[]{this.remoteServiceName, this.requireAuthenticatedUser, JahiaUserManagerService.isGuest(JCRSessionFactory.getInstance().getCurrentUser()) ? "guest" : "not guest", targetNodeForPermissionCheck != null ? targetNodeForPermissionCheck.getPath() : "no target node found for this request: " + request.getRequestURI(), this.requiredPermission});
            }
            response.sendError(403);
            return null;
        }
        HttpSession session = request.getSession(false);
        if (session != null && this.sessionExpiryTime != null && session.getMaxInactiveInterval() != this.sessionExpiryTime * 60) {
            session.setMaxInactiveInterval(this.sessionExpiryTime * 60);
        }
        this.doPost(request, response);
        if (logger.isDebugEnabled()) {
            logger.debug("Handled request to GWT service '{}' in {} ms", (Object)this.remoteServiceName, (Object)(System.currentTimeMillis() - startTime));
        }
        return null;
    }

    private boolean isAllowed(HttpServletRequest request) {
        HttpSession session = null;
        if (this.requiredPermissionCheckCache && (session = request.getSession(false)) != null && session.getAttribute(SESSION_ATTRIBUTE_PERMISSION_CHECK) != null) {
            return true;
        }
        boolean debugEnabled = logger.isDebugEnabled();
        long startTime = debugEnabled ? System.currentTimeMillis() : 0L;
        boolean allowed = false;
        try {
            JCRNodeWrapper targetNode = this.getTargetNodeForPermissionCheck(request);
            JahiaUser currentUser = JCRSessionFactory.getInstance().getCurrentUser();
            boolean bl = allowed = targetNode != null && JahiaControllerUtils.hasRequiredPermission(targetNode, currentUser, this.requiredPermission);
            if (session != null) {
                if (allowed) {
                    session.setAttribute(SESSION_ATTRIBUTE_PERMISSION_CHECK, (Object)Boolean.TRUE);
                } else {
                    session.removeAttribute(SESSION_ATTRIBUTE_PERMISSION_CHECK);
                }
            }
            if (debugEnabled) {
                logger.debug("Checked permission for GWT service access and target node {} in {} ms. User {} with session {} is {}allowed to access it.", new Object[]{targetNode != null ? targetNode.getPath() : null, System.currentTimeMillis() - startTime, currentUser.getUsername(), session != null ? session.getId() : "undefined", allowed ? "" : "NOT "});
            }
        }
        catch (ItemNotFoundException targetNode) {
        }
        catch (RepositoryException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return allowed;
    }

    private JCRNodeWrapper getTargetNodeForPermissionCheck(HttpServletRequest request) {
        String siteId = request.getParameter("site");
        try {
            JCRSessionWrapper currentUserSession = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (StringUtils.isNotEmpty((String)siteId)) {
                return currentUserSession.getNodeByUUID(siteId);
            }
            JahiaSitesService siteService = JahiaSitesService.getInstance();
            JahiaSite defaultSite = siteService.getDefaultSite();
            if (defaultSite != null) {
                return (JCRSiteNode)defaultSite;
            }
            return currentUserSession.getRootNode();
        }
        catch (ItemNotFoundException currentUserSession) {
        }
        catch (RepositoryException e) {
            logger.warn("Unable to find target JCR node for permission check", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCall(String payload) throws SerializationException {
        RemoteService remoteService = null;
        RPCRequest rpcRequest = null;
        try {
            remoteService = (RemoteService)this.applicationContext.getBean(this.remoteServiceName);
            this.setServiceData(remoteService, false);
            rpcRequest = RPC.decodeRequest((String)payload, remoteService.getClass(), (SerializationPolicyProvider)this);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing method {}", (Object)rpcRequest.getMethod());
            }
            String string = JahiaRPC.invokeAndEncodeResponse(remoteService, rpcRequest.getMethod(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy());
            return string;
        }
        catch (Exception e) {
            if (rpcRequest != null) {
                logger.error("An error occurred calling the GWT service method " + rpcRequest.getMethod() + ". Cause: " + e.getMessage(), (Throwable)e);
            } else {
                logger.error("An error occurred calling the GWT service " + (remoteService != null ? remoteService.getClass().getName() : this.remoteServiceName) + ". Cause: " + e.getMessage(), (Throwable)e);
            }
            String string = RPC.encodeResponseForFailure(null, (Throwable)e);
            return string;
        }
        finally {
            if (remoteService != null) {
                this.setServiceData(remoteService, true);
            }
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        SerializationPolicy policy = super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
        if (policy == null) {
            return new SerializationPolicy(){

                public boolean shouldDeserializeFields(Class<?> clazz) {
                    return clazz != Object.class;
                }

                public boolean shouldSerializeFields(Class<?> clazz) {
                    return clazz != Object.class;
                }

                public void validateDeserialize(Class<?> clazz) throws SerializationException {
                }

                public void validateSerialize(Class<?> clazz) throws SerializationException {
                }
            };
        }
        return policy;
    }

    public void setRemoteServiceName(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }

    private void setServiceData(RemoteService remoteService, boolean cleanUp) {
        if (remoteService instanceof RequestResponseAware) {
            RequestResponseAware service = (RequestResponseAware)remoteService;
            service.setRequest(cleanUp ? null : this.getThreadLocalRequest());
            service.setResponse(cleanUp ? null : this.getThreadLocalResponse());
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void log(String message, Throwable t) {
        logger.error(message, t);
    }

    public void log(String msg) {
        logger.info(msg);
    }

    public void setAllowPostMethodOnly(boolean allowPostMethodOnly) {
        this.allowPostMethodOnly = allowPostMethodOnly;
    }

    public void setRequireAuthenticatedUser(boolean requireAuthenticatedUser) {
        this.requireAuthenticatedUser = requireAuthenticatedUser;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    public void setRequiredPermissionCheckCache(boolean requiredPermissionCheckCache) {
        this.requiredPermissionCheckCache = requiredPermissionCheckCache;
    }
}

