/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.atmosphere.cpr.Broadcaster;
import org.jahia.ajax.gwt.commons.server.BroadcastMessage;
import org.jahia.ajax.gwt.commons.server.JGroupsChannel;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsChannelImpl
extends ReceiverAdapter
implements JGroupsChannel {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsChannelImpl.class);
    final JChannel jChannel;
    private final String clusterName;
    private final Map<String, Broadcaster> broadcasters = new HashMap<String, Broadcaster>();
    private final ConcurrentLinkedQueue<Object> receivedMessages = new ConcurrentLinkedQueue();

    public JGroupsChannelImpl(JChannel jChannel, String clusterName) {
        if (jChannel.isConnected()) {
            throw new IllegalArgumentException("JChannel already connected");
        }
        this.jChannel = jChannel;
        this.clusterName = clusterName;
    }

    public void init() throws Exception {
        logger.info("Starting Atmosphere JGroups Clustering support with group name {}", (Object)this.clusterName);
        try {
            this.jChannel.setReceiver((Receiver)this);
            this.jChannel.connect(this.clusterName);
            this.jChannel.setDiscardOwnMessages(true);
        }
        catch (Exception e) {
            logger.warn("Failed to connect to cluster: {}", (Object)this.clusterName);
            throw e;
        }
    }

    public void destroy() {
        try {
            Util.shutdown((Channel)this.jChannel);
        }
        catch (Exception t) {
            Util.close((Channel)this.jChannel);
            logger.warn("failed to properly shutdown jgroups channel, closing abnormally", (Throwable)t);
        }
        this.receivedMessages.clear();
        this.broadcasters.clear();
    }

    public void receive(Message jgroupMessage) {
        Object payload = jgroupMessage.getObject();
        if (payload == null) {
            return;
        }
        if (JahiaContextLoaderListener.isContextInitialized() && BroadcastMessage.class.isAssignableFrom(payload.getClass())) {
            BroadcastMessage broadcastMsg = (BroadcastMessage)payload;
            Object origMessage = broadcastMsg.getMessage();
            SpringJackrabbitRepository.getInstance().syncClusterNode();
            this.receivedMessages.offer(origMessage);
            String topicId = broadcastMsg.getTopic();
            if (this.broadcasters.containsKey(topicId)) {
                Broadcaster bc = this.broadcasters.get(topicId);
                try {
                    bc.broadcast(origMessage).get();
                }
                catch (Exception ex) {
                    logger.error("Failed to broadcast message received over the JGroups cluster {}", (Object)this.clusterName, (Object)ex);
                }
            }
        }
    }

    @Override
    public void send(String topic, Object message) {
        if (this.jChannel.isConnected() && !this.receivedMessages.remove(message)) {
            try {
                BroadcastMessage broadcastMsg = new BroadcastMessage(topic, message);
                Message jgroupMsg = new Message(null, null, (Object)broadcastMsg);
                this.jChannel.send(jgroupMsg);
            }
            catch (Exception e) {
                logger.warn("Failed to send message {}", message, (Object)e);
            }
        }
    }

    public void addBroadcaster(Broadcaster broadcaster) {
        this.broadcasters.put(broadcaster.getID(), broadcaster);
    }

    public void removeBroadcaster(Broadcaster broadcaster) {
        this.broadcasters.remove(broadcaster.getID());
    }
}

