/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.content.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.IOUtils;
import org.jahia.ajax.gwt.content.server.UploadedPendingFile;
import org.jahia.ajax.gwt.helper.VersioningHelper;
import org.jahia.bin.SessionNamedDataStorage;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GWTFileManagerUploadServlet
extends HttpServlet {
    private static final int OK = 0;
    private static final int EXISTS = 1;
    private static final int READONLY = 2;
    private static final int BAD_LOCATION = 3;
    private static final int UNKNOWN_ERROR = 9;
    private static final Logger logger = LoggerFactory.getLogger(GWTFileManagerUploadServlet.class);
    private static final long serialVersionUID = 1048509772346464862L;
    private volatile SessionNamedDataStorage<UploadedPendingFile> fileStorage;

    private static long getContentLength(FileItemHeaders pHeaders) {
        try {
            return Long.parseLong(pHeaders.getHeader("Content-length"));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    /*
     * Exception decompiling
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeUploadedFile(String sessionID, final FileItem fileItem) {
        try (final BufferedInputStream contentStream = new BufferedInputStream(fileItem.getInputStream());){
            this.getFileStorage().put(sessionID, fileItem.getName(), new UploadedPendingFile(){

                @Override
                public String getContentType() {
                    return fileItem.getContentType();
                }

                @Override
                public InputStream getContentStream() {
                    return contentStream;
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private String getSizeLimitErrorMessage(long fileSizeLimit, FileUploadBase.FileSizeLimitExceededException e, HttpServletRequest request) {
        Locale locale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.uilocale");
        if (locale == null) {
            locale = (Locale)request.getSession().getAttribute("org.jahia.services.multilang.currentlocale");
        }
        if (logger.isDebugEnabled()) {
            logger.warn("File upload exceeding limit of {} bytes", (Object)fileSizeLimit, (Object)e);
        } else {
            logger.warn("File upload exceeding limit of {} bytes", (Object)fileSizeLimit);
        }
        return Messages.getInternalWithArguments("fileSizeError.label", "File upload exceeding limit of {0} bytes", locale, fileSizeLimit);
    }

    private String extractFileName(String rawFileName, Map<String, FileItem> uploads) {
        int und;
        String basename = rawFileName.indexOf("\\") >= 0 ? rawFileName.substring(rawFileName.lastIndexOf("\\") + 1) : (rawFileName.indexOf("/") >= 0 ? rawFileName.substring(rawFileName.lastIndexOf("/") + 1) : rawFileName);
        int i = 1;
        String name = basename;
        int dot = basename.lastIndexOf(46);
        String ext = "";
        if (dot > 0) {
            ext = basename.substring(dot);
            basename = basename.substring(0, dot);
        }
        if ((und = basename.lastIndexOf(45)) > -1 && basename.substring(und + 1).matches("[0-9]+")) {
            basename = basename.substring(0, und);
        }
        while (uploads.containsKey(name)) {
            name = basename + "-" + i++ + ext;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveToJcr(JahiaUser user, FileItem item, String location, StringBuilder name) throws IOException {
        JCRNodeWrapper locationFolder;
        String filename = name.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("item : {}", (Object)item);
            logger.debug("destination : {}", (Object)location);
            logger.debug("filename : {}", (Object)filename);
            logger.debug("size : {}", (Object)item.getSize());
        }
        if (item == null || location == null || filename == null) {
            return 9;
        }
        try {
            locationFolder = JCRSessionFactory.getInstance().getCurrentUserSession().getNode(location);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            return 3;
        }
        if (!locationFolder.hasPermission("jcr:addChildNodes") || locationFolder.isLocked()) {
            logger.debug("destination is not writable for user {}", (Object)(user == null ? null : user.getName()));
            return 2;
        }
        try {
            if (locationFolder.hasNode(JCRContentUtils.escapeLocalNodeName(filename))) {
                return 1;
            }
            InputStream is = item.getInputStream();
            try {
                boolean versioningAvailable = false;
                if (locationFolder.getProvider().isVersioningAvailable()) {
                    versioningAvailable = true;
                }
                if (versioningAvailable) {
                    locationFolder.getSession().checkout(locationFolder);
                }
                JCRNodeWrapper node = locationFolder.uploadFile(filename, is, JCRContentUtils.getMimeType(filename, item.getContentType()));
                node.getSession().save();
                if (!node.getName().equals(filename)) {
                    name.delete(0, name.length());
                    name.append(node.getName());
                }
                if ((node = node.getSession().getNodeByIdentifier(node.getIdentifier())).getProvider().isVersioningAvailable()) {
                    node.checkpoint();
                    JCRVersionService.getInstance().addVersionLabel(node, VersioningHelper.getVersionLabel(node.getProperty("jcr:created").getDate().getTime().getTime()));
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            locationFolder.saveSession();
        }
        catch (RepositoryException e) {
            logger.error("exception ", (Throwable)e);
            return 9;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionNamedDataStorage<UploadedPendingFile> getFileStorage() {
        if (this.fileStorage != null) {
            return this.fileStorage;
        }
        GWTFileManagerUploadServlet gWTFileManagerUploadServlet = this;
        synchronized (gWTFileManagerUploadServlet) {
            if (this.fileStorage != null) {
                return this.fileStorage;
            }
            WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            this.fileStorage = (SessionNamedDataStorage)context.getBean("UploadedPendingFileStorage");
            return this.fileStorage;
        }
    }
}

