/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.BaseFindController;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.Patterns;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindUser
extends BaseFindController {
    private static final Logger logger = LoggerFactory.getLogger(FindUser.class);
    protected Set<String> displayProperties = new HashSet<String>(Arrays.asList("j:lastName", "j:firstName"));
    protected Set<String> searchProperties = new HashSet<String>(Arrays.asList("j:lastName", "j:firstName", "username"));
    protected JahiaUserManagerService userService;

    public static String getFindUserServletPath() {
        return "/cms/findUser";
    }

    protected Properties buildSearchCriteria(String queryTerm) {
        Properties props = new Properties();
        for (String key : this.searchProperties) {
            props.put(key, queryTerm.contains("*") ? queryTerm : queryTerm + "*");
        }
        return props;
    }

    @Override
    protected void handle(HttpServletRequest request, HttpServletResponse response) throws JahiaForbiddenAccessException, IOException, JSONException {
        this.checkUserLoggedIn();
        this.checkUserAuthorized();
        boolean badQuery = false;
        String queryTerm = FindUser.getParameter(request, "q");
        if (queryTerm.length() < 1 || Patterns.STAR.matcher(queryTerm).replaceAll("").trim().length() < 1) {
            badQuery = true;
            if (!Boolean.valueOf(FindUser.getParameter(request, "emptyResultForBadQuery", "false")).booleanValue()) {
                throw new JahiaBadRequestException("Please specify more exact term for user search");
            }
        }
        Set<JCRNodeWrapper> result = !badQuery ? this.search(queryTerm, request) : Collections.emptySet();
        JCRNodeWrapper jcrNodeWrapper = null;
        String roles = null;
        if (!result.isEmpty()) {
            if (request.getParameter("node") != null) {
                try {
                    jcrNodeWrapper = JCRSessionFactory.getInstance().getCurrentUserSession().getNode(request.getParameter("node"));
                }
                catch (RepositoryException e) {
                    jcrNodeWrapper = null;
                }
            }
            roles = request.getParameter("roles");
        }
        this.writeResults(result, request, response, jcrNodeWrapper, roles);
    }

    protected Set<JCRNodeWrapper> search(String queryTerm, HttpServletRequest request) {
        return new HashSet<JCRNodeWrapper>(this.searchUsers(queryTerm));
    }

    protected Set<JCRUserNode> searchUsers(String queryTerm) {
        Properties searchCriterias = this.buildSearchCriteria(queryTerm);
        if (logger.isDebugEnabled()) {
            logger.debug("Performing user search using criteria: {}", (Object)searchCriterias);
        }
        Set<JCRUserNode> result = this.userService.searchUsers(searchCriterias);
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} matching users", (Object)result.size());
        }
        return result;
    }

    public void setDisplayProperties(Set<String> displayProperties) {
        this.displayProperties = displayProperties;
    }

    public void setJahiaUserManagerService(JahiaUserManagerService jahiaUserManagerService) {
        this.userService = jahiaUserManagerService;
    }

    public void setSearchProperties(Set<String> searchFields) {
        this.searchProperties = searchFields;
    }

    protected void sortResults(List<JSONObject> jsonResults) {
    }

    protected JSONObject toJSON(JCRUserNode user) throws JSONException {
        JSONObject json = new JSONObject();
        if (user != null) {
            json.put("userKey", (Object)user.getUserKey());
            json.put("username", (Object)user.getName());
            for (String key : this.displayProperties) {
                String value = user.getPropertyAsString(key);
                if (value == null) continue;
                json.put(key, (Object)value);
            }
        }
        return json;
    }

    protected JSONObject toJSON(JCRNodeWrapper principal) throws JSONException {
        return this.toJSON((JCRUserNode)principal);
    }

    protected void writeResults(Set<JCRNodeWrapper> users, HttpServletRequest request, HttpServletResponse response, JCRNodeWrapper jcrNodeWrapper, String roles) throws IOException, JSONException {
        response.setContentType("application/json; charset=UTF-8");
        LinkedList<JSONObject> jsonResults = new LinkedList<JSONObject>();
        int count = 0;
        List<Object> rolesForNode = Collections.emptyList();
        if (jcrNodeWrapper != null && roles != null) {
            rolesForNode = JCRContentUtils.getRolesForNode(jcrNodeWrapper, true, true, roles, 0, false);
        }
        for (JCRNodeWrapper user : users) {
            if (jcrNodeWrapper != null && roles != null) {
                for (Map map : rolesForNode) {
                    if (!map.get("principalType").equals("user") || !map.get("principal").equals(user)) continue;
                    jsonResults.add(this.toJSON(user));
                    ++count;
                }
            } else {
                jsonResults.add(this.toJSON(user));
                ++count;
            }
            if (count < this.hardLimit) continue;
            logger.info("{} principals were found, limiting results to {}", (Object)users.size(), (Object)this.hardLimit);
            break;
        }
        this.sortResults(jsonResults);
        JSONArray results = new JSONArray(jsonResults);
        results.write((Writer)response.getWriter());
    }
}

