/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jahia.bin.Jahia;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.ehcache.EhCacheImpl;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.jvm.ThreadMonitor;
import org.jahia.utils.FileUtils;
import org.jahia.utils.RequestLoadAverage;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorFileDumper {
    public static final FastDateFormat DATE_FORMAT_DIRECTORY = FastDateFormat.getInstance((String)"yyyy_MM_dd");
    public static final FastDateFormat DATE_FORMAT_FILE = FastDateFormat.getInstance((String)"yyyy_MM_dd-HH_mm_ss_SSS");
    private static final long MIN_INTERVAL_BETWEEN_QUEUE_WARNING = 1000L;
    private static final long MIN_INTERVAL_BETWEEN_HIGHLOAD_WARNING = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(ErrorFileDumper.class);
    private static final String PASSWORD = "password";
    private static Throwable previousException = null;
    private static int previousExceptionOccurrences = 0;
    private static long totalExceptionCount = 0L;
    private static volatile ExecutorService executorService;
    private static volatile int maximumTasksAllowed;
    private static volatile double highLoadBoundary;
    private static volatile int tasksSubmitted;
    private static volatile long lastCallToDump;
    private static volatile long lastHighLoadMessageTime;

    public static void start() {
        if (ErrorFileDumper.isShutdown()) {
            executorService = Executors.newSingleThreadExecutor(new LowPriorityThreadFactory());
            System.out.println("Started error file dumper executor service");
        }
    }

    public static void shutdown() {
        ErrorFileDumper.shutdown(100L);
    }

    public static void shutdown(long millisecondsToWait) {
        if (!ErrorFileDumper.isShutdown()) {
            System.out.println("Shutting down error file dumper executor service...");
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(millisecondsToWait, TimeUnit.MILLISECONDS)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            executorService = null;
            System.out.println("...done shutting down error file dumper executor service.");
        }
    }

    public static boolean isShutdown() {
        return executorService == null;
    }

    public static void setFileDumpActivated(boolean fileDumpActivated) {
        if (fileDumpActivated && ErrorFileDumper.isShutdown()) {
            ErrorFileDumper.start();
        } else if (!fileDumpActivated && ErrorFileDumper.isFileDumpActivated()) {
            ErrorFileDumper.shutdown();
        }
    }

    public static boolean isFileDumpActivated() {
        return !ErrorFileDumper.isShutdown();
    }

    public static void dumpToFile(Throwable t, HttpServletRequest request) throws IOException {
        if (ErrorFileDumper.isShutdown()) {
            return;
        }
        if (ErrorFileDumper.isHighLoad()) {
            return;
        }
        int maxTasks = maximumTasksAllowed;
        if (tasksSubmitted < maxTasks) {
            HttpRequestData requestData = null;
            if (request != null) {
                requestData = new HttpRequestData(request);
            }
            executorService.submit(new FileDumperRunnable(t, requestData));
            ++tasksSubmitted;
            lastCallToDump = System.currentTimeMillis();
        } else {
            long now = System.currentTimeMillis();
            if (now - lastCallToDump > 1000L) {
                System.out.println(maxTasks + " error dumps already submitted, not allowing any more.");
                lastCallToDump = now;
            }
        }
    }

    public static int getMaximumTasksAllowed() {
        return maximumTasksAllowed;
    }

    public static void setMaximumTasksAllowed(int maximumTasksAllowed) {
        ErrorFileDumper.maximumTasksAllowed = maximumTasksAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performDumpToFile(Throwable exception, HttpRequestData httpRequestData) throws IOException {
        long dumpStartTime = System.currentTimeMillis();
        Class<ErrorFileDumper> clazz = ErrorFileDumper.class;
        synchronized (ErrorFileDumper.class) {
            SettingsBean settings;
            if (previousException != null && exception != null && exception.getClass().equals(previousException.getClass()) && exception.toString().equals(previousException.toString()) && (settings = SettingsBean.getInstance()) != null && ++previousExceptionOccurrences < settings.getFileDumpMaxRegroupingOfPreviousException()) {
                // ** MonitorExit[var8_3] (shouldn't be in output)
                return;
            }
            Throwable previousExceptionToDump = previousException;
            int previousExceptionOccurencesToDump = previousExceptionOccurrences;
            previousException = exception;
            previousExceptionOccurrences = 1;
            long momentaryTotalExceptionCount = ++totalExceptionCount;
            // ** MonitorExit[var8_3] (shouldn't be in output)
            StringWriter errorWriter = ErrorFileDumper.generateErrorReport(httpRequestData, exception, previousExceptionOccurencesToDump, previousExceptionToDump);
            File errorFile = ErrorFileDumper.getNextErrorFile(momentaryTotalExceptionCount);
            org.apache.commons.io.FileUtils.writeStringToFile((File)errorFile, (String)errorWriter.toString(), (String)"UTF-8");
            long dumpTotalTime = System.currentTimeMillis() - dumpStartTime;
            System.err.println("Error dumped to file " + errorFile.getAbsolutePath() + " in " + dumpTotalTime + "ms");
            return;
        }
    }

    private static File getNextErrorFile(long exceptionCount) {
        Date now = new Date();
        File todaysDirectory = new File(SettingsBean.getErrorDir(), DATE_FORMAT_DIRECTORY.format(now));
        todaysDirectory.mkdirs();
        return new File(todaysDirectory, "error-" + DATE_FORMAT_FILE.format(now) + "-" + Long.toString(exceptionCount) + ".txt");
    }

    private static File getNextHeapDumpFile() {
        Date now = new Date();
        File todaysDirectory = new File(SettingsBean.getHeapDir(), DATE_FORMAT_DIRECTORY.format(now));
        todaysDirectory.mkdirs();
        return new File(todaysDirectory, "heap-" + DATE_FORMAT_FILE.format(now) + ".hprof");
    }

    public static StringWriter generateErrorReport(HttpRequestData requestData, Throwable exception, int previousExceptionOccurences, Throwable previousException) {
        StringWriter msgBodyWriter = new StringWriter();
        if (ErrorFileDumper.isHighLoad()) {
            return msgBodyWriter;
        }
        PrintWriter strOut = new PrintWriter(msgBodyWriter);
        if (previousExceptionOccurences > 1) {
            strOut.println("");
            strOut.println("The previous error: " + previousException.getMessage() + " occured " + Integer.toString(previousExceptionOccurences) + " times.");
            strOut.println("");
        }
        strOut.println("");
        strOut.println("Your Server has generated an error. Please review the details below for additional information: ");
        strOut.println("");
        if (exception instanceof JahiaException) {
            JahiaException nje = (JahiaException)exception;
            String severityMsg = "Undefined";
            switch (nje.getSeverity()) {
                case 1: {
                    severityMsg = "WARNING";
                    break;
                }
                case 2: {
                    severityMsg = "ERROR";
                    break;
                }
                case 3: {
                    severityMsg = "CRITICAL";
                    break;
                }
                case 4: {
                    severityMsg = "FATAL";
                }
            }
            strOut.println("Severity: " + severityMsg);
        }
        strOut.println("");
        if (exception != null) {
            strOut.println("Error: " + exception.getMessage());
        }
        strOut.println("");
        if (requestData != null) {
            strOut.println("URL: " + requestData.getRequestURL());
            if (requestData.getQueryString() != null) {
                strOut.println("?" + requestData.getQueryString());
            }
            strOut.println("");
            strOut.println("Method: " + requestData.getMethod());
            strOut.println("");
            strOut.println("Remote host: " + requestData.getRemoteHost() + "     Remote Address: " + requestData.getRemoteAddr());
            strOut.println("");
            strOut.println("Request headers:");
            strOut.println("-----------------");
            for (Map.Entry<String, String> headerEntry : requestData.getHeaders().entrySet()) {
                strOut.println("   " + headerEntry.getKey() + " : " + headerEntry.getValue());
            }
        }
        strOut.println("");
        strOut.println("Stack trace:");
        strOut.println("-------------");
        String stackTraceStr = ErrorFileDumper.stackTraceToString(exception);
        strOut.println(stackTraceStr);
        ErrorFileDumper.outputSystemInfo(strOut);
        strOut.println("");
        strOut.println("Depending on the severity of this error, server may still be operational or not. Please check your");
        strOut.println("installation as soon as possible.");
        strOut.println("");
        strOut.println("Yours Faithfully, ");
        strOut.println("    Server Notification Service");
        return msgBodyWriter;
    }

    public static void outputSystemInfo(PrintWriter strOut) {
        ErrorFileDumper.outputSystemInfoConsiderLoad(strOut);
    }

    public static double getHighLoadBoundary() {
        return highLoadBoundary;
    }

    public static void setHighLoadBoundary(double highLoadBoundary) {
        ErrorFileDumper.highLoadBoundary = highLoadBoundary;
    }

    private static void outputSystemInfoConsiderLoad(PrintWriter strOut) {
        boolean highLoad = ErrorFileDumper.isHighLoad();
        ErrorFileDumper.outputSystemInfo(strOut, !highLoad, false, !highLoad, !highLoad, !highLoad, !highLoad, !highLoad, true);
    }

    private static boolean isHighLoad() {
        boolean highLoad = false;
        RequestLoadAverage loadAverage = RequestLoadAverage.getInstance();
        boolean bl = highLoad = loadAverage != null && loadAverage.getOneMinuteLoad() > highLoadBoundary;
        if (highLoad) {
            long now = System.currentTimeMillis();
            if (now - lastHighLoadMessageTime > 1000L) {
                System.out.println("High load (" + loadAverage.getOneMinuteLoad() + ") detected, will deactivate reporting...");
            }
            lastHighLoadMessageTime = System.currentTimeMillis();
        }
        return highLoad;
    }

    public static void outputSystemInfo(PrintWriter strOut, boolean systemProperties, boolean jahiaSettings, boolean memory, boolean caches, boolean threads, boolean deadlocks, boolean loadAverage) {
        ErrorFileDumper.outputSystemInfo(strOut, systemProperties, false, jahiaSettings, memory, caches, threads, deadlocks, loadAverage);
    }

    public static void outputSystemInfo(PrintWriter strOut, boolean systemProperties, boolean environmentVariables, boolean jahiaSettings, boolean memory, boolean caches, boolean threads, boolean deadlocks, boolean loadAverage) {
        String curPropertyValue;
        TreeMap<Object, Object> orderedProperties;
        if (systemProperties) {
            strOut.println();
            strOut.println("System properties:");
            strOut.println("-------------------");
            orderedProperties = new TreeMap<Object, Object>(System.getProperties());
            for (Map.Entry curEntry : orderedProperties.entrySet()) {
                String string = (String)curEntry.getKey();
                curPropertyValue = (String)curEntry.getValue();
                if (string.toLowerCase().contains(PASSWORD)) continue;
                strOut.println("   " + string + " : " + curPropertyValue);
            }
        }
        if (environmentVariables) {
            strOut.println();
            strOut.println("Environment variables:");
            strOut.println("-------------------");
            orderedProperties = new TreeMap<String, String>(System.getenv());
            for (Map.Entry curEntry : orderedProperties.entrySet()) {
                String string = (String)curEntry.getKey();
                curPropertyValue = (String)curEntry.getValue();
                if (string.toLowerCase().contains(PASSWORD)) continue;
                strOut.println("   " + string + " : " + curPropertyValue);
            }
        }
        if (jahiaSettings) {
            strOut.println();
            if (SettingsBean.getInstance() != null) {
                strOut.append("Server configuration (").append(Jahia.getFullProductVersion()).append(" - ").append(Jahia.getBuildDate()).append("):");
                strOut.println();
                strOut.println("---------------------");
                SettingsBean settings = SettingsBean.getInstance();
                TreeMap<Object, Object> jahiaOrderedProperties = new TreeMap<Object, Object>(settings.getPropertiesFile());
                for (Map.Entry entry : jahiaOrderedProperties.entrySet()) {
                    String curPropertyName2 = (String)entry.getKey();
                    String curPropertyValue2 = null;
                    curPropertyValue2 = entry.getValue() == null ? null : (entry.getValue() instanceof String ? (String)entry.getValue() : entry.getValue().toString());
                    if (curPropertyName2.toLowerCase().contains(PASSWORD) || "mail_server".equals(curPropertyName2) && (StringUtils.contains((String)curPropertyValue2, (String)"&password=") || StringUtils.contains((String)curPropertyValue2, (String)"?password="))) continue;
                    strOut.println("   " + curPropertyName2 + " = " + curPropertyValue2);
                }
                if (settings.getStartupOptions() != null && !settings.getStartupOptions().getOptions().isEmpty()) {
                    strOut.println();
                    strOut.append("Server startup options:");
                    strOut.println();
                    strOut.println("---------------------");
                    strOut.println(StringUtils.join(settings.getStartupOptions().getOptions(), (String)", "));
                }
            }
        }
        if (memory) {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
            ErrorFileDumper.printMemoryUsage(MemoryType.HEAP.toString(), memoryUsage, strOut);
            memoryUsage = memoryMXBean.getNonHeapMemoryUsage();
            ErrorFileDumper.printMemoryUsage(MemoryType.NON_HEAP.toString(), memoryUsage, strOut);
            strOut.println("--------------");
            strOut.println("Memory pool details");
            strOut.println("--------------");
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean bean : memoryPoolMXBeans) {
                ErrorFileDumper.printMemoryUsage("Memory Pool \"" + bean.getName() + "\" (" + bean.getType().toString() + ")", bean.getUsage(), strOut);
            }
        }
        if (caches) {
            strOut.println();
            DecimalFormat percentFormat = new DecimalFormat("###.##");
            if (SpringContextSingleton.getInstance().isInitialized() && ServicesRegistry.getInstance().getCacheService() != null) {
                strOut.println("Cache status:");
                strOut.println("--------------");
                TreeSet<String> sortedCacheNames = new TreeSet<String>(ServicesRegistry.getInstance().getCacheService().getNames());
                for (String string : sortedCacheNames) {
                    Cache objectCache = ServicesRegistry.getInstance().getCacheService().getCache(string);
                    if (objectCache == null || objectCache.getCacheImplementation() instanceof EhCacheImpl) continue;
                    String efficiencyStr = "0";
                    if (!Double.isNaN(objectCache.getCacheEfficiency())) {
                        efficiencyStr = percentFormat.format(objectCache.getCacheEfficiency());
                    }
                    strOut.println(string + ": size=" + objectCache.size() + ", successful hits=" + objectCache.getSuccessHits() + ", total hits=" + objectCache.getTotalHits() + ", efficiency=" + efficiencyStr + "%");
                }
            }
            List cacheManagers = CacheManager.ALL_CACHE_MANAGERS;
            for (CacheManager cacheManager : cacheManagers) {
                Object[] ehcacheNames = cacheManager.getCacheNames();
                Arrays.sort(ehcacheNames);
                for (Object ehcacheName : ehcacheNames) {
                    Ehcache ehcache = cacheManager.getEhcache((String)ehcacheName);
                    strOut.append((CharSequence)ehcacheName).append(": ");
                    if (ehcache == null) continue;
                    StatisticsGateway ehcacheStats = ehcache.getStatistics();
                    String efficiencyStr = "0";
                    if (ehcacheStats.cacheHitCount() + ehcacheStats.cacheMissCount() > 0L) {
                        efficiencyStr = percentFormat.format((float)ehcacheStats.cacheHitCount() * 100.0f / (float)(ehcacheStats.cacheHitCount() + ehcacheStats.cacheMissCount()));
                    }
                    strOut.append("size=" + ehcacheStats.getSize() + ", successful hits=" + ehcacheStats.cacheHitCount() + ", total hits=" + (ehcacheStats.cacheHitCount() + ehcacheStats.cacheMissCount()) + ", efficiency=" + efficiencyStr + "%");
                    strOut.println();
                }
            }
        }
        ThreadMonitor threadMonitor = null;
        if (threads) {
            strOut.println();
            strOut.println("Thread status:");
            strOut.println("--------------");
            threadMonitor = ThreadMonitor.getInstance();
            threadMonitor.generateThreadInfo(strOut);
        }
        if (deadlocks) {
            strOut.println();
            strOut.println("Deadlock status:");
            threadMonitor = threadMonitor != null ? threadMonitor : ThreadMonitor.getInstance();
            String deadlock = threadMonitor.findDeadlock();
            strOut.println(deadlock != null ? deadlock : "none");
        }
        if (loadAverage) {
            strOut.println();
            strOut.println("Request load average:");
            strOut.println("---------------------");
            RequestLoadAverage info = RequestLoadAverage.getInstance();
            if (info != null) {
                strOut.println("Over one minute=" + info.getOneMinuteLoad() + " Over five minute=" + info.getFiveMinuteLoad() + " Over fifteen minute=" + info.getFifteenMinuteLoad());
            } else {
                strOut.println("not available");
            }
            strOut.println();
        }
        strOut.flush();
    }

    private static void printMemoryUsage(String type, MemoryUsage usage, PrintWriter strOut) {
        strOut.println();
        strOut.print(type);
        strOut.print(" : ");
        strOut.print(Math.round((float)usage.getUsed() / (float)usage.getMax() * 100.0f));
        strOut.println("% used");
        strOut.println("---------------");
        strOut.print("Used      : ");
        strOut.println(FileUtils.humanReadableByteCount(usage.getUsed(), true));
        strOut.print("Committed : ");
        strOut.println(FileUtils.humanReadableByteCount(usage.getCommitted(), true));
        strOut.print("Max       : ");
        strOut.println(FileUtils.humanReadableByteCount(usage.getMax(), true));
    }

    protected static String stackTraceToString(Throwable t) {
        int nestingDepth = ErrorFileDumper.getNestedExceptionDepth(t, 0);
        return ErrorFileDumper.recursiveStackTraceToString(t, nestingDepth);
    }

    protected static String recursiveStackTraceToString(Throwable t, int curDepth) {
        if (t == null) {
            return "";
        }
        StringWriter msgBodyWriter = new StringWriter();
        PrintWriter strOut = new PrintWriter(msgBodyWriter);
        Throwable innerThrowable = t.getCause();
        if (innerThrowable != null) {
            String innerExceptionTrace = ErrorFileDumper.recursiveStackTraceToString(innerThrowable, curDepth - 1);
            msgBodyWriter.write(innerExceptionTrace);
        }
        if (curDepth == 0) {
            strOut.println("Cause level : " + curDepth + " (level 0 is the most precise exception)");
        } else {
            strOut.println("Cause level : " + curDepth);
        }
        t.printStackTrace(strOut);
        return msgBodyWriter.toString();
    }

    protected static int getNestedExceptionDepth(Throwable t, int curDepth) {
        if (t == null) {
            return curDepth;
        }
        int newDepth = curDepth;
        Throwable innerThrowable = t.getCause();
        if (innerThrowable != null) {
            newDepth = ErrorFileDumper.getNestedExceptionDepth(innerThrowable, curDepth + 1);
        }
        return newDepth;
    }

    public static boolean isHeapDumpSupported() throws MalformedObjectNameException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName hotSpotDiagnostic = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        return mBeanServer.isRegistered(hotSpotDiagnostic);
    }

    public static File performHeapDump() throws MalformedObjectNameException, InstanceNotFoundException, ReflectionException, MBeanException {
        ObjectName hotSpotDiagnostic;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (!mBeanServer.isRegistered(hotSpotDiagnostic = new ObjectName("com.sun.management:type=HotSpotDiagnostic"))) {
            throw new UnsupportedOperationException("Unable to find the 'com.sun.management:type=HotSpotDiagnostic' managed bean to perform heap dump");
        }
        File hprofFilePath = ErrorFileDumper.getNextHeapDumpFile();
        mBeanServer.invoke(hotSpotDiagnostic, "dumpHeap", new Object[]{hprofFilePath.getPath(), Boolean.TRUE}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
        return hprofFilePath;
    }

    static {
        maximumTasksAllowed = 100;
        highLoadBoundary = 10.0;
        tasksSubmitted = 0;
        lastCallToDump = 0L;
        lastHighLoadMessageTime = 0L;
    }

    private static class FileDumperRunnable
    implements Runnable {
        private Throwable t;
        private HttpRequestData requestData;

        public FileDumperRunnable(Throwable t, HttpRequestData requestData) {
            this.t = t;
            this.requestData = requestData;
        }

        @Override
        public void run() {
            try {
                ErrorFileDumper.performDumpToFile(this.t, this.requestData);
                tasksSubmitted--;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class HttpRequestData {
        private String requestURL;
        private String queryString;
        private String method;
        private Map<String, String> headers = new HashMap<String, String>();
        private String remoteHost;
        private String remoteAddr;

        public HttpRequestData(HttpServletRequest request) {
            String originalRequestUri = (String)request.getAttribute("javax.servlet.forward.request_uri");
            this.requestURL = originalRequestUri == null ? request.getRequestURI() : originalRequestUri;
            String originalQueryString = (String)request.getAttribute("javax.servlet.forward.query_string");
            this.queryString = originalQueryString == null ? Encode.forJava((String)request.getQueryString()) : Encode.forJava((String)originalQueryString);
            this.method = request.getMethod();
            this.remoteHost = request.getRemoteHost();
            this.remoteAddr = request.getRemoteAddr();
            EnumerationIterator headerNames = new EnumerationIterator(request.getHeaderNames());
            while (headerNames.hasNext()) {
                String headerName = (String)headerNames.next();
                String headerValue = request.getHeader(headerName);
                this.headers.put(headerName, headerValue);
            }
        }

        public String getRequestURL() {
            return this.requestURL;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getMethod() {
            return this.method;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }
    }

    private static class LowPriorityThreadFactory
    implements ThreadFactory {
        private LowPriorityThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread lowPriorityThread = new Thread(runnable);
            lowPriorityThread.setName("LowPriorityThread");
            lowPriorityThread.setPriority(1);
            lowPriorityThread.setName("ErrorFileDumperThread");
            return lowPriorityThread;
        }
    }
}

