/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractServletFilter
implements Filter,
Comparable<AbstractServletFilter>,
BeanNameAware {
    private String[] urlPatterns;
    private boolean matchAllUrls = false;
    private float order = 0.0f;
    private String beanName;
    private String filterName;
    private Set<String> dispatcherTypes = Collections.singleton(DispatcherType.REQUEST.name());
    private Map<String, String> parameters = new HashMap<String, String>();

    public void init(ServletContext servletContext) throws ServletException {
        this.init(new FilterConfigImpl(servletContext));
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(String[] urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public boolean isMatchAllUrls() {
        return this.matchAllUrls;
    }

    public void setMatchAllUrls(boolean matchAllUrls) {
        this.matchAllUrls = matchAllUrls;
    }

    public float getOrder() {
        return this.order;
    }

    public void setOrder(float order) {
        this.order = order;
    }

    public String getFilterName() {
        return this.filterName != null ? this.filterName : this.beanName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Set<String> getDispatcherTypes() {
        return this.dispatcherTypes;
    }

    public void setDispatcherTypes(Set<String> dispatcherTypes) {
        this.dispatcherTypes = dispatcherTypes;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int compareTo(AbstractServletFilter other) {
        int result = Float.compare(this.getOrder(), other.getOrder());
        return result != 0 ? result : this.getClass().getName().compareTo(other.getClass().getName());
    }

    private class FilterConfigImpl
    implements FilterConfig {
        private ServletContext servletContext;

        public FilterConfigImpl(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public String getFilterName() {
            return AbstractServletFilter.this.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String s) {
            return (String)AbstractServletFilter.this.parameters.get(s);
        }

        public Enumeration<String> getInitParameterNames() {
            return new Vector(AbstractServletFilter.this.parameters.keySet()).elements();
        }
    }
}

