/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpHeadRequestFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if ("HEAD".equals(httpServletRequest.getMethod())) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            NoBodyResponseWrapper noBodyResponseWrapper = new NoBodyResponseWrapper(httpServletResponse);
            chain.doFilter((ServletRequest)new GetRequestWrapper(httpServletRequest), (ServletResponse)noBodyResponseWrapper);
            noBodyResponseWrapper.setContentLength();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private class GetRequestWrapper
    extends HttpServletRequestWrapper {
        GetRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getMethod() {
            return "GET";
        }
    }

    private class NoBodyOutputStream
    extends ServletOutputStream {
        private int contentLength = 0;

        NoBodyOutputStream() {
        }

        int getContentLength() {
            return this.contentLength;
        }

        public void write(int b) {
            ++this.contentLength;
        }

        public void write(byte[] buf, int offset, int len) throws IOException {
            if (len >= 0) {
                this.contentLength += len;
            } else {
                throw new IOException("Negative Length given in write method");
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }

    private class NoBodyResponseWrapper
    extends HttpServletResponseWrapper {
        private NoBodyOutputStream noBody;
        private PrintWriter writer;
        private boolean didSetContentLength;
        private boolean usingOutputStream;

        NoBodyResponseWrapper(HttpServletResponse r) {
            super(r);
            this.noBody = new NoBodyOutputStream();
        }

        void setContentLength() {
            if (!this.didSetContentLength) {
                if (this.writer != null) {
                    this.writer.flush();
                }
                this.setContentLength(this.noBody.getContentLength());
            }
        }

        public void setContentLength(int len) {
            super.setContentLength(len);
            this.didSetContentLength = true;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("Illegal to call getOutputStream() after getWriter() has been called");
            }
            this.usingOutputStream = true;
            return this.noBody;
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.usingOutputStream) {
                throw new IllegalStateException("Illegal to call getWriter() after getOutputStream() has been called");
            }
            if (this.writer == null) {
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)((Object)this.noBody), this.getCharacterEncoding());
                this.writer = new PrintWriter(w);
            }
            return this.writer;
        }
    }
}

