/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.karaf.main.Main;
import org.apache.karaf.util.config.PropertiesLoader;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.BundleStarter;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.SpringContextSingleton;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.ScriptEngineUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.util.PropertyPlaceholderHelper;

public final class FrameworkService
implements FrameworkListener {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkService.class);
    public static final String EVENT_TOPIC_LIFECYCLE = "org/jahia/dx/lifecycle";
    public static final String EVENT_TYPE_CLUSTERING_FEATURE_INSTALLED = "clusteringFeatureInstalled";
    public static final String EVENT_TYPE_INITIAL_START_LEVEL_REACHED = "initialStartLevelReached";
    public static final String EVENT_TYPE_FILEINSTALL_STARTED = "fileInstallStarted";
    public static final String EVENT_TYPE_SPRING_BRIDGE_STARTED = "springBridgeStarted";
    public static final String EVENT_TYPE_CLUSTER_STARTED = "clusterStarted";
    public static final String EVENT_TYPE_FINAL_START_LEVEL_REACHED = "finalStartLevelReached";
    private final ServletContext servletContext;
    private boolean firstStartup;
    private Main main;
    private long startTime;
    private int initialFrameworkStartLevel = 80;
    private int finalFrameworkStartLevel = 100;
    private long osgiStartupWaitTimeout;
    private BundleStarter bundleStarter;
    private Timer startLevelTimer = new Timer("OSGi-FrameworkService-Startup-Timer", true);
    private final CountDownLatch initialStartLevelReachedLatch = new CountDownLatch(1);
    private final CountDownLatch fileInstallStartedLatch = new CountDownLatch(1);
    private final CountDownLatch springBridgeStartedLatch = new CountDownLatch(1);
    private final CountDownLatch finalStartLevelReachedLatch = new CountDownLatch(1);
    private final CountDownLatch clusterStartedLatch = new CountDownLatch(1);

    private FrameworkService(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static BundleContext getBundleContext() {
        FrameworkService instance = FrameworkService.getInstance();
        if (instance != null && instance.main != null) {
            return instance.main.getFramework().getBundleContext();
        }
        return null;
    }

    public static FrameworkService getInstance() {
        return Holder.INSTANCE;
    }

    public static void sendEvent(String topic, Map<String, ?> properties, boolean asynchronous) {
        Object service;
        BundleContext context = FrameworkService.getBundleContext();
        if (context != null && (service = BundleUtils.getOsgiService(EventAdmin.class.getName(), null)) != null) {
            try {
                ClassLoader classLoader = service.getClass().getClassLoader();
                Object evt = classLoader.loadClass("org.osgi.service.event.Event").getConstructor(String.class, Map.class).newInstance(topic, properties);
                logger.info("Sending {} event with the properties {} to the topic {}...", new Object[]{asynchronous ? "asynchronous" : "synchronous", properties, topic});
                MethodUtils.invokeExactMethod((Object)service, (String)(asynchronous ? "postEvent" : "sendEvent"), evt);
                logger.info("Event sent to the topic {}", (Object)topic);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public boolean isStarted() {
        return this.finalStartLevelReachedLatch.getCount() == 0L;
    }

    public boolean isFirstStartup() {
        return this.firstStartup;
    }

    private void setupStartupListener() {
        this.initialFrameworkStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
        this.osgiStartupWaitTimeout = Long.getLong("org.jahia.osgi.startupWaitTimeout", 600000L);
        try {
            Map<String, BundleListener> m = SpringContextSingleton.getBeansOfType(BundleListener.class);
            for (BundleListener value : m.values()) {
                this.main.getFramework().getBundleContext().addBundleListener(value);
            }
        }
        catch (BeansException e) {
            logger.warn("Error when getting framework listeners", (Throwable)e);
        }
        this.main.getFramework().getBundleContext().addFrameworkListener((FrameworkListener)this);
        this.startLevelTimer.schedule((TimerTask)new StartLevelChecker(), 1000L, 1000L);
    }

    private void setupSystemProperties() {
        Map unreplaced = (Map)SpringContextSingleton.getBean("osgiProperties");
        TreeMap newSystemProperties = new TreeMap();
        PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}");
        Properties systemProps = System.getProperties();
        for (Map.Entry entry : unreplaced.entrySet()) {
            newSystemProperties.put(entry.getKey(), placeholderHelper.replacePlaceholders((String)entry.getValue(), systemProps));
        }
        for (Map.Entry property : newSystemProperties.entrySet()) {
            boolean valueHasChanged;
            String propertyName = (String)property.getKey();
            String oldPropertyValue = System.getProperty(propertyName);
            String newPropertyValue = (String)property.getValue();
            boolean bl = valueHasChanged = oldPropertyValue != null && !StringUtils.equals((String)oldPropertyValue, (String)newPropertyValue);
            if (valueHasChanged) {
                logger.warn("Overriding system property {}={} with new value={}", new Object[]{propertyName, oldPropertyValue, newPropertyValue});
            }
            if (oldPropertyValue != null && !valueHasChanged) continue;
            JahiaContextLoaderListener.setSystemProperty(propertyName, newPropertyValue);
        }
        File file = new File(System.getProperty("karaf.etc"), "config.properties");
        org.apache.felix.utils.properties.Properties karafConfigProperties = null;
        try {
            karafConfigProperties = PropertiesLoader.loadConfigProperties((File)file);
        }
        catch (Exception e) {
            logger.error("Unable to load properties from file {}. Cause: {}", new Object[]{file, e.getMessage(), e});
            karafConfigProperties = new org.apache.felix.utils.properties.Properties();
        }
        StringBuilder extraSystemPackages = new StringBuilder(karafConfigProperties.getProperty("org.osgi.framework.system.packages.extra"));
        boolean modifiedExtraSystemPackages = false;
        for (Map.Entry entry : newSystemProperties.entrySet()) {
            if (!((String)entry.getKey()).startsWith("org.osgi.framework.system.packages.extra.")) continue;
            extraSystemPackages.append(',').append((String)entry.getValue());
            modifiedExtraSystemPackages = true;
        }
        if (modifiedExtraSystemPackages) {
            JahiaContextLoaderListener.setSystemProperty("org.osgi.framework.system.packages.extra", extraSystemPackages.toString());
        }
    }

    public void start() {
        try {
            this.updateFileReferencesIfNeeded();
        }
        catch (Exception e) {
            logger.error("Error updating file references", (Throwable)e);
        }
        this.startTime = System.currentTimeMillis();
        logger.info("Starting OSGi platform service");
        this.startKaraf();
        this.servletContext.setAttribute(BundleContext.class.getName(), (Object)this.main.getFramework().getBundleContext());
    }

    private void startKaraf() {
        try {
            this.setupSystemProperties();
            this.firstStartup = !new File(System.getProperty("org.osgi.framework.storage"), "bundle0").exists();
            this.bundleStarter = new BundleStarter();
            this.main = new Main(new String[0]);
            this.main.launch();
            this.setupStartupListener();
            this.bundleStarter.startInitialBundlesIfNeeded();
        }
        catch (Exception e) {
            this.main = null;
            logger.error("Error starting OSGi container");
            throw new JahiaRuntimeException("Error starting OSGi container", e);
        }
    }

    public void stop() throws BundleException {
        if (this.main != null) {
            this.destroyTimer();
            this.servletContext.removeAttribute(BundleContext.class.getName());
            try {
                this.main.destroy();
            }
            catch (Exception e) {
                logger.error("Error shutting down Karaf framework", (Throwable)e);
            }
        }
        logger.info("OSGi framework stopped");
    }

    private void destroyTimer() {
        if (this.startLevelTimer != null) {
            try {
                this.startLevelTimer.cancel();
            }
            catch (Exception e) {
                logger.warn("Error terminating timer thread", (Throwable)e);
            }
            finally {
                this.startLevelTimer = null;
            }
        }
    }

    private void updateFileReferencesIfNeeded() {
        ScriptEngine scriptEngine;
        File script = new File(SettingsBean.getInstance().getJahiaVarDiskPath() + "/scripts/groovy/updateFileReferences.groovy");
        if (!script.isFile()) {
            return;
        }
        try {
            scriptEngine = ScriptEngineUtils.getInstance().scriptEngine(FilenameUtils.getExtension((String)script.getName()));
        }
        catch (ScriptException e) {
            throw new JahiaRuntimeException(e);
        }
        if (scriptEngine == null) {
            throw new IllegalStateException("No script engine available");
        }
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("log", (Object)logger);
        bindings.put("logger", (Object)logger);
        scriptContext.setBindings(bindings, 100);
        try (FileInputStream scriptInputStream = new FileInputStream(script);
             InputStreamReader scriptReader = new InputStreamReader((InputStream)scriptInputStream, StandardCharsets.UTF_8);
             StringWriter out = new StringWriter();){
            scriptContext.setWriter(out);
            scriptEngine.eval((Reader)scriptReader, (ScriptContext)scriptContext);
        }
        catch (IOException | ScriptException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8 && BundleLifecycleUtils.getFrameworkStartLevel() >= this.initialFrameworkStartLevel) {
            this.notifyInitialStartLevelReached();
        }
    }

    public void notifyInitialStartLevelReached() {
        logger.info("Inital start level reached {}", (Object)this.initialFrameworkStartLevel);
        this.initialStartLevelReachedLatch.countDown();
        FrameworkService.sendEvent(EVENT_TOPIC_LIFECYCLE, Collections.singletonMap("type", EVENT_TYPE_INITIAL_START_LEVEL_REACHED), false);
    }

    public void waitForInitialStartLevelReached() {
        this.waitForLatch(this.initialStartLevelReachedLatch, "initial start level to be reached");
    }

    public void notifyFileInstallStarted(List<Long> createdOnStartup) {
        this.bundleStarter.afterFileInstallStarted(createdOnStartup);
        logger.info("FileInstall watcher started");
        this.fileInstallStartedLatch.countDown();
        FrameworkService.sendEvent(EVENT_TOPIC_LIFECYCLE, Collections.singletonMap("type", EVENT_TYPE_FILEINSTALL_STARTED), false);
    }

    public void waitForFileInstallStarted() {
        this.waitForLatch(this.fileInstallStartedLatch, "file-install");
    }

    public void notifySpringBridgeStarted() {
        logger.info("Spring bridge started");
        this.springBridgeStartedLatch.countDown();
        FrameworkService.sendEvent(EVENT_TOPIC_LIFECYCLE, Collections.singletonMap("type", EVENT_TYPE_SPRING_BRIDGE_STARTED), false);
    }

    public void waitForSpringBridgeStarted() {
        this.waitForLatch(this.springBridgeStartedLatch, "Spring bridge to be started");
    }

    public void raiseStartLevel() {
        logger.info("Raising start level to {}", (Object)this.finalFrameworkStartLevel);
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this.main.getFramework().getBundleContext().getBundle(0L).adapt(FrameworkStartLevel.class);
        frameworkStartLevel.setStartLevel(this.finalFrameworkStartLevel, new FrameworkListener[]{event -> this.notifyFinalStartLevelReached()});
    }

    public void notifyFinalStartLevelReached() {
        logger.info("Final start level reached");
        logger.info("OSGi platform service initialized in {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        this.finalStartLevelReachedLatch.countDown();
        FrameworkService.sendEvent(EVENT_TOPIC_LIFECYCLE, Collections.singletonMap("type", EVENT_TYPE_FINAL_START_LEVEL_REACHED), false);
    }

    public void waitForFinalStartLevelReached() {
        this.waitForLatch(this.finalStartLevelReachedLatch, "final start level to be reached");
    }

    public void notifyClusterStarted() {
        logger.info("Cluster started");
        this.clusterStartedLatch.countDown();
        FrameworkService.sendEvent(EVENT_TOPIC_LIFECYCLE, Collections.singletonMap("type", EVENT_TYPE_CLUSTER_STARTED), false);
    }

    public void waitForClusterStarted() {
        if (SettingsBean.getInstance().isClusterActivated()) {
            this.waitForLatch(this.clusterStartedLatch, "cluster sync to be finished");
        }
    }

    private void waitForLatch(CountDownLatch latch, String name) {
        if (this.osgiStartupWaitTimeout > 0L) {
            logger.info("Waiting for {} ...", (Object)name);
            try {
                if (!latch.await(this.osgiStartupWaitTimeout, TimeUnit.MILLISECONDS)) {
                    logger.warn("Timeout reached when waiting for {}", (Object)name);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new JahiaRuntimeException(e);
            }
        }
    }

    private class StartLevelChecker
    extends TimerTask {
        private StartLevelChecker() {
        }

        @Override
        public void run() {
            if (FrameworkService.this.initialStartLevelReachedLatch.getCount() == 0L) {
                this.cancel();
            } else if (BundleLifecycleUtils.getFrameworkStartLevel() >= FrameworkService.this.initialFrameworkStartLevel) {
                logger.info("Framework start level reached {}", (Object)FrameworkService.this.initialFrameworkStartLevel);
                FrameworkService.this.initialStartLevelReachedLatch.countDown();
                this.cancel();
            }
        }

        @Override
        public boolean cancel() {
            logger.info("Cancelling the start level checker task");
            boolean result = super.cancel();
            FrameworkService.this.destroyTimer();
            return result;
        }
    }

    private static final class Holder {
        static final FrameworkService INSTANCE = new FrameworkService(JahiaContextLoaderListener.getServletContext());

        private Holder() {
        }
    }
}

