/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.security.SecureRandom;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieAuthValveImpl
extends BaseAuthValve {
    private CookieAuthConfig cookieAuthConfig;
    private static final Logger logger = LoggerFactory.getLogger(CookieAuthValveImpl.class);

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        Cookie[] cookies;
        if (!this.isEnabled() || SettingsBean.getInstance().isFullReadOnlyMode()) {
            valveContext.invokeNext(context);
            return;
        }
        AuthValveContext authContext = (AuthValveContext)context;
        JCRUserNode jahiaUser = null;
        Cookie[] cookieArray = cookies = this.cookieAuthConfig.isActivated() ? authContext.getRequest().getCookies() : null;
        if (cookies == null) {
            valveContext.invokeNext(context);
            return;
        }
        Cookie authCookie = null;
        for (Cookie curCookie : cookies) {
            if (!this.cookieAuthConfig.getCookieName().equals(curCookie.getName())) continue;
            authCookie = curCookie;
            break;
        }
        if (authCookie != null) {
            Properties searchCriterias = new Properties();
            String userPropertyName = this.cookieAuthConfig.getUserPropertyName();
            String value = authCookie.getValue();
            String realm = null;
            if (value.contains(":")) {
                realm = StringUtils.substringAfter((String)value, (String)":");
                value = StringUtils.substringBefore((String)value, (String)":");
            }
            if (value.equals("deleted")) {
                valveContext.invokeNext(context);
                return;
            }
            searchCriterias.setProperty(userPropertyName, value);
            Set<JCRUserNode> foundUsers = null;
            try {
                foundUsers = ServicesRegistry.getInstance().getJahiaUserManagerService().searchUsers(searchCriterias, realm, null, JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null));
                if (foundUsers.size() == 1) {
                    jahiaUser = foundUsers.iterator().next();
                    if (jahiaUser.isAccountLocked()) {
                        jahiaUser = null;
                    } else {
                        HttpSession session = authContext.getRequest().getSession(false);
                        if (session != null) {
                            session.setAttribute("org.jahia.usermanager.jahiauser", (Object)jahiaUser.getJahiaUser());
                        }
                        if (this.cookieAuthConfig.isRenewalActivated()) {
                            CookieAuthValveImpl.sendCookie(value, authContext, jahiaUser, this.cookieAuthConfig);
                        }
                    }
                } else {
                    authCookie = new Cookie(this.cookieAuthConfig.getCookieName(), "deleted");
                    authCookie.setPath(StringUtils.isNotEmpty((String)authContext.getRequest().getContextPath()) ? authContext.getRequest().getContextPath() : "/");
                    authCookie.setMaxAge(0);
                    authCookie.setHttpOnly(this.cookieAuthConfig.isHttpOnly());
                    authCookie.setSecure(this.cookieAuthConfig.isSecure());
                    authContext.getResponse().addCookie(authCookie);
                }
            }
            catch (RepositoryException e) {
                logger.error("Error while searching for users", (Throwable)e);
            }
        }
        if (jahiaUser == null) {
            valveContext.invokeNext(context);
        } else {
            JahiaUser user = jahiaUser.getJahiaUser();
            if (authContext.getRequest().getSession(false) != null) {
                authContext.getRequest().getSession().invalidate();
            }
            authContext.getSessionFactory().setCurrentUser(user);
        }
    }

    public static void createAndSendCookie(AuthValveContext authContext, JCRUserNode theUser, CookieAuthConfig cookieAuthConfig) {
        String cookieUserKey = CookieAuthValveImpl.getAvailableCookieKey(cookieAuthConfig);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, session -> {
                JCRUserNode innerUserNode = (JCRUserNode)session.getNode(theUser.getPath());
                innerUserNode.setProperty(cookieAuthConfig.getUserPropertyName(), cookieUserKey);
                session.save();
                return null;
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        CookieAuthValveImpl.sendCookie(cookieUserKey, authContext, theUser, cookieAuthConfig);
    }

    protected static void sendCookie(String cookieUserKey, AuthValveContext authContext, JCRUserNode theUser, CookieAuthConfig cookieAuthConfig) {
        String realm = theUser.getRealm();
        Cookie authCookie = new Cookie(cookieAuthConfig.getCookieName(), cookieUserKey + (realm != null ? ":" + realm : ""));
        authCookie.setPath(StringUtils.isNotEmpty((String)authContext.getRequest().getContextPath()) ? authContext.getRequest().getContextPath() : "/");
        authCookie.setMaxAge(cookieAuthConfig.getMaxAgeInSeconds());
        authCookie.setHttpOnly(cookieAuthConfig.isHttpOnly());
        authCookie.setSecure(cookieAuthConfig.isSecure());
        authContext.getResponse().addCookie(authCookie);
    }

    public static String getAvailableCookieKey(CookieAuthConfig cookieAuthConfig) {
        return UUID.randomUUID().toString();
    }

    public void setCookieAuthConfig(CookieAuthConfig config) {
        this.cookieAuthConfig = config;
    }

    @Deprecated
    public static String generateRandomString(int length) {
        SecureRandom randomGen = new SecureRandom();
        StringBuilder result = new StringBuilder();
        for (int count = 0; count < length; ++count) {
            int randomSel = randomGen.nextInt(3);
            int randomInt = randomGen.nextInt(26);
            char randomChar = '0';
            switch (randomSel) {
                case 0: {
                    randomChar = (char)(65 + randomInt);
                    break;
                }
                case 1: {
                    randomChar = (char)(97 + randomInt);
                    break;
                }
                case 2: {
                    randomChar = (char)(48 + randomInt % 10);
                }
            }
            result.append(randomChar);
        }
        return result.toString();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setEnabled(this.cookieAuthConfig.isActivated());
    }
}

