/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache.ehcache;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.Searchable;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.management.ManagementService;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.cache.CacheImplementation;
import org.jahia.services.cache.CacheProvider;
import org.jahia.services.cache.CacheService;
import org.jahia.services.cache.ehcache.EhCacheImpl;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.PlaceholderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class EhCacheProvider
implements CacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheProvider.class);
    private CacheManager cacheManager = null;
    private int groupsSizeLimit = 100;
    private Resource configurationResource;
    private boolean statisticsEnabled;
    private boolean jmxActivated = true;
    private boolean initialized = false;

    @Override
    public void init(SettingsBean settingsBean, CacheService cacheService) throws JahiaInitializationException {
        if (this.initialized) {
            return;
        }
        try (InputStream is = this.configurationResource.getInputStream();
             InputStream interpolatedInputStream = PlaceholderUtils.resolvePlaceholders(is, settingsBean, true);){
            this.cacheManager = CacheManager.newInstance((InputStream)interpolatedInputStream);
        }
        catch (IOException e) {
            throw new JahiaInitializationException(e.getMessage(), e);
        }
        if (this.jmxActivated) {
            ManagementService.registerMBeans((CacheManager)this.cacheManager, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        this.initialized = true;
    }

    @Override
    public void shutdown() {
        if (this.initialized) {
            logger.info("Shutting down cache provider, serializing to disk if active. Please wait...");
            long startTime = System.currentTimeMillis();
            this.cacheManager.shutdown();
            logger.info("Cache provider shutdown completed in {} ms", (Object)(System.currentTimeMillis() - startTime));
            this.initialized = false;
        }
    }

    @Override
    public CacheImplementation<?, ?> newCacheImplementation(String name) {
        return new EhCacheImpl(name, this.cacheManager, this);
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public int getGroupsSizeLimit() {
        return this.groupsSizeLimit;
    }

    public void setGroupsSizeLimit(int groupsSizeLimit) {
        this.groupsSizeLimit = groupsSizeLimit;
    }

    public void setConfigurationResource(Resource configurationResource) {
        this.configurationResource = configurationResource;
    }

    public void setJmxActivated(boolean jmxActivated) {
        this.jmxActivated = jmxActivated;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public synchronized SelfPopulatingCache registerSelfPopulatingCache(String cacheName, CacheEntryFactory factory) {
        return this.registerSelfPopulatingCache(cacheName, null, factory);
    }

    @Override
    public synchronized SelfPopulatingCache registerSelfPopulatingCache(String cacheName, Searchable searchable, CacheEntryFactory factory) {
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache != null) {
            if (cache instanceof SelfPopulatingCache) {
                return (SelfPopulatingCache)cache;
            }
        } else {
            Map cacheConfigurations;
            Configuration configuration = this.cacheManager.getConfiguration();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)cacheConfigurations.get((cacheConfigurations = configuration.getCacheConfigurations()).containsKey(cacheName) ? cacheName : "org.jahia.selfPopulatingReplicatedCache");
            if (searchable != null) {
                cacheConfiguration.addSearchable(searchable);
            }
            PinningConfiguration pinningConfiguration = new PinningConfiguration();
            pinningConfiguration.setStore("INCACHE");
            cacheConfiguration.addPinning(pinningConfiguration);
            cache = new Cache(cacheConfiguration);
            cache.setName(cacheName);
            cache = this.cacheManager.addCacheIfAbsent(cache);
        }
        SelfPopulatingCache selfPopulatingCache = new SelfPopulatingCache(cache, factory);
        this.cacheManager.replaceCacheWithDecoratedCache(cache, (Ehcache)selfPopulatingCache);
        return selfPopulatingCache;
    }
}

