/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.JahiaSessionImpl;
import org.apache.jackrabbit.core.security.JahiaCallbackHandler;
import org.apache.jackrabbit.core.security.JahiaLoginModule;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.NamespaceRegistryWrapper;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryResultWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.context.ServletContextAware;

public class JCRSessionFactory
implements Repository,
ServletContextAware,
ReadOnlyModeCapable {
    private static final Comparator<String> invertedStringComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    };
    public static final String DEFAULT_PROVIDER_KEY = "default";
    private static transient Logger logger = LoggerFactory.getLogger(JCRSessionFactory.class);
    protected ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> userSession = new ThreadLocal();
    protected ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> systemSession = new ThreadLocal();
    private NamespaceRegistryWrapper namespaceRegistry;
    private Map<String, String> descriptors = new HashMap<String, String>();
    private JahiaUserManagerService userService;
    private Map<String, JCRStoreProvider> providers = new HashMap<String, JCRStoreProvider>();
    private List<JCRStoreProvider> providerList = new LinkedList<JCRStoreProvider>();
    private SortedMap<String, JCRStoreProvider> mountPoints;
    private String servletContextAttributeName;
    private ServletContext servletContext;
    private ThreadLocal<JahiaUser> currentUser = new ThreadLocal();
    private ThreadLocal<Locale> currentLocale = new ThreadLocal();
    private ThreadLocal<Locale> fallbackLocale = new ThreadLocal();
    private ThreadLocal<JahiaUser> currentAliasedUser = new ThreadLocal();
    private ThreadLocal<String> currentServletPath = new ThreadLocal();
    private ThreadLocal<Calendar> currentPreviewDate = new ThreadLocal();
    private ThreadLocal<Boolean> readOnlyCacheEnabled = new ThreadLocal();
    private LocalValidatorFactoryBean validatorFactoryBean;
    private boolean readOnlyModeEnabled;
    private final ReadWriteLock readOnlyModeLock = new ReentrantReadWriteLock();

    private JCRSessionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        JCRSessionFactory jCRSessionFactory = this;
        synchronized (jCRSessionFactory) {
            this.mountPoints = new TreeMap<String, JCRStoreProvider>(invertedStringComparator);
        }
        this.namespaceRegistry = new NamespaceRegistryWrapper();
        if (this.servletContextAttributeName != null && this.servletContext != null) {
            this.servletContext.setAttribute(this.servletContextAttributeName, (Object)this);
        }
    }

    public void setServletContextAttributeName(String servletContextAttributeName) {
        this.servletContextAttributeName = servletContextAttributeName;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setDescriptors(Map<String, String> descriptors) {
        this.descriptors = descriptors;
    }

    public void setUserService(JahiaUserManagerService userService) {
        this.userService = userService;
    }

    public JCRSessionWrapper getCurrentUserSession() throws RepositoryException {
        return this.getCurrentUserSession(null);
    }

    public JCRSessionWrapper getCurrentUserSession(String workspace) throws RepositoryException {
        return this.getCurrentUserSession(workspace, null);
    }

    public JCRSessionWrapper getCurrentUserSession(String workspace, Locale locale) throws RepositoryException {
        return this.getCurrentUserSession(workspace, locale, locale != null ? this.getFallbackLocale() : null);
    }

    public JCRSessionWrapper getCurrentUserSession(String workspace, Locale locale, Locale fallbackLocale) throws RepositoryException {
        return this.getCurrentSession(workspace, locale, fallbackLocale, false);
    }

    public JCRSessionWrapper getCurrentSystemSession(String workspace, Locale locale, Locale fallbackLocale) throws RepositoryException {
        return this.getCurrentSession(workspace, locale, fallbackLocale, true);
    }

    public JCRSessionWrapper getCurrentSession(String workspace, Locale locale, Locale fallbackLocale, boolean system) throws RepositoryException {
        JahiaUser user;
        ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> sessionThreadLocal = system ? this.systemSession : this.userSession;
        Map<String, Map<String, JCRSessionWrapper>> smap = sessionThreadLocal.get();
        if (smap == null) {
            smap = new HashMap<String, Map<String, JCRSessionWrapper>>();
        }
        sessionThreadLocal.set(smap);
        JahiaUser jahiaUser = user = !system ? this.getCurrentUser() : null;
        if (!system && user == null) {
            logger.error("Null thread user");
            throw new RepositoryException("Null thread user");
        }
        String username = JahiaUserManagerService.isGuest(user) ? " guest " : user.getUsername();
        Map<String, JCRSessionWrapper> wsMap = smap.get(username);
        if (wsMap == null) {
            wsMap = new HashMap<String, JCRSessionWrapper>();
            smap.put(username, wsMap);
        }
        if (workspace == null) {
            workspace = DEFAULT_PROVIDER_KEY;
        }
        String localeString = locale != null ? locale.toString() : DEFAULT_PROVIDER_KEY;
        String key = workspace + "-" + localeString + "-" + fallbackLocale;
        JCRSessionWrapper s = wsMap.get(key);
        if (s == null || !s.isLive()) {
            if (system) {
                s = this.login(JahiaLoginModule.getSystemCredentials(), workspace, locale, fallbackLocale);
                s.setCurrentUserSession(true);
                wsMap.put(key, s);
            } else {
                s = !" guest ".equals(username) ? this.login(JahiaLoginModule.getCredentials(username, user.getRealm()), workspace, locale, fallbackLocale) : this.login(JahiaLoginModule.getGuestCredentials(), workspace, locale, fallbackLocale);
                s.setCurrentUserSession(true);
                wsMap.put(key, s);
            }
        }
        s.setReadOnlyCacheEnabled(this.getReadOnlyCacheEnabled());
        return s;
    }

    protected JCRSessionWrapper getSystemSession() throws RepositoryException {
        return this.login(JahiaLoginModule.getSystemCredentials());
    }

    protected JCRSessionWrapper getSystemSession(String username, String realm, String workspace, Locale locale) throws RepositoryException {
        return this.login(JahiaLoginModule.getSystemCredentials(username, realm), workspace, locale, locale != null ? this.getFallbackLocale() : null);
    }

    protected JCRSessionWrapper getUserSession(String username, String realm, String workspace, Locale locale) throws RepositoryException {
        return this.login(JahiaLoginModule.getCredentials(username, realm), workspace, locale, locale != null ? this.getFallbackLocale() : null);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.size()]);
    }

    public String getDescriptor(String s) {
        return this.descriptors.get(s);
    }

    public Session findSameSession(JCRStoreProvider provider, String userID, String ws, boolean system) throws RepositoryException {
        Session s;
        block1: {
            Map<String, Map<String, JCRSessionWrapper>> smap;
            ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> sessionThreadLocal;
            s = null;
            ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> threadLocal = sessionThreadLocal = system ? this.systemSession : this.userSession;
            if (sessionThreadLocal == null || (smap = sessionThreadLocal.get()) == null || !smap.containsKey(userID)) break block1;
            Map<String, JCRSessionWrapper> wsMap = smap.get(userID);
            for (String key : wsMap.keySet()) {
                if (key.startsWith(ws) && (s = wsMap.get(key).getProviderSession(provider, false)) != null) break;
            }
        }
        return s;
    }

    public JCRSessionWrapper login(Credentials credentials, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(credentials, workspace, null, null);
    }

    private JCRSessionWrapper login(Credentials credentials, String workspace, Locale locale, Locale fallbackLocale) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (!(credentials instanceof SimpleCredentials)) {
            throw new LoginException("Only SimpleCredentials supported in this implementation");
        }
        SimpleCredentials simpleCreds = (SimpleCredentials)credentials;
        JahiaLoginModule m = new JahiaLoginModule();
        Subject s = new Subject();
        m.initialize(s, new JahiaCallbackHandler(simpleCreds), null, null);
        try {
            JahiaLoginModule.Token t = JahiaLoginModule.getToken(simpleCreds.getUserID(), new String(simpleCreds.getPassword()));
            m.login();
            m.commit();
            credentials = JahiaLoginModule.getCredentials(simpleCreds.getUserID(), (String)simpleCreds.getAttribute("org.jahia.realm"), t != null ? t.deniedPath : null);
        }
        catch (javax.security.auth.login.LoginException e) {
            throw new LoginException((Throwable)e);
        }
        Set<JahiaPrincipal> p = s.getPrincipals(JahiaPrincipal.class);
        Iterator<JahiaPrincipal> iterator = p.iterator();
        if (iterator.hasNext()) {
            JahiaPrincipal jahiaPrincipal = iterator.next();
            JahiaUser user = null;
            if (!jahiaPrincipal.getName().startsWith(" system ")) {
                JCRUserNode userNode = jahiaPrincipal.isGuest() ? this.userService.lookupUser("guest") : this.userService.lookupUser(jahiaPrincipal.getName(), jahiaPrincipal.getRealm(), false);
                if (userNode != null) {
                    user = userNode.getJahiaUser();
                } else {
                    logger.warn("Cannot find user " + jahiaPrincipal.getName() + "@" + jahiaPrincipal.getRealm());
                }
            }
            return new JCRSessionWrapper(user, credentials, jahiaPrincipal.isSystem(), workspace, locale, this, fallbackLocale);
        }
        throw new LoginException("Can't login");
    }

    public JCRSessionWrapper login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public JCRSessionWrapper login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(JahiaLoginModule.getGuestCredentials(), workspace);
    }

    public JCRSessionWrapper login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    public boolean isStandardDescriptor(String key) {
        return false;
    }

    public boolean isSingleValueDescriptor(String key) {
        return false;
    }

    public Value getDescriptorValue(String key) {
        return null;
    }

    public Value[] getDescriptorValues(String key) {
        return new Value[0];
    }

    public Map<String, JCRStoreProvider> getMountPoints() {
        return this.mountPoints;
    }

    public Map<String, JCRStoreProvider> getProviders() {
        return this.providers;
    }

    public JCRStoreProvider getDefaultProvider() {
        return this.getProviders().get(DEFAULT_PROVIDER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvider(JCRStoreProvider p) {
        String key = p.getKey();
        String mountPoint = p.getMountPoint();
        JCRSessionFactory jCRSessionFactory = this;
        synchronized (jCRSessionFactory) {
            for (JCRSessionWrapper wrapper : JCRSessionWrapper.getActiveSessionsObjects().values()) {
                try {
                    wrapper.removeFromCache(mountPoint);
                }
                catch (RepositoryException e) {
                    logger.warn("Cannot flush cache", (Throwable)e);
                }
            }
            ArrayList<JCRStoreProvider> newList = new ArrayList<JCRStoreProvider>(this.providerList);
            newList.add(p);
            Collections.sort(newList);
            this.providerList = Collections.unmodifiableList(newList);
            this.initProviders();
            if (mountPoint != null) {
                TreeMap<String, JCRStoreProvider> newMountPoints = new TreeMap<String, JCRStoreProvider>(this.mountPoints);
                newMountPoints.put(mountPoint, p);
                this.mountPoints = Collections.unmodifiableSortedMap(newMountPoints);
            }
        }
        logger.info("Added provider " + key + " at mount point " + mountPoint + " using implementation " + p.getClass().getName());
    }

    @Deprecated
    public void addProvider(String key, String mountPoint, JCRStoreProvider p) {
        this.addProvider(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProvider(String key) {
        JCRStoreProvider p = this.getProviders().get(key);
        if (p == null) {
            return;
        }
        JCRSessionFactory jCRSessionFactory = this;
        synchronized (jCRSessionFactory) {
            for (JCRSessionWrapper wrapper : JCRSessionWrapper.getActiveSessionsObjects().values()) {
                try {
                    wrapper.removeFromCache(p.getMountPoint());
                }
                catch (RepositoryException e) {
                    logger.warn("Cannot flush cache", (Throwable)e);
                }
            }
            ArrayList<JCRStoreProvider> newList = new ArrayList<JCRStoreProvider>(this.providerList);
            newList.remove(p);
            this.providerList = Collections.unmodifiableList(newList);
            this.initProviders();
            if (p.getMountPoint() != null) {
                TreeMap<String, JCRStoreProvider> newMountPoints = new TreeMap<String, JCRStoreProvider>(this.mountPoints);
                newMountPoints.remove(p.getMountPoint());
                this.mountPoints = Collections.unmodifiableSortedMap(newMountPoints);
            }
        }
        logger.info("Removed provider " + key + " at mount point " + p.getMountPoint() + " using implementation " + p.getClass().getName());
    }

    private void initProviders() {
        LinkedHashMap<String, JCRStoreProvider> providerMap = new LinkedHashMap<String, JCRStoreProvider>(this.providerList.size());
        for (JCRStoreProvider p : this.providerList) {
            providerMap.put(p.getKey(), p);
        }
        this.providers = Collections.unmodifiableMap(providerMap);
    }

    public List<JCRStoreProvider> getProviderList() {
        return this.providerList;
    }

    public static JCRSessionFactory getInstance() {
        return Holder.INSTANCE;
    }

    public void closeAllSessions() {
        this.closeAllSessions(this.userSession);
        this.closeAllSessions(this.systemSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSessions(ThreadLocal<Map<String, Map<String, JCRSessionWrapper>>> mapThreadLocal) {
        Map<String, Map<String, JCRSessionWrapper>> smap = mapThreadLocal.get();
        if (smap != null) {
            try {
                for (Map<String, JCRSessionWrapper> wsMap : smap.values()) {
                    for (JCRSessionWrapper s : wsMap.values()) {
                        if (!s.isLive()) continue;
                        try {
                            s.doLogout();
                        }
                        catch (Exception e) {
                            logger.warn("Error performing JCR session logout for sesison " + s, (Throwable)e);
                        }
                    }
                }
            }
            finally {
                mapThreadLocal.set(null);
                smap.clear();
            }
        }
    }

    public JCRStoreProvider getProvider(String path) {
        return this.getProvider(path, true);
    }

    public JCRStoreProvider getProvider(String path, boolean includeDefault) {
        Map<String, JCRStoreProvider> currentMountPoints = this.getMountPoints();
        if (includeDefault && currentMountPoints.size() == 1) {
            return this.getDefaultProvider();
        }
        for (Map.Entry<String, JCRStoreProvider> mp : currentMountPoints.entrySet()) {
            if ((!includeDefault || !mp.getValue().isDefault()) && !path.equals(mp.getKey()) && !path.startsWith(mp.getKey() + "/")) continue;
            return mp.getValue();
        }
        return null;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.namespaceRegistry;
    }

    public JahiaUser getCurrentUser() {
        return this.currentUser.get();
    }

    public void setCurrentUser(JahiaUser user) {
        this.currentUser.set(user);
    }

    public Locale getCurrentLocale() {
        return this.currentLocale.get();
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale.set(locale);
    }

    public Locale getFallbackLocale() {
        return this.fallbackLocale.get();
    }

    public void setFallbackLocale(Locale locale) {
        this.fallbackLocale.set(locale);
    }

    public JahiaUser getCurrentAliasedUser() {
        return this.currentAliasedUser.get();
    }

    public void setCurrentAliasedUser(JahiaUser user) {
        this.currentAliasedUser.set(user);
    }

    public Boolean getReadOnlyCacheEnabled() {
        return this.readOnlyCacheEnabled.get() == null ? Boolean.valueOf(false) : this.readOnlyCacheEnabled.get();
    }

    public void setReadOnlyCacheEnabled(Boolean readOnlyCacheEnabled) {
        this.readOnlyCacheEnabled.set(readOnlyCacheEnabled);
    }

    boolean checkAliasedStatusAndToggleSessionIfNeeded(Session session, JahiaUser user) {
        JahiaUser currentAliasedUser = this.getCurrentAliasedUser();
        if (user != null && currentAliasedUser != null && currentAliasedUser.equals(user)) {
            if (session instanceof JahiaSessionImpl) {
                ((JahiaSessionImpl)session).toggleThisSessionAsAliased();
            }
            return true;
        }
        return false;
    }

    public String getCurrentServletPath() {
        return this.currentServletPath.get();
    }

    public void setCurrentServletPath(String path) {
        this.currentServletPath.set(path);
    }

    public void setCurrentPreviewDate(Calendar previewDate) {
        this.currentPreviewDate.set(previewDate);
    }

    public Calendar getCurrentPreviewDate() {
        return this.currentPreviewDate.get();
    }

    public LocalValidatorFactoryBean getValidatorFactoryBean() {
        return this.validatorFactoryBean;
    }

    public void setValidatorFactoryBean(LocalValidatorFactoryBean validatorFactoryBean) {
        this.validatorFactoryBean = validatorFactoryBean;
    }

    public boolean areMultipleMountPointsRegistered() {
        return this.mountPoints.size() > 1;
    }

    @Override
    public int getReadOnlyModePriority() {
        return 200;
    }

    @Override
    public void switchReadOnlyMode(boolean enable) {
        this.readOnlyModeLock.writeLock().lock();
        try {
            logger.info("Read only mode switch: JCR session are" + (enable ? " not " : " ") + "allowed to perform saving");
            this.readOnlyModeEnabled = enable;
            if (enable) {
                try {
                    this.clearEngineLocks(true);
                }
                catch (Exception e) {
                    logger.warn("Unable to clear the engine locks while switching Read only mode to ON", (Throwable)e);
                }
            }
            logger.info("Read only mode on JCR sessions: " + (this.readOnlyModeEnabled ? "ON" : "OFF"));
        }
        finally {
            this.readOnlyModeLock.writeLock().unlock();
        }
    }

    boolean isReadOnlyModeEnabled() {
        this.readOnlyModeLock.readLock().lock();
        try {
            boolean bl = this.readOnlyModeEnabled;
            return bl;
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEngineLocks(boolean ignoreReadOnlyMode) throws RepositoryException {
        JCRSessionWrapper systemSession = null;
        try {
            systemSession = this.getSystemSession();
            systemSession.setIgnoreReadOnlyMode(ignoreReadOnlyMode);
            QueryWrapper engineLockedQuery = systemSession.getWorkspace().getQueryManager().createQuery("select * from [jmix:lockable] where isdescendantnode('/sites') and [j:lockTypes] like '%:engine'", "JCR-SQL2");
            QueryResultWrapper engineLockedQueryResult = engineLockedQuery.execute();
            NodeIterator nodeIterator = engineLockedQueryResult.getNodes();
            while (nodeIterator.hasNext()) {
                this.clearEngineLocks(nodeIterator.nextNode(), systemSession);
            }
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
        }
    }

    private void clearEngineLocks(Node node, JCRSessionWrapper session) {
        try {
            if (node instanceof JCRNodeWrapper && !node.isNodeType("jnt:translation")) {
                Value[] ni = ((JCRNodeWrapper)node).getI18Ns();
                while (ni.hasNext()) {
                    this.clearEngineLocks(ni.nextNode(), session);
                }
            }
            if (node.hasProperty("j:lockTypes")) {
                for (Value lockTypeValue : node.getProperty("j:lockTypes").getValues()) {
                    String[] lockTypeInfos = StringUtils.split((String)lockTypeValue.getString(), (String)":");
                    if (lockTypeInfos.length < 1 || !StringUtils.equals((String)lockTypeInfos[1], (String)"engine")) continue;
                    logger.info("Clearing engine lock for node {} and user {} before switching Read only mode", (Object)node.getPath(), (Object)lockTypeInfos[0]);
                    JCRNodeWrapperImpl.unlock(node, lockTypeInfos[1], lockTypeInfos[0], session);
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Unable to check and clean engine locks for node " + node, (Throwable)ex);
        }
    }

    private static class Holder {
        static final JCRSessionFactory INSTANCE = new JCRSessionFactory();

        private Holder() {
        }
    }
}

