/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRStoreProviderChecker {
    private static Logger logger = LoggerFactory.getLogger(JCRStoreProvider.class);
    private final Map<String, JCRStoreProvider> toPeriodicallyCheck = new HashMap<String, JCRStoreProvider>();
    private static final Object lock = new Object();
    private static final ThreadLocal<Boolean> isFromChecker = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static boolean isFromChecker() {
        return isFromChecker.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HashMap<String, JCRStoreProvider> toCheck;
        Iterator iterator = lock;
        synchronized (iterator) {
            toCheck = new HashMap<String, JCRStoreProvider>(this.toPeriodicallyCheck);
        }
        try {
            isFromChecker.set(true);
            for (Map.Entry entry : toCheck.entrySet()) {
                String key = (String)entry.getKey();
                JCRStoreProvider provider = (JCRStoreProvider)entry.getValue();
                if (!provider.isAvailable(true)) continue;
                logger.info("Remote server " + this.getProviderName(provider, key) + " came back online. Attempting to re-mount provider.");
                provider.setMountStatus(JCRMountPointNode.MountStatus.mounted);
                Object object = lock;
                synchronized (object) {
                    this.toPeriodicallyCheck.remove(key);
                }
                logger.info("Re-mount successful!");
            }
        }
        finally {
            isFromChecker.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPeriodically(JCRStoreProvider provider) {
        String key = provider.getKey();
        Object object = lock;
        synchronized (object) {
            this.toPeriodicallyCheck.put(key, provider);
        }
        String providerName = this.getProviderName(provider, key);
        logger.info("Added provider " + providerName + " to list of servers to periodically check");
    }

    private String getProviderName(JCRStoreProvider provider, String key) {
        String providerName = provider.getUrl();
        providerName = providerName != null ? providerName : key;
        return providerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Object object = lock;
        synchronized (object) {
            this.toPeriodicallyCheck.remove(key);
        }
    }
}

