/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.JahiaService;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreProviderChecker;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.ProviderFactory;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.validation.JCRNodeValidator;
import org.jahia.services.content.interceptor.InterceptorChain;
import org.jahia.services.content.interceptor.PropertyInterceptor;
import org.jahia.services.content.nodetypes.JahiaCndWriter;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.NodeTypesDBServiceImpl;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class JCRStoreService
extends JahiaService
implements JahiaAfterInitializationService {
    private static Logger logger = LoggerFactory.getLogger(JCRStoreService.class);
    private Map<String, Class<? extends JCRNodeDecorator>> decorators = new ConcurrentHashMap<String, Class<? extends JCRNodeDecorator>>();
    private Map<String, Constructor<?>> decoratorCreators = new ConcurrentHashMap();
    private InterceptorChain interceptorChain;
    private Map<String, ProviderFactory> providerFactories = new ConcurrentHashMap<String, ProviderFactory>();
    private List<PropertyInterceptor> interceptors = new LinkedList<PropertyInterceptor>();
    private Set<String> noValidityCheckTypes = new HashSet<String>();
    private Set<String> noLanguageValidityCheckTypes = new HashSet<String>();
    private Map<String, Class<? extends JCRNodeValidator>> validators = new ConcurrentHashMap<String, Class<? extends JCRNodeValidator>>();
    private Map<String, Constructor<?>> validatorCreators = new ConcurrentHashMap();
    private JCRStoreProviderChecker providerChecker;
    private Map<String, List<DefaultEventListener>> listeners;
    private NodeTypesDBServiceImpl nodeTypesDBService;
    private final Properties deploymentProperties = new Properties(){

        @Override
        public synchronized Enumeration<Object> keys() {
            return new Vector<Object>(new TreeSet<Object>(this.keySet())).elements();
        }
    };
    private final Set<String> initializedSystemIds = new LinkedHashSet<String>();
    private JCRSessionFactory sessionFactory;

    public static JCRStoreService getInstance() {
        return Holder.INSTANCE;
    }

    public void setProviderChecker(JCRStoreProviderChecker providerChecker) {
        this.providerChecker = providerChecker;
    }

    public JCRStoreProviderChecker getProviderChecker() {
        return this.providerChecker;
    }

    private JCRStoreService() {
    }

    public void addInterceptor(int index, PropertyInterceptor interceptor) {
        this.interceptors.add(index, interceptor);
        this.interceptorChain = null;
    }

    public void addInterceptor(PropertyInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.interceptorChain = null;
    }

    public void addProviderFactory(String nodeType, final ProviderFactory externalProviderFactory) {
        this.providerFactories.put(nodeType, externalProviderFactory);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    Query query = session.getProviderSession(session.getNode("/").getProvider()).getWorkspace().getQueryManager().createQuery("select * from [jnt:mountPoint]", "JCR-SQL2");
                    QueryResult queryResult = query.execute();
                    NodeIterator queryResultNodes = queryResult.getNodes();
                    while (queryResultNodes.hasNext()) {
                        Node node = (Node)queryResultNodes.next();
                        JCRNodeWrapper jcrNodeWrapper = session.getNodeByIdentifier(node.getIdentifier());
                        if (!(jcrNodeWrapper instanceof JCRMountPointNode) || !externalProviderFactory.getNodeTypeName().equals(jcrNodeWrapper.getPrimaryNodeTypeName())) continue;
                        JCRMountPointNode jcrMountPointNode = (JCRMountPointNode)jcrNodeWrapper;
                        if (jcrMountPointNode.getMountStatus() == JCRMountPointNode.MountStatus.mounted) {
                            JCRNodeWrapper mountPointNode = jcrMountPointNode.getVirtualMountPointNode();
                            JCRStoreProvider provider = externalProviderFactory.mountProvider(mountPointNode);
                            if (provider.isAvailable(true)) continue;
                            logger.warn("Issue while trying to mount an external provider (" + mountPointNode.getPath() + ") upon startup, all references to file coming from this mount won't be available until it is fixed. If you migrating from Jahia 6.6 this might be normal until the migration scripts have been completed.");
                            jcrMountPointNode.setMountStatus(JCRMountPointNode.MountStatus.waiting);
                            session.save();
                            JCRStoreService.this.providerChecker.checkPeriodically(provider);
                            continue;
                        }
                        if (jcrMountPointNode.getMountStatus() != JCRMountPointNode.MountStatus.waiting) continue;
                        jcrMountPointNode.setMountStatus(JCRMountPointNode.MountStatus.mounted);
                        session.save();
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Cannot mount provider " + nodeType, (Throwable)e);
        }
    }

    public void removeProviderFactory(String nodeType, final ProviderFactory externalProviderFactory) {
        if (this.providerFactories.get(nodeType) == externalProviderFactory) {
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        Query query = session.getProviderSession(session.getNode("/").getProvider()).getWorkspace().getQueryManager().createQuery("select * from [jnt:mountPoint]", "JCR-SQL2");
                        QueryResult queryResult = query.execute();
                        NodeIterator queryResultNodes = queryResult.getNodes();
                        while (queryResultNodes.hasNext()) {
                            Node node = (Node)queryResultNodes.next();
                            JCRNodeWrapper jcrNodeWrapper = session.getNodeByIdentifier(node.getIdentifier());
                            if (!(jcrNodeWrapper instanceof JCRMountPointNode) || !jcrNodeWrapper.getPrimaryNodeTypeName().equals(externalProviderFactory.getNodeTypeName())) continue;
                            JCRStoreService.this.providerChecker.remove(jcrNodeWrapper.getIdentifier());
                            JCRStoreProvider provider = ((JCRMountPointNode)jcrNodeWrapper).getMountProvider();
                            if (provider == null) continue;
                            provider.stop();
                        }
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error("Cannot unmount provider " + nodeType, (Throwable)e);
            }
            this.providerFactories.remove(nodeType);
        }
    }

    public NodeIterator getKnownMountPointsWithStatus(JCRMountPointNode.MountStatus status) throws RepositoryException {
        String sql = status == null ? "select * from [jnt:mountPoint]" : "select * from [jnt:mountPoint] as mount where [mountStatus] = '" + status.name() + "'";
        QueryWrapper query = this.getSessionFactory().getSystemSession().getWorkspace().getQueryManager().createQuery(sql, "JCR-SQL2");
        QueryResult queryResult = query.execute();
        return queryResult.getNodes();
    }

    public JCRNodeWrapper decorate(JCRNodeWrapper w) {
        try {
            Constructor<?> creator = this.decoratorCreators.get(w.getPrimaryNodeTypeName());
            if (creator == null) {
                for (Map.Entry<String, Constructor<?>> entry : this.decoratorCreators.entrySet()) {
                    String type = entry.getKey();
                    if (!w.isNodeType(type)) continue;
                    creator = entry.getValue();
                    break;
                }
            }
            if (creator != null) {
                try {
                    return (JCRNodeWrapper)creator.newInstance(w);
                }
                catch (Exception e) {
                    logger.error("Cannot decorate node", (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error while decorating node", (Throwable)e);
        }
        return w;
    }

    public void deployDefinitions(String systemId) throws IOException, RepositoryException {
        this.deployDefinitions(systemId, null, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployDefinitions(String systemId, String moduleVersion, long lastModified) throws IOException, RepositoryException {
        this.registerNamespaces();
        for (JCRStoreProvider provider : this.sessionFactory.getProviders().values()) {
            if (!provider.canRegisterCustomNodeTypes()) continue;
            provider.registerNamespaces();
            provider.deployDefinitions(systemId);
        }
        logger.info("Added {} definitions, updating database cnd", (Object)systemId);
        Properties properties = this.deploymentProperties;
        synchronized (properties) {
            if (moduleVersion != null) {
                this.deploymentProperties.put(systemId + ".version", moduleVersion);
            }
            if (lastModified > -1L) {
                this.deploymentProperties.put(systemId + ".lastModified", Long.toString(lastModified));
            }
            StringWriter out = new StringWriter();
            new JahiaCndWriter(NodeTypeRegistry.getInstance().getNodeTypes(systemId), NodeTypeRegistry.getInstance().getNamespaces(), out);
            this.nodeTypesDBService.saveCndFile(systemId + ".cnd", out.toString(), this.deploymentProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployDefinitions(String systemId) throws IOException, RepositoryException {
        for (JCRStoreProvider provider : this.sessionFactory.getProviders().values()) {
            if (!provider.canRegisterCustomNodeTypes()) continue;
            provider.undeployDefinitions(systemId);
        }
        logger.info("Removing {} definitions, updating database cnd", (Object)systemId);
        Properties properties = this.deploymentProperties;
        synchronized (properties) {
            this.deploymentProperties.remove(systemId + ".version");
            this.deploymentProperties.remove(systemId + ".lastModified");
            this.nodeTypesDBService.saveCndFile(systemId + ".cnd", null, this.deploymentProperties);
        }
    }

    public Map<String, Class<? extends JCRNodeDecorator>> getDecorators() {
        return this.decorators;
    }

    public List<JCRNodeWrapper> getImportDropBoxes(String site, JahiaUser user) {
        ArrayList<JCRNodeWrapper> r = new ArrayList<JCRNodeWrapper>();
        for (JCRStoreProvider storeProvider : this.sessionFactory.getMountPoints().values()) {
            try {
                r.addAll(storeProvider.getImportDropBoxes(site, user));
            }
            catch (RepositoryException e) {
                logger.warn("Error when querying repository", (Throwable)e);
            }
        }
        return r;
    }

    public InterceptorChain getInterceptorChain() {
        if (this.interceptorChain == null) {
            this.interceptorChain = new InterceptorChain();
            this.interceptorChain.setInterceptors(this.interceptors);
        }
        return this.interceptorChain;
    }

    public Map<String, List<DefaultEventListener>> getListeners() {
        return this.listeners;
    }

    public JCRSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public JCRNodeWrapper getUserFolder(JahiaUser user) throws RepositoryException {
        return this.sessionFactory.getMountPoints().get("/").getUserFolder(user);
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObservers(Map<String, List<DefaultEventListener>> listeners) throws RepositoryException {
        if (listeners != null) {
            for (Map.Entry<String, List<DefaultEventListener>> entry : listeners.entrySet()) {
                String ws = entry.getKey();
                List<DefaultEventListener> l = entry.getValue();
                JCRSessionWrapper session = this.getSessionFactory().getSystemSession(null, null, ws, null);
                try {
                    Workspace workspace = session.getWorkspace();
                    ObservationManager observationManager = workspace.getObservationManager();
                    for (DefaultEventListener listener : l) {
                        if (listener.getEventTypes() > 0) {
                            listener.setWorkspace(ws);
                            observationManager.addEventListener((EventListener)listener, listener.getEventTypes(), listener.getPath(), listener.isDeep(), listener.getUuids(), listener.getNodeTypes(), false);
                            continue;
                        }
                        logger.info("Skipping listener {} as it has no event types configured.", (Object)listener.getClass().getName());
                    }
                }
                finally {
                    session.logout();
                }
            }
        }
    }

    public void removeInterceptor(PropertyInterceptor interceptor) {
        if (this.interceptors.remove(interceptor)) {
            this.interceptorChain = null;
        }
    }

    public void setDecorators(Map<String, String> decorators) {
        if (!this.decorators.isEmpty()) {
            throw new RuntimeException("setDecorators should not be called after initialization of system, use addDecorator instead");
        }
        if (decorators != null) {
            for (Map.Entry<String, String> decorator : decorators.entrySet()) {
                try {
                    this.decorators.put(decorator.getKey(), Class.forName(decorator.getValue()));
                    this.decoratorCreators.put(decorator.getKey(), Class.forName(decorator.getValue()).getConstructor(JCRNodeWrapper.class));
                }
                catch (Exception e) {
                    logger.error("Unable to instantiate decorator: " + decorator.getValue(), (Throwable)e);
                }
            }
        }
    }

    public void addDecorator(String nodeType, Class<? extends JCRNodeDecorator> decoratorClass) {
        try {
            if (!NodeTypeRegistry.getInstance().getNodeType(nodeType).isMixin()) {
                if (this.decorators == null) {
                    this.decorators = new ConcurrentHashMap<String, Class<? extends JCRNodeDecorator>>();
                }
                this.decorators.put(nodeType, decoratorClass);
                try {
                    this.decoratorCreators.put(nodeType, decoratorClass.getConstructor(JCRNodeWrapper.class));
                }
                catch (Exception e) {
                    logger.error("Unable to instantiate decorator: " + decoratorClass, (Throwable)e);
                }
            } else {
                logger.error("It is impossible to decorate a mixin ({}), only primary node type can be decorated", (Object)nodeType);
            }
        }
        catch (NoSuchNodeTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeDecorator(String nodeType) {
        this.decorators.remove(nodeType);
        this.decoratorCreators.remove(nodeType);
    }

    public void setInterceptors(List<PropertyInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        this.interceptorChain = null;
    }

    public Map<String, ProviderFactory> getProviderFactories() {
        return this.providerFactories;
    }

    public void setProviderFactories(Map<String, ProviderFactory> providerFactories) {
        this.providerFactories = providerFactories;
    }

    public void setListeners(Map<String, List<DefaultEventListener>> listeners) {
        this.listeners = listeners;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setNodeTypesDBService(NodeTypesDBServiceImpl nodeTypesDBService) {
        this.nodeTypesDBService = nodeTypesDBService;
    }

    @Override
    public void start() throws JahiaInitializationException {
        try {
            this.initPropertiesFile();
            this.initNodeTypeRegistry();
            this.reloadNodeTypeRegistry();
            this.initObservers(this.listeners);
        }
        catch (Exception e) {
            logger.error("Repository init error", (Throwable)e);
        }
    }

    @Override
    public void stop() throws JahiaException {
    }

    private void initPropertiesFile() throws IOException {
        try {
            String propertyFile = this.nodeTypesDBService.readDefinitionPropertyFile();
            if (propertyFile != null) {
                this.deploymentProperties.load(new StringReader(propertyFile));
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    private void initNodeTypeRegistry() throws ParseException, IOException, RepositoryException {
        if (this.settingsBean.isProcessingServer()) {
            for (Map.Entry<String, File> entry : NodeTypeRegistry.getSystemDefinitionsFiles().entrySet()) {
                String systemId = entry.getKey();
                File file = entry.getValue();
                NodeTypeRegistry.getInstance().addDefinitionsFile(file, systemId);
                if (!this.isLatestDefinitions(systemId, new ModuleVersion(Jahia.VERSION), file.lastModified())) continue;
                this.initializedSystemIds.add(systemId);
                this.deployDefinitions(systemId, Jahia.VERSION, file.lastModified());
            }
        }
    }

    public void reloadNodeTypeRegistry() throws RepositoryException {
        ArrayList<Object> filesList = new ArrayList();
        NodeTypeRegistry instance = NodeTypeRegistry.getInstance();
        logger.info("Loading all CNDs from DB ..");
        ArrayList<String> remfiles = new ArrayList<String>(this.nodeTypesDBService.getFilesList());
        ArrayList<String> reloadedSystemIds = new ArrayList<String>();
        while (!remfiles.isEmpty() && !remfiles.equals(filesList)) {
            filesList = new ArrayList<String>(remfiles);
            remfiles.clear();
            for (String string : filesList) {
                try {
                    if (!string.endsWith(".cnd")) continue;
                    String cndFile = this.nodeTypesDBService.readFile(string);
                    String systemId = StringUtils.substringBeforeLast((String)string, (String)".cnd");
                    if (!this.initializedSystemIds.contains(systemId)) {
                        logger.debug("Loading CND : {}", (Object)string);
                        instance.addDefinitionsFile((Resource)new ByteArrayResource(cndFile.getBytes(StandardCharsets.UTF_8), string), systemId);
                    }
                    reloadedSystemIds.add(systemId);
                }
                catch (NoSuchNodeTypeException | ParseException e) {
                    logger.debug("{} cannot be parsed, reorder later", (Object)string);
                    remfiles.add(string);
                }
                catch (IOException e) {
                    logger.error("Cannot parse CND file from DB : " + string, (Throwable)e);
                }
            }
        }
        List<String> systemIds = NodeTypeRegistry.getInstance().getSystemIds();
        systemIds.removeAll(reloadedSystemIds);
        for (String systemId : systemIds) {
            NodeTypeRegistry.getInstance().unregisterNodeTypes(systemId);
        }
        if (!remfiles.isEmpty()) {
            logger.error("Cannot read CND from : {}", remfiles);
        }
        this.registerNamespaces();
    }

    private void registerNamespaces() {
        try {
            NamespaceRegistry nsRegistry = this.sessionFactory.getNamespaceRegistry();
            NodeTypeRegistry ntRegistry = NodeTypeRegistry.getInstance();
            ImmutableSet prefixes = ImmutableSet.copyOf((Object[])nsRegistry.getPrefixes());
            for (Map.Entry<String, String> namespaceEntry : ntRegistry.getNamespaces().entrySet()) {
                if (prefixes.contains(namespaceEntry.getKey())) continue;
                nsRegistry.registerNamespace(namespaceEntry.getKey(), namespaceEntry.getValue());
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to register namespaces", (Throwable)e);
        }
    }

    public boolean isLatestDefinitions(String systemId, ModuleVersion version, long lastModified) {
        long lastDeployed;
        String key2;
        String key;
        if (version != null && this.deploymentProperties.containsKey(key = systemId + ".version")) {
            ModuleVersion lastDeployed2 = new ModuleVersion(this.deploymentProperties.getProperty(key));
            if (lastDeployed2.compareTo(version) > 0) {
                logger.info("Previously deployed " + systemId + " version was : " + this.deploymentProperties.getProperty(key) + ", ignoring version " + systemId + " / " + version + " / " + lastModified);
                return false;
            }
            if (lastDeployed2.compareTo(version) < 0) {
                return true;
            }
        }
        if (this.deploymentProperties.containsKey(key2 = systemId + ".lastModified") && (lastDeployed = Long.parseLong(this.deploymentProperties.getProperty(key2))) >= lastModified) {
            logger.info("Previously deployed " + systemId + " was done at : " + new Date(lastDeployed) + ", ignoring version " + systemId + " / " + version + " / " + new Date(lastModified));
            return false;
        }
        return true;
    }

    public List<String> getInitializedSystemIds() {
        return new LinkedList<String>(this.initializedSystemIds);
    }

    public Set<String> getNoValidityCheckTypes() {
        return this.noValidityCheckTypes;
    }

    public void setNoValidityCheckTypes(Set<String> noValidityCheckTypes) {
        this.noValidityCheckTypes = noValidityCheckTypes;
    }

    public Set<String> getNoLanguageValidityCheckTypes() {
        return this.noLanguageValidityCheckTypes;
    }

    public void setNoLanguageValidityCheckTypes(Set<String> noLanguageValidityCheckTypes) {
        this.noLanguageValidityCheckTypes = noLanguageValidityCheckTypes;
    }

    public void addValidator(String nodeType, Class<? extends JCRNodeValidator> validatorClass) {
        if (this.validators == null) {
            this.validators = new ConcurrentHashMap<String, Class<? extends JCRNodeValidator>>();
        }
        this.validators.put(nodeType, validatorClass);
        try {
            this.validatorCreators.put(nodeType, validatorClass.getConstructor(JCRNodeWrapper.class));
        }
        catch (Exception e) {
            logger.error("Unable to instantiate decorator: " + validatorClass, (Throwable)e);
        }
    }

    public void removeValidator(String nodeType) {
        if (this.validators == null) {
            this.validators = new ConcurrentHashMap<String, Class<? extends JCRNodeValidator>>();
        }
        this.validators.remove(nodeType);
        this.validatorCreators.remove(nodeType);
    }

    public Map<String, Constructor<?>> getValidators() {
        return this.validatorCreators;
    }

    public void setValidators(Map<String, String> validators) {
        if (validators == null) {
            return;
        }
        for (Map.Entry<String, String> validator : validators.entrySet()) {
            try {
                this.addValidator(validator.getKey(), Class.forName(validator.getValue()));
            }
            catch (ClassNotFoundException e) {
                logger.error("Unable to find the validator class " + validator.getClass() + " defined for node type " + validator.getKey(), (Throwable)e);
            }
        }
    }

    private static class Holder {
        static final JCRStoreService INSTANCE = new JCRStoreService();

        private Holder() {
        }
    }
}

