/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RangeIterator;

public class MultipleIterator<T extends RangeIterator>
implements RangeIterator {
    private List<T> iterators;
    private int iteratorIndex = 0;
    private long position = 0L;
    private long size = -1L;
    private long limit;

    public MultipleIterator(List<T> iterators, long limit) {
        this.iterators = iterators;
        this.limit = limit;
    }

    public void skip(long skipNum) {
        for (long l = 0L; l < skipNum; ++l) {
            this.next();
        }
    }

    public long getSize() {
        if (this.size < 0L) {
            this.size = 0L;
            for (RangeIterator it : this.iterators) {
                this.size += it.getSize();
            }
            if (this.limit >= 0L && this.size > this.limit) {
                this.size = this.limit;
            }
        }
        return this.size;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean hasNext() {
        if (this.limit >= 0L && this.position == this.limit) {
            return false;
        }
        if (!this.iterators.isEmpty()) {
            return ((RangeIterator)this.iterators.get(this.getIteratorIndex())).hasNext();
        }
        return false;
    }

    public Object next() {
        if (this.limit >= 0L && this.position == this.limit) {
            throw new NoSuchElementException();
        }
        if (!this.iterators.isEmpty()) {
            Object next = ((RangeIterator)this.iterators.get(this.getIteratorIndex())).next();
            ++this.position;
            return next;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private int getIteratorIndex() {
        while (!((RangeIterator)this.iterators.get(this.iteratorIndex)).hasNext() && this.iteratorIndex < this.iterators.size() - 1) {
            ++this.iteratorIndex;
        }
        return this.iteratorIndex;
    }
}

