/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.HashMap;
import java.util.Map;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.templates.JahiaModuleAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRNodeDecoratorDefinition
implements JahiaModuleAware {
    private static Logger logger = LoggerFactory.getLogger(JCRNodeDecoratorDefinition.class);
    private Map<String, Class> decorators = null;
    private Map<String, String> decoratorsAsString = new HashMap<String, String>();
    private JahiaTemplatesPackage module;

    public Map<String, Class> getDecorators() {
        if (this.decorators == null && this.decoratorsAsString != null) {
            this.decorators = new HashMap<String, Class>();
            for (Map.Entry<String, String> decorator : this.decoratorsAsString.entrySet()) {
                try {
                    this.decorators.put(decorator.getKey(), this.module.getClassLoader().loadClass(decorator.getValue()));
                }
                catch (Exception e) {
                    logger.error("Unable to instanciate decorator: " + decorator.getValue(), (Throwable)e);
                }
            }
        }
        return this.decorators;
    }

    @Override
    public void setJahiaModule(JahiaTemplatesPackage module) {
        this.module = module;
    }

    public void setDecorators(Map<String, String> decorators) {
        this.decoratorsAsString = decorators;
    }
}

