/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator.validation;

import java.util.HashMap;
import java.util.Map;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.templates.JahiaModuleAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRNodeValidatorDefinition
implements JahiaModuleAware {
    private static Logger logger = LoggerFactory.getLogger(JCRNodeValidatorDefinition.class);
    private Map<String, Class> validators = null;
    private Map<String, String> validatorsAsString = new HashMap<String, String>();
    private JahiaTemplatesPackage module;

    public Map<String, Class> getValidators() {
        if (this.validators == null && this.validatorsAsString != null) {
            this.validators = new HashMap<String, Class>();
            for (Map.Entry<String, String> decorator : this.validatorsAsString.entrySet()) {
                try {
                    this.validators.put(decorator.getKey(), this.module.getClassLoader().loadClass(decorator.getValue()));
                }
                catch (Exception e) {
                    logger.error("Unable to instantiate decorator: " + decorator.getValue(), (Throwable)e);
                }
            }
        }
        return this.validators;
    }

    @Override
    public void setJahiaModule(JahiaTemplatesPackage module) {
        this.module = module;
    }

    public void setValidators(Map<String, String> decorators) {
        this.validatorsAsString = decorators;
    }
}

