/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueImpl
implements Value {
    private static final Logger logger = LoggerFactory.getLogger(ValueImpl.class);
    protected String value;
    protected int type;

    public ValueImpl(String v) {
        this(v, 1);
    }

    public ValueImpl(String v, int type) {
        this(v, type, false);
    }

    public ValueImpl(Calendar c) {
        this(ISO8601.format((Calendar)c), 5);
    }

    public ValueImpl(boolean b) {
        this(Boolean.toString(b), 6);
    }

    public ValueImpl(long b) {
        this(Long.toString(b), 3);
    }

    public ValueImpl(double d) {
        this(Double.toString(d), 4);
    }

    public ValueImpl(String v, int type, boolean isConstraint) {
        this.value = v;
        this.type = type;
        if (this.value != null && !isConstraint) {
            switch (type) {
                case 3: {
                    this.value = Long.toString(new Double(this.value).longValue());
                }
            }
        }
        if (this.value != null && isConstraint) {
            switch (type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (this.value.indexOf(44) != -1) break;
                    this.value = "[" + this.value + "," + this.value + "]";
                    break;
                }
                case 1: {
                    Pattern.compile(v);
                }
            }
        }
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value;
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        String s = this.getString();
        try {
            return new ByteArrayInputStream(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new ByteArrayInputStream(s.getBytes());
        }
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        if (this.getType() == 5) {
            return this.getDate().getTimeInMillis();
        }
        String s = this.getString();
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(s);
        }
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        String s = this.getString();
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(s);
        }
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        return ISO8601.parse((String)this.getString());
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        String s = this.getString();
        try {
            return Boolean.parseBoolean(s);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(s);
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean checkConstraint(String value) throws ValueFormatException, IllegalStateException, RepositoryException {
        if (value == null || value.length() == 0) {
            return true;
        }
        try {
            switch (this.type) {
                case 1: {
                    Pattern p = Pattern.compile(this.getString());
                    return p.matcher(value).matches();
                }
                case 3: 
                case 4: 
                case 5: {
                    String s = this.getString();
                    boolean lowerBoundIncluded = s.charAt(0) == '[';
                    boolean upperBoundIncluded = s.charAt(s.length() - 1) == ']';
                    String lowerBound = s.substring(1, s.indexOf(44));
                    String upperBound = s.substring(s.indexOf(44) + 1, s.length() - 1);
                    switch (this.type) {
                        case 3: 
                        case 4: {
                            double v = Double.parseDouble(value);
                            double l = Double.parseDouble(lowerBound);
                            double u = Double.parseDouble(upperBound);
                            return (lowerBoundIncluded ? v >= l : v > l) && (upperBoundIncluded ? v <= u : v < u);
                        }
                        case 5: {
                            long v = Long.parseLong(value);
                            long l = ISO8601.parse((String)lowerBound).getTimeInMillis();
                            long u = ISO8601.parse((String)upperBound).getTimeInMillis();
                            return (lowerBoundIncluded ? v >= l : v > l) && (upperBoundIncluded ? v <= u : v < u);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return true;
        }
        return true;
    }

    public Binary getBinary() throws RepositoryException {
        return null;
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        String s = this.getString();
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(s);
        }
    }
}

