/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ModifiedPropertyFact;
import org.jahia.services.content.rules.Updateable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedPropertyFact
implements Updateable,
ModifiedPropertyFact {
    private static final Logger logger = LoggerFactory.getLogger(ChangedPropertyFact.class);
    private String path;
    private JCRPropertyWrapper property;
    private String nodePath;
    private String name;
    private Object value;
    private AddedNodeFact nodeWrapper;
    private String operationType;

    public ChangedPropertyFact(AddedNodeFact nodeWrapper, JCRPropertyWrapper property) throws RepositoryException {
        this.nodeWrapper = nodeWrapper;
        this.property = property;
        this.path = property.getPath();
        this.operationType = nodeWrapper.getOperationType();
    }

    public ChangedPropertyFact(AddedNodeFact nodeWrapper, String name, Object o, KnowledgeHelper drools) throws RepositoryException {
        this(nodeWrapper, name, o, drools, true);
    }

    public ChangedPropertyFact(AddedNodeFact nodeWrapper, String name, Object o, KnowledgeHelper drools, boolean overrideIfExisting) throws RepositoryException {
        if (nodeWrapper == null) {
            return;
        }
        this.nodeWrapper = nodeWrapper;
        JCRNodeWrapper node = nodeWrapper.getNode();
        this.nodePath = nodeWrapper.getPath();
        this.name = name;
        this.value = o;
        if (node == null || AddedNodeFact.isLocked(node)) {
            logger.debug("Node is locked, delay property update to later");
            List list = (List)drools.getWorkingMemory().getGlobal("delayedUpdates");
            list.add(this);
        } else {
            this.setProperty(node, name, o, overrideIfExisting);
        }
        this.operationType = nodeWrapper.getOperationType();
    }

    @Override
    public void doUpdate(JCRSessionWrapper s, List<Updateable> delayedUpdates) throws RepositoryException {
        try {
            JCRNodeWrapper node = s.getNode(this.nodePath);
            if (AddedNodeFact.isLocked(node)) {
                logger.debug("Node is still locked, delay property update to later");
                delayedUpdates.add(this);
            } else {
                this.setProperty(node, this.name, this.value, true);
            }
        }
        catch (PathNotFoundException e) {
            logger.warn("Node does not exist {}", (Object)this.nodePath);
        }
    }

    private ExtendedPropertyDefinition getPropertyDefinition(Node node, String name) throws RepositoryException {
        HashMap<String, ExtendedPropertyDefinition> defs = new HashMap<String, ExtendedPropertyDefinition>();
        NodeTypeRegistry reg = NodeTypeRegistry.getInstance();
        ExtendedPropertyDefinition propDef = null;
        try {
            ExtendedNodeType nt = reg.getNodeType(node.getPrimaryNodeType().getName());
            defs.putAll(nt.getPropertyDefinitionsAsMap());
            NodeType[] p = node.getMixinNodeTypes();
            for (int i = 0; i < p.length; ++i) {
                defs.putAll(reg.getNodeType(p[i].getName()).getPropertyDefinitionsAsMap());
            }
            propDef = (ExtendedPropertyDefinition)defs.get(name);
        }
        catch (NoSuchNodeTypeException e) {
            logger.debug("Nodetype not supported", (Throwable)e);
        }
        return propDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProperty(JCRNodeWrapper node, String name, Object objectValue, boolean overrideIfExisting) throws RepositoryException {
        try {
            Value[] values;
            if (!overrideIfExisting && this.propertyExists(node, name)) {
                return;
            }
            ExtendedPropertyDefinition propDef = this.getPropertyDefinition(node, name);
            if (propDef == null) {
                logger.error("Property {} does not exist in {} !", (Object)node, (Object)node.getPath());
                return;
            }
            ValueFactory factory = node.getSession().getValueFactory();
            if (objectValue.getClass().isArray()) {
                values = new Value[Array.getLength(objectValue)];
                for (int i = 0; i < Array.getLength(objectValue); ++i) {
                    values[i] = this.createValue(Array.get(objectValue, i), propDef, factory);
                }
            } else {
                values = new Value[]{this.createValue(objectValue, propDef, factory)};
            }
            if (values.length > 0) {
                this.setProperty(node, name, propDef, values);
            }
        }
        catch (NoSuchNodeTypeException e) {
            logger.debug("Nodetype not supported", (Throwable)e);
        }
        finally {
            if (objectValue instanceof File) {
                ((File)objectValue).delete();
            }
        }
    }

    private void setProperty(JCRNodeWrapper node, String name, ExtendedPropertyDefinition propDef, Value[] values) throws RepositoryException {
        if (!propDef.isMultiple()) {
            this.property = node.setProperty(name, values[0]);
        } else if (node.hasProperty(name)) {
            this.property = node.getProperty(name);
            JCRValueWrapper[] oldValues = this.property.getValues();
            Value[] newValues = new Value[oldValues.length + values.length];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            System.arraycopy(values, 0, newValues, oldValues.length, values.length);
            this.property.setValue(newValues);
        } else {
            this.property = node.setProperty(name, values);
        }
        logger.debug("Property set {} / {}", (Object)this.nodePath, (Object)name);
        if (this.property != null) {
            this.path = this.property.getPath();
        }
    }

    private boolean propertyExists(JCRNodeWrapper node, String name) {
        try {
            node.getProperty(name);
            return true;
        }
        catch (RepositoryException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Create new property {} on node ", (Object)node.getPath());
            }
            return false;
        }
    }

    private Value createValue(Object objectValue, ExtendedPropertyDefinition propDef, ValueFactory factory) {
        if (objectValue instanceof String && propDef.getSelector() == 13) {
            try {
                return factory.createValue(Category.getCategoryPath((String)objectValue));
            }
            catch (Exception e) {
                logger.warn("Can't get category {}, cause {}", objectValue, (Object)e.getMessage());
                return null;
            }
        }
        return JCRContentUtils.createValue(objectValue, factory);
    }

    @Override
    public String getName() throws RepositoryException {
        if (this.property != null) {
            return this.property.getName();
        }
        return null;
    }

    public String getStringValue() throws RepositoryException {
        if (this.property != null) {
            if (this.property.isMultiple()) {
                return this.getStringValues().toString();
            }
            JCRValueWrapper v = this.property.getValue();
            if (v.getType() == 10 || v.getType() == 9) {
                JCRNodeWrapper node = v.getNode();
                if (node != null) {
                    return node.getPath();
                }
            } else {
                return v.getString();
            }
        }
        return null;
    }

    public List<String> getStringValues() throws RepositoryException {
        ArrayList<String> r = new ArrayList<String>();
        if (this.property != null && this.property.isMultiple()) {
            JCRValueWrapper[] vs;
            for (JCRValueWrapper v : vs = this.property.getValues()) {
                if (v.getType() == 10 || v.getType() == 9) {
                    JCRNodeWrapper node = v.getNode();
                    if (node == null) continue;
                    r.add(node.getPath());
                    continue;
                }
                r.add(v.getString());
            }
        } else {
            r.add(this.getStringValue());
        }
        return r;
    }

    public AddedNodeFact getNodeValue() throws RepositoryException {
        if (this.property != null) {
            if (this.property.isMultiple()) {
                return null;
            }
            JCRValueWrapper v = this.property.getValue();
            if (v.getType() == 10 || v.getType() == 9) {
                JCRNodeWrapper node = v.getNode();
                if (node != null) {
                    return new AddedNodeFact(node);
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public Object getValues() throws RepositoryException {
        if (this.property != null) {
            return this.property.getValues();
        }
        return null;
    }

    public Object getValue() throws RepositoryException {
        if (this.property != null) {
            return this.property.getValue();
        }
        return null;
    }

    public int getType() throws RepositoryException {
        if (this.property != null) {
            return this.property.getType();
        }
        return 0;
    }

    public String getLanguage() throws RepositoryException {
        if (this.property != null) {
            return this.property.getLocale();
        }
        return null;
    }

    @Override
    public AddedNodeFact getNode() {
        return this.nodeWrapper;
    }

    JCRPropertyWrapper getProperty() {
        return this.property;
    }

    public String toString() {
        return this.path;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public List<String> getInstalledModules() {
        return this.nodeWrapper.getInstalledModules();
    }

    @Override
    public String getWorkspace() throws RepositoryException {
        return this.getNode().getWorkspace();
    }

    @Override
    public JCRSessionWrapper getSession() throws RepositoryException {
        return this.getNode().getSession();
    }

    @Override
    public String getNodeIdentifier() throws RepositoryException {
        return this.getNode().getIdentifier();
    }

    @Override
    public String getNodeType() throws RepositoryException {
        return this.getNode().getNodeType();
    }
}

