/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.history.NodeVersionHistoryJob;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeVersionHistoryListener
extends DefaultEventListener {
    private static final Logger logger = LoggerFactory.getLogger(NodeVersionHistoryListener.class);
    private static boolean disabled;
    private SchedulerService schedulerService;

    @Override
    public int getEventTypes() {
        return 2;
    }

    public void onEvent(EventIterator events) {
        if (NodeVersionHistoryListener.isDisabled()) {
            return;
        }
        String siteDeleted = null;
        HashSet<String> ids = new HashSet<String>();
        try {
            while (events.hasNext()) {
                Event ev = events.nextEvent();
                ids.add(ev.getIdentifier());
                if (siteDeleted != null || !ev.getPath().startsWith("/sites/") || ev.getPath().lastIndexOf("/") != 6) continue;
                siteDeleted = ev.getPath();
            }
            if (siteDeleted != null && !ids.isEmpty()) {
                this.scheduleJob(siteDeleted, ids);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void scheduleJob(String site, Set<String> ids) {
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Node version history purge for site " + site, NodeVersionHistoryJob.class);
        jobDetail.setGroup("Maintenance");
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("site", site);
        jobDataMap.put((Object)"nodeIds", ids);
        logger.info("Scheduling node version history purge job for {} nodes in site {}", (Object)ids.size(), (Object)site);
        try {
            this.schedulerService.scheduleJobAtEndOfRequest(jobDetail);
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public static synchronized void setDisabled(boolean disabled) {
        NodeVersionHistoryListener.disabled = disabled;
    }

    private static synchronized boolean isDisabled() {
        return disabled;
    }
}

