/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.MissingTemplatesValidationResult;
import org.jahia.services.importexport.validation.ModuleDependencyAware;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class MissingTemplatesValidator
implements ImportValidator,
ModuleDependencyAware {
    private static final Logger logger = LoggerFactory.getLogger(MissingTemplatesValidator.class);
    private static final Comparator<Map.Entry<String, Integer>> MISSING_COUNT_COMPARATOR = new Comparator<Map.Entry<String, Integer>>(){

        @Override
        public int compare(Map.Entry<String, Integer> entry1, Map.Entry<String, Integer> entry2) {
            return entry1.getValue().compareTo(entry2.getValue());
        }
    };
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("(#?/sites/[^/]*|\\$currentSite)/templates/(.*)");
    private Set<String> availableTemplateSets;
    private Map<String, Boolean> checked = new HashMap<String, Boolean>();
    private Set<String> dependencies = Collections.emptySet();
    private Map<String, Integer> missingInAllTemplateSets = new HashMap<String, Integer>();
    private Map<String, Set<String>> missingTemplates = new TreeMap<String, Set<String>>();
    private Set<String> modules = Collections.emptySet();
    private String targetTemplateSet;
    private boolean targetTemplateSetPresent;
    private JahiaTemplateManagerService templateManagerService;

    private Set<String> getAvailableTemplateSets() {
        if (null == this.availableTemplateSets) {
            this.availableTemplateSets = this.templateManagerService.getTemplateSetNames();
        }
        return this.availableTemplateSets;
    }

    @Override
    public ValidationResult getResult() {
        Map<String, Integer> modulesMissingCounts = Collections.emptyMap();
        if (!this.missingInAllTemplateSets.isEmpty()) {
            modulesMissingCounts = new LinkedHashMap(this.missingInAllTemplateSets.size());
            LinkedList<Map.Entry<String, Integer>> mapEntries = new LinkedList<Map.Entry<String, Integer>>(this.missingInAllTemplateSets.entrySet());
            Collections.sort(mapEntries, MISSING_COUNT_COMPARATOR);
            for (Map.Entry entry : mapEntries) {
                modulesMissingCounts.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        return new MissingTemplatesValidationResult(this.missingTemplates, this.targetTemplateSet, this.targetTemplateSetPresent, modulesMissingCounts);
    }

    @Override
    public void initDependencies(String templateSetName, List<String> modules) {
        this.targetTemplateSet = templateSetName;
        this.modules = new LinkedHashSet<String>(modules);
    }

    private boolean isTemplatePresent(String templateName) {
        if (this.targetTemplateSetPresent) {
            return this.templateManagerService.isTemplatePresent(templateName, this.dependencies);
        }
        for (String setName : this.getAvailableTemplateSets()) {
            boolean found;
            LinkedHashSet<String> dependenciesToCheck = new LinkedHashSet<String>(this.modules.size() + 1);
            dependenciesToCheck.add(setName);
            dependenciesToCheck.addAll(this.modules);
            if (!this.missingInAllTemplateSets.containsKey(setName)) {
                this.missingInAllTemplateSets.put(setName, 0);
            }
            if (found = this.templateManagerService.isTemplatePresent(templateName, dependenciesToCheck)) continue;
            this.missingInAllTemplateSets.put(setName, 1 + this.missingInAllTemplateSets.get(setName));
        }
        return true;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        if ("jnt:virtualsite".equals(StringUtils.defaultString((String)atts.getValue("jcr:primaryType")))) {
            this.dependencies = new LinkedHashSet<String>(this.modules.size() + 1);
            this.dependencies.add(this.targetTemplateSet);
            this.dependencies.addAll(this.modules);
            boolean bl = this.targetTemplateSetPresent = this.templateManagerService.getTemplatePackageById(this.targetTemplateSet) != null;
        }
        if (this.dependencies.isEmpty()) {
            return;
        }
        String templateAttr = atts.getValue("j:templateName");
        if (StringUtils.isEmpty((String)templateAttr)) {
            templateAttr = StringUtils.substringAfterLast((String)atts.getValue("j:templateNode"), (String)"/");
        }
        if (StringUtils.isEmpty((String)templateAttr)) {
            return;
        }
        String templateName = ISO9075.decode((String)templateAttr);
        if (this.checked.containsKey(templateName)) {
            if (!this.checked.get(templateName).booleanValue()) {
                this.missingTemplates.get(templateName).add(currentPath);
            }
        } else if (!this.isTemplatePresent(templateName)) {
            this.checked.put(templateName, Boolean.FALSE);
            TreeSet<String> pathes = new TreeSet<String>();
            pathes.add(currentPath);
            this.missingTemplates.put(templateName, pathes);
        } else {
            this.checked.put(templateName, Boolean.TRUE);
        }
    }
}

