/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.Map;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.mail.MailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationNotificationHandler {
    private static Logger logger = LoggerFactory.getLogger(ValidationNotificationHandler.class);

    public static void notifyAdministratorWhenValidationFailed(Map<Object, Object> siteInfo, String errors) {
        String siteKey = (String)siteInfo.get("sitekey");
        String importFile = (String)siteInfo.get("importFileName");
        String subject = "Site import failed";
        String text = String.format("The import file %s for the site %s has validation errors. you could try to redo import after the errors are fixed. \n For more details about errors please check the error logs.\n\n\n VALIDATION ERRORS:\n =====================================\n %s", importFile, siteKey, ValidationNotificationHandler.prettifyErrors(errors));
        MailService mailService = ServicesRegistry.getInstance().getMailService();
        if (mailService != null && mailService.isEnabled()) {
            mailService.sendMessage(null, null, null, null, subject, text);
        } else {
            logger.warn("Mail service is disabled now, notification for validation failure is ignored");
        }
    }

    private static String prettifyErrors(String errors) {
        String spaces = "    ";
        return errors.replaceAll("\\{", "{\n" + spaces).replaceAll("\\[", "[\n" + spaces + spaces).replaceAll("\\]", "\n" + spaces + "]").replaceAll("\\}", "\n}\n").replaceAll(",", ",\n" + spaces + spaces);
    }
}

