/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager;

import org.jahia.osgi.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;

public final class BundlePersistentInfo {
    private final String location;
    private final int state;
    private final String symbolicName;
    private final String version;
    private final int startLevel;

    public BundlePersistentInfo(Bundle bundle) {
        this(bundle.getLocation(), bundle.getSymbolicName(), BundleUtils.getModuleVersion(bundle), BundleUtils.getPersistentState(bundle), ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel());
    }

    public BundlePersistentInfo(String location, String symbolicName, String version, int state, int startLevel) {
        this.location = location;
        this.symbolicName = symbolicName;
        this.version = version;
        this.state = state;
        this.startLevel = startLevel;
    }

    public String getLocation() {
        return this.location;
    }

    public int getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public String getLocationProtocol() {
        int delimiter = this.location == null ? -1 : this.location.indexOf(58);
        return delimiter > -1 ? this.location.substring(0, delimiter) : null;
    }

    public boolean isSameVersionAs(BundlePersistentInfo other) {
        return other.getSymbolicName().equals(this.symbolicName) && other.getVersion().equals(this.version);
    }
}

