/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.spi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.data.templates.ModuleState;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.BundleState;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.modulemanager.BundleBucketInfo;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.InvalidTargetException;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleNotFoundException;
import org.jahia.services.modulemanager.spi.BundleService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBundleService
implements BundleService {
    private JahiaTemplateManagerService templateManagerService;
    private static final Logger logger = LoggerFactory.getLogger(DefaultBundleService.class);

    protected static Bundle getBundleEnsureExists(BundleInfo bundleInfo) throws ModuleNotFoundException {
        Bundle bundle = BundleUtils.getBundleBySymbolicName(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
        if (bundle == null) {
            throw new ModuleNotFoundException(bundleInfo.getKey());
        }
        return bundle;
    }

    public static String getClusterNodeId() {
        return System.getProperty("cluster.node.serverId");
    }

    private static boolean isGroupIdMatches(BundleBucketInfo bundleBucketInfo, Bundle bundle) {
        String expected = bundleBucketInfo.getGroupId();
        return expected == null || "*".equals(expected) || StringUtils.equals((String)expected, (String)BundleUtils.getModuleGroupId(bundle));
    }

    private static boolean isSymbolicNameMatches(BundleBucketInfo bundleBucketInfo, Bundle bundle) {
        String expected = bundleBucketInfo.getSymbolicName();
        return expected == null || "*".equals(expected) || StringUtils.equals((String)expected, (String)bundle.getSymbolicName());
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    @Override
    public void install(String uri, String target, boolean start) throws ModuleManagementException {
        this.install(uri, target, start, SettingsBean.getInstance().getModuleStartLevel());
    }

    @Override
    public void install(String uri, String target, boolean start, int startLevel) throws ModuleManagementException {
        try {
            BundleContext bundleContext = FrameworkService.getBundleContext();
            Bundle bundle = bundleContext.getBundle(uri);
            if (bundle == null || bundle.getState() == 1) {
                bundle = bundleContext.installBundle(uri);
                ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
            } else {
                BundleLifecycleUtils.updateBundle(bundle);
            }
            if (start) {
                bundle.start();
            }
            BundleLifecycleUtils.startBundlesPendingDependencies();
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    protected void refreshUninstalledBundle(Bundle bundle) {
        if (1 == bundle.getState()) {
            BundleLifecycleUtils.refreshBundle(bundle);
        }
    }

    @Override
    public void resolve(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        BundleLifecycleUtils.resolveBundle(DefaultBundleService.getBundleEnsureExists(bundleInfo));
    }

    @Override
    public void start(BundleInfo bundleInfo, String target) throws ModuleNotFoundException {
        try {
            DefaultBundleService.getBundleEnsureExists(bundleInfo).start();
            BundleLifecycleUtils.startBundlesPendingDependencies();
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    @Override
    public void stop(BundleInfo bundleInfo, String target) throws ModuleNotFoundException {
        try {
            DefaultBundleService.getBundleEnsureExists(bundleInfo).stop();
            BundleLifecycleUtils.startBundlesPendingDependencies();
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    @Override
    public void uninstall(BundleInfo bundleInfo, String target) throws ModuleNotFoundException {
        try {
            Bundle bundle = DefaultBundleService.getBundleEnsureExists(bundleInfo);
            bundle.uninstall();
            this.refreshUninstalledBundle(bundle);
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    @Override
    public void refresh(BundleInfo bundleInfo, String target) throws ModuleManagementException {
        this.refresh(Collections.singleton(bundleInfo), target);
    }

    @Override
    public void refresh(Collection<BundleInfo> bundleInfos, String target) throws ModuleManagementException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(bundleInfos.size());
        for (BundleInfo bundleInfo : bundleInfos) {
            bundles.add(DefaultBundleService.getBundleEnsureExists(bundleInfo));
        }
        BundleLifecycleUtils.refreshBundles(bundles, false, false);
    }

    @Override
    public void update(BundleInfo bundleInfo, String target) throws ModuleManagementException {
        try {
            Bundle bundle = DefaultBundleService.getBundleEnsureExists(bundleInfo);
            BundleLifecycleUtils.updateBundle(bundle);
            BundleLifecycleUtils.startBundlesPendingDependencies();
        }
        catch (BundleException e) {
            throw new ModuleManagementException(e);
        }
    }

    @Override
    public Map<String, BundleService.BundleInformation> getInfo(BundleInfo bundleInfo, String target) throws ModuleManagementException, InvalidTargetException {
        BundleService.BundleInformation info;
        DefaultBundleService.assertNoTarget(target);
        try {
            info = this.getLocalInfo(bundleInfo);
        }
        catch (Exception e) {
            logger.error("Error retrieving bundle info", (Throwable)e);
            info = new BundleService.BundleInformation(){

                @Override
                public BundleState getOsgiState() throws ModuleManagementException {
                    throw new ModuleManagementException(e.getMessage(), e);
                }
            };
        }
        return Collections.singletonMap(DefaultBundleService.getClusterNodeId(), info);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getInfos(Collection<BundleInfo> bundleInfos, String target) throws ModuleManagementException, InvalidTargetException {
        Map<Object, Object> infos;
        DefaultBundleService.assertNoTarget(target);
        try {
            infos = new LinkedHashMap();
            for (BundleInfo bundleInfo : new LinkedHashSet<BundleInfo>(bundleInfos)) {
                BundleService.BundleInformation info = this.getLocalInfo(bundleInfo);
                infos.put(bundleInfo.getKey(), info);
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving bundle infos", (Throwable)e);
            infos = DefaultBundleService.newFailingMap(e);
        }
        return Collections.singletonMap(DefaultBundleService.getClusterNodeId(), infos);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getInfos(BundleBucketInfo bundleBucketInfo, String target) throws ModuleManagementException, InvalidTargetException {
        Map<String, BundleService.BundleInformation> infos;
        DefaultBundleService.assertNoTarget(target);
        try {
            infos = this.getLocalInfos(bundleBucketInfo);
        }
        catch (Exception e) {
            logger.error("Error retrieving bundle infos", (Throwable)e);
            infos = DefaultBundleService.newFailingMap(e);
        }
        return Collections.singletonMap(DefaultBundleService.getClusterNodeId(), infos);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getAllInfos(String target) throws ModuleManagementException, InvalidTargetException {
        Map<String, BundleService.BundleInformation> infos;
        DefaultBundleService.assertNoTarget(target);
        try {
            infos = this.getAllLocalInfos();
        }
        catch (Exception e) {
            logger.error("Error retrieving bundle infos", (Throwable)e);
            infos = DefaultBundleService.newFailingMap(e);
        }
        return Collections.singletonMap(DefaultBundleService.getClusterNodeId(), infos);
    }

    private static void assertNoTarget(String target) {
        if (target != null) {
            logger.warn("Supplied target " + target + " for module operation is not valid");
        }
    }

    private static Map<String, BundleService.BundleInformation> newFailingMap(final Exception e) {
        return new FailingMap<String, BundleService.BundleInformation>(new ExceptionProvider(){

            @Override
            public RuntimeException get() {
                return new ModuleManagementException(e.getMessage(), e);
            }
        });
    }

    @Override
    public BundleState getLocalState(BundleInfo bundleInfo) throws ModuleNotFoundException {
        Bundle bundle = DefaultBundleService.getBundleEnsureExists(bundleInfo);
        return BundleState.fromInt(bundle.getState());
    }

    @Override
    public BundleService.BundleInformation getLocalInfo(BundleInfo bundleInfo) throws ModuleNotFoundException {
        Bundle bundle = DefaultBundleService.getBundleEnsureExists(bundleInfo);
        final BundleState osgiState = BundleState.fromInt(bundle.getState());
        if (!BundleUtils.isJahiaModuleBundle(bundle)) {
            if (BundleUtils.isFragment(bundle)) {
                return new BundleService.FragmentInformation(){

                    @Override
                    public BundleState getOsgiState() {
                        return osgiState;
                    }
                };
            }
            return new BundleService.BundleInformation(){

                @Override
                public BundleState getOsgiState() {
                    return osgiState;
                }
            };
        }
        final ModuleState moduleState = this.templateManagerService.getModuleStates().get(bundle);
        return new BundleService.ModuleInformation(){

            @Override
            public BundleState getOsgiState() {
                return osgiState;
            }

            @Override
            public ModuleState.State getModuleState() {
                return moduleState == null ? null : moduleState.getState();
            }
        };
    }

    @Override
    public Map<String, BundleService.BundleInformation> getLocalInfos(BundleBucketInfo bundleBucketInfo) throws ModuleManagementException {
        Bundle[] bundles = FrameworkService.getBundleContext().getBundles();
        LinkedHashMap<String, BundleService.BundleInformation> infoByKey = new LinkedHashMap<String, BundleService.BundleInformation>();
        for (Bundle bundle : bundles) {
            if (!DefaultBundleService.isSymbolicNameMatches(bundleBucketInfo, bundle) || !DefaultBundleService.isGroupIdMatches(bundleBucketInfo, bundle)) continue;
            this.addToBundleInfoMap(bundle, infoByKey);
        }
        return infoByKey;
    }

    @Override
    public Map<String, BundleService.BundleInformation> getAllLocalInfos() throws ModuleManagementException {
        Bundle[] bundles = FrameworkService.getBundleContext().getBundles();
        LinkedHashMap<String, BundleService.BundleInformation> infoByKey = new LinkedHashMap<String, BundleService.BundleInformation>(bundles.length);
        for (Bundle bundle : bundles) {
            this.addToBundleInfoMap(bundle, infoByKey);
        }
        return infoByKey;
    }

    private void addToBundleInfoMap(Bundle bundle, Map<String, BundleService.BundleInformation> bundleInfoByKey) {
        BundleInfo bundleInfo = BundleInfo.fromBundle(bundle);
        BundleService.BundleInformation bundleInformation = this.getLocalInfo(bundleInfo);
        bundleInfoByKey.put(bundleInfo.getKey(), bundleInformation);
    }

    protected static class FailingMap<K, V>
    implements Map<K, V> {
        private ExceptionProvider exceptionProvider;

        public FailingMap(ExceptionProvider exceptionProvider) {
            this.exceptionProvider = exceptionProvider;
        }

        @Override
        public void clear() {
            throw this.exceptionProvider.get();
        }

        @Override
        public boolean containsKey(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public boolean containsValue(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw this.exceptionProvider.get();
        }

        @Override
        public V get(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public boolean isEmpty() {
            throw this.exceptionProvider.get();
        }

        @Override
        public Set<K> keySet() {
            throw this.exceptionProvider.get();
        }

        @Override
        public V put(K arg0, V arg1) {
            throw this.exceptionProvider.get();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public V remove(Object arg0) {
            throw this.exceptionProvider.get();
        }

        @Override
        public int size() {
            throw this.exceptionProvider.get();
        }

        @Override
        public Collection<V> values() {
            throw this.exceptionProvider.get();
        }
    }

    protected static interface ExceptionProvider {
        public RuntimeException get();
    }
}

