/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.scripting.bundle;

import java.util.Collections;
import java.util.Map;

class BundleScriptingContext {
    private final ClassLoader classLoader;
    private final Map<String, Integer> extensionPriorities;

    BundleScriptingContext(ClassLoader classLoader, Map<String, Integer> extensionsPrioritiesMap) {
        this.classLoader = classLoader;
        this.extensionPriorities = extensionsPrioritiesMap;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    int getPriority(String extension, int defaultPriority) {
        if (this.extensionPriorities != null) {
            Integer priority = this.extensionPriorities.get(extension);
            return priority == null ? defaultPriority : Math.abs(priority);
        }
        return defaultPriority;
    }

    boolean specifiesExtensionPriorities() {
        return this.extensionPriorities != null && !this.extensionPriorities.isEmpty();
    }

    Map<String, Integer> getExtensionPriorities() {
        return this.extensionPriorities != null ? this.extensionPriorities : Collections.emptyMap();
    }
}

