/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.Date;
import org.apache.commons.id.IdentifierGenerator;
import org.apache.commons.id.IdentifierGeneratorFactory;
import org.jahia.bin.filters.jcr.JcrSessionFilter;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.LanguageCodeConverters;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundJob
implements StatefulJob {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundJob.class);
    public static IdentifierGenerator idGen = IdentifierGeneratorFactory.newInstance().uuidVersionFourGenerator();
    public static final String JOB_CREATED = "created";
    public static final String JOB_BEGIN = "begin";
    public static final String JOB_END = "end";
    public static final String JOB_STATUS = "status";
    public static final String JOB_DURATION = "duration";
    public static final String JOB_CURRENT_LOCALE = "currentLocale";
    public static final String JOB_SITEKEY = "sitekey";
    public static final String JOB_USERKEY = "userkey";
    public static final String JOB_MESSAGE = "message";
    public static final String STATUS_ADDED = "added";
    public static final String STATUS_SCHEDULED = "scheduled";
    public static final String STATUS_EXECUTING = "executing";
    public static final String STATUS_SUCCESSFUL = "successful";
    public static final String STATUS_FAILED = "failed";
    public static final String STATUS_CANCELED = "canceled";

    public static JobDetail createJahiaJob(String desc, Class<? extends BackgroundJob> jobClass) {
        JobDetail jobDetail = new JobDetail(BackgroundJob.getGroupName(jobClass) + "-" + idGen.nextIdentifier(), BackgroundJob.getGroupName(jobClass), jobClass, false, true, false);
        jobDetail.setDescription(desc);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)JOB_CREATED, (Object)new Date());
        jobDataMap.put(JOB_STATUS, STATUS_ADDED);
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        JahiaUser currentUser = sessionFactory.getCurrentUser();
        if (currentUser != null) {
            jobDataMap.put(JOB_USERKEY, sessionFactory.getCurrentUser().getUserKey());
        }
        jobDataMap.put(JOB_CURRENT_LOCALE, sessionFactory.getCurrentLocale() != null ? sessionFactory.getCurrentLocale().toString() : null);
        jobDetail.setJobDataMap(jobDataMap);
        return jobDetail;
    }

    public static String getGroupName(Class<? extends BackgroundJob> c) {
        String name = c.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        JobDetail jobDetail = ctx.getJobDetail();
        JobDataMap data = jobDetail.getJobDataMap();
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        try {
            String userKey = data.getString(JOB_USERKEY);
            if (userKey != null && !userKey.equals(" system ")) {
                JCRUserNode userNode = JahiaUserManagerService.getInstance().lookup(userKey);
                if (userNode == null) {
                    logger.warn("Unable to lookup job user for key {}", (Object)userKey);
                    throw new JobExecutionException("Unable to lookup job user for key " + userKey);
                }
                sessionFactory.setCurrentUser(userNode.getJahiaUser());
                logger.debug("Executing job as user {}", (Object)userKey);
            } else {
                logger.debug("Executing job as system user");
            }
            String langKey = data.getString(JOB_CURRENT_LOCALE);
            if (langKey != null) {
                sessionFactory.setCurrentLocale(LanguageCodeConverters.languageCodeToLocale(langKey));
                logger.debug("Executing job with locale {}", (Object)langKey);
            }
            this.executeJahiaJob(ctx);
            return;
        }
        catch (Exception e) {
            logger.error("Error executing job " + jobDetail.getKey(), (Throwable)e);
            data.put(JOB_STATUS, STATUS_FAILED);
            if (!(e instanceof JobExecutionException)) throw new JobExecutionException((Throwable)e);
            throw (JobExecutionException)e;
        }
        finally {
            try {
                this.postExecution(ctx);
            }
            finally {
                JcrSessionFilter.endRequest();
            }
        }
    }

    public abstract void executeJahiaJob(JobExecutionContext var1) throws Exception;

    protected void postExecution(JobExecutionContext jobExecutionContext) {
    }
}

