/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.scheduler.BackgroundJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHistoryPurgeJob
extends BackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(JobHistoryPurgeJob.class);

    @Override
    public void executeJahiaJob(JobExecutionContext ctx) throws Exception {
        JobDataMap jobDataMap = ctx.getJobDetail().getJobDataMap();
        Map purgeStrategyData = (Map)jobDataMap.get((Object)"purgeStrategy");
        if (purgeStrategyData.isEmpty()) {
            logger.info("No purge strategy configured. Skip execution of this task.");
            return;
        }
        logger.info("Loaded the following purge strategy {}", (Object)purgeStrategyData);
        LinkedHashMap<Pattern, Long> purgeStrategy = new LinkedHashMap<Pattern, Long>(purgeStrategyData.size());
        for (Map.Entry entry : purgeStrategyData.entrySet()) {
            purgeStrategy.put(Pattern.compile((String)entry.getKey()), (Long)entry.getValue());
        }
        boolean purgeWithNoEndDate = !jobDataMap.containsKey((Object)"purgeWithNoEndDate") || jobDataMap.getBooleanValueFromString("purgeWithNoEndDate");
        ServicesRegistry.getInstance().getSchedulerService().deleteAllCompletedJobs(purgeStrategy, purgeWithNoEndDate);
    }

    protected Long getAge(String jobName, String jobGroup, Map<Pattern, Long> purgeStrategy) {
        Long expiration = null;
        String key = jobGroup + "." + jobName;
        for (Map.Entry<Pattern, Long> purgeEntry : purgeStrategy.entrySet()) {
            if (!purgeEntry.getKey().matcher(key).matches()) continue;
            expiration = purgeEntry.getValue();
            break;
        }
        return expiration;
    }
}

