/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.osgi.BundleUtils;
import org.quartz.jobs.NoOpJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;

public class ModulesResourceLoaderClassLoadHelper
extends ResourceLoaderClassLoadHelper {
    private static final Logger logger = LoggerFactory.getLogger(ModulesResourceLoaderClassLoadHelper.class);
    private Map<String, Boolean> coreClassesChecks = new ConcurrentHashMap<String, Boolean>();

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Boolean result = this.coreClassesChecks.get(className);
        if (result == null) {
            try {
                Class clazz = super.loadClass(className);
                this.coreClassesChecks.put(className, Boolean.TRUE);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                this.coreClassesChecks.put(className, Boolean.FALSE);
            }
        } else if (result.booleanValue()) {
            return super.loadClass(className);
        }
        Class<Object> loadModuleClass = null;
        try {
            loadModuleClass = BundleUtils.loadModuleClass(className, 32);
        }
        catch (ClassNotFoundException e) {
            logger.info("Unable to lookup class " + className + " for the job scheduler.");
            loadModuleClass = NoOpJob.class;
        }
        return loadModuleClass;
    }
}

