/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.jcr;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math.util.MathUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.FileHit;
import org.jahia.services.search.Hit;
import org.jahia.services.search.JCRNodeHit;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchProvider;
import org.jahia.services.search.SearchResponse;
import org.jahia.services.search.SearchServiceImpl;
import org.jahia.services.search.Suggestion;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.tags.TaggingService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.DateUtils;
import org.jahia.utils.Patterns;
import org.jahia.utils.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaJCRSearchProvider
implements SearchProvider,
SearchProvider.SupportsSuggestion {
    private static final Pattern AND_PATTERN = Pattern.compile(" AND ");
    private static final Pattern MULTIPLE_SPACES_PATTERN = Pattern.compile("\\s{2,}");
    private static final Pattern QUOTED_OR_PLAIN_TERMS_WITH_OPTIONAL_NEGATION_PATTERN = Pattern.compile("-*\"([^\"]*)\"|(\\S+)");
    private static final Pattern NOT_PATTERN = Pattern.compile(" NOT ");
    private static final Pattern OR_PATTERN = Pattern.compile(" OR ");
    private static final String AND = "and";
    private static final String OR = "or";
    private static final Logger logger = LoggerFactory.getLogger(JahiaJCRSearchProvider.class);
    private TaggingService taggingService = null;
    private String name;
    private Set<String> typesToHideFromSearchResults;

    @Override
    public SearchResponse search(SearchCriteria criteria, RenderContext context) {
        if (criteria.getFacetDefinitions() != null) {
            throw new IllegalArgumentException("Search facets are not supported by the JCR search provider");
        }
        SearchResponse response = new SearchResponse();
        ArrayList results = new ArrayList();
        response.setResults(results);
        try {
            JCRSessionWrapper session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession(context.getMainResource().getWorkspace(), context.getMainResource().getLocale(), context.getFallbackLocale());
            Query query = this.buildQuery(criteria, session);
            int offset = criteria.getOffset() < 0L ? 0 : (int)criteria.getOffset();
            int limit = criteria.getLimit() <= 0L ? Integer.MAX_VALUE : (int)criteria.getLimit();
            response.setOffset(offset);
            response.setLimit(limit);
            int count = 0;
            if (query != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing search query [{}]", (Object)query.getStatement());
                }
                QueryResult queryResult = query.execute();
                RowIterator it = queryResult.getRows();
                HashSet<String> languages = new HashSet<String>();
                if (it.hasNext()) {
                    if (!criteria.getLanguages().isEmpty()) {
                        for (String languageCode : criteria.getLanguages().getValues()) {
                            if (StringUtils.isEmpty((String)languageCode)) continue;
                            languages.add(languageCode);
                        }
                    } else if (session.getLocale() != null) {
                        languages.add(session.getLocale().toString());
                    }
                }
                HashSet usageFilterSites = !criteria.getSites().isEmpty() && !criteria.getSites().getValue().equals("-all-") && !criteria.getSitesForReferences().isEmpty() ? Sets.newHashSet((Object[])criteria.getSites().getValues()) : null;
                HashSet<String> addedNodes = new HashSet<String>();
                HashMap<String, JCRNodeHit> addedHits = new HashMap<String, JCRNodeHit>();
                ArrayList<JCRNodeHit> hitsToAdd = new ArrayList<JCRNodeHit>();
                int requiredHits = limit + offset;
                boolean displayableNodeCompat = Boolean.valueOf(SettingsBean.getInstance().getPropertiesFile().getProperty("search.displayableNodeCompat"));
                while (it.hasNext()) {
                    ++count;
                    Row row = it.nextRow();
                    try {
                        JCRNodeHit hit;
                        JCRNodeWrapper node = (JCRNodeWrapper)row.getNode();
                        if (node != null && (node.isNodeType("jnt:translation") || "jcr:content".equals(node.getName()))) {
                            node = node.getParent();
                        }
                        if (node != null && node.isNodeType("jnt:vanityUrl")) {
                            node = node.getParent().getParent();
                        }
                        if (node == null || !addedNodes.add(node.getIdentifier())) continue;
                        boolean skipNode = this.isNodeToSkip(node, criteria, languages);
                        JCRNodeHit jCRNodeHit = hit = !skipNode ? this.buildHit(row, node, context, usageFilterSites) : null;
                        if (!skipNode && !displayableNodeCompat) {
                            boolean bl = skipNode = hit.getDisplayableNode() == null;
                        }
                        if (!skipNode && usageFilterSites != null && !usageFilterSites.contains(node.getResolveSite().getName())) {
                            skipNode = hit.getUsages().isEmpty();
                        }
                        if (skipNode) continue;
                        hitsToAdd.add(hit);
                        if (hitsToAdd.size() + addedHits.size() < requiredHits) continue;
                        SearchServiceImpl.executeURLModificationRules(hitsToAdd, context);
                        this.addHitsToResults(hitsToAdd, results, addedHits, offset);
                        hitsToAdd.clear();
                        if (addedHits.size() < requiredHits) continue;
                        response.setHasMore(true);
                        if (it.getSize() > 0L) {
                            int approxCount = (int)it.getSize() * addedHits.size() / count;
                            approxCount = (int)Math.ceil(MathUtils.round((float)approxCount, (int)(approxCount < 1000 ? -1 : (approxCount < 10000 ? -2 : -3)), (int)0));
                            response.setApproxCount(approxCount);
                        }
                        return response;
                    }
                    catch (ItemNotFoundException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Found node is not visible or published: " + row.getPath(), (Throwable)e);
                    }
                    catch (PathNotFoundException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Found node is not visible or published: " + row.getPath(), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.warn("Error resolving search hit", (Throwable)e);
                    }
                }
                if (hitsToAdd.size() > 0) {
                    SearchServiceImpl.executeURLModificationRules(hitsToAdd, context);
                    this.addHitsToResults(hitsToAdd, results, addedHits, offset);
                }
            }
        }
        catch (RepositoryException e) {
            if (e.getMessage() != null && e.getMessage().contains(ParseException.class.getName())) {
                logger.warn(e.getMessage());
                logger.debug(e.getMessage(), (Throwable)e);
            } else {
                logger.error("Error while trying to perform a search", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to perform a search", (Throwable)e);
        }
        logger.debug("Search query has {} results", (Object)results.size());
        return response;
    }

    private void addHitsToResults(List<JCRNodeHit> collectedHits, List<Hit<?>> results, Map<String, JCRNodeHit> addedHits, int offset) {
        for (JCRNodeHit hit : collectedHits) {
            if (!addedHits.containsKey(hit.getLink())) {
                addedHits.put(hit.getLink(), hit);
                if (addedHits.size() < offset) continue;
                results.add(hit);
                continue;
            }
            JCRNodeHit previousHit = addedHits.get(hit.getLink());
            for (Row row : hit.getRows()) {
                previousHit.addRow(row);
            }
        }
    }

    private boolean isNodeToSkip(JCRNodeWrapper node, SearchCriteria criteria, Set<String> languages) {
        boolean skipNode;
        block6: {
            skipNode = false;
            try {
                ArrayList<String> nodeTypes = new ArrayList<String>(node.getNodeTypes());
                boolean toHide = nodeTypes.removeAll(this.typesToHideFromSearchResults);
                if (toHide) {
                    return true;
                }
                if (languages.isEmpty() || !this.isSiteSearch(criteria) || !node.isFile() && !node.isNodeType("nt:folder")) break block6;
                boolean isFileSearch = this.isFileSearch(criteria);
                boolean bl = skipNode = !isFileSearch ? true : skipNode;
                if (criteria.isExcludeFileReferences()) break block6;
                PropertyIterator it = node.getWeakReferences();
                while (it.hasNext()) {
                    skipNode = isFileSearch ? true : skipNode;
                    try {
                        JCRNodeWrapper refNode = (JCRNodeWrapper)it.nextProperty().getParent();
                        if (!languages.contains(refNode.getLanguage())) continue;
                        skipNode = false;
                        break;
                    }
                    catch (Exception e) {
                        logger.debug("Error while trying to check for node language", (Throwable)e);
                    }
                }
            }
            catch (RepositoryException e) {
                logger.debug("Error while trying to check for node language", (Throwable)e);
            }
        }
        return skipNode;
    }

    private JCRNodeHit buildHit(Row row, JCRNodeWrapper node, RenderContext context, Set<String> usageFilterSites) throws RepositoryException {
        JCRNodeHit searchHit = null;
        searchHit = node.isFile() || node.isNodeType("nt:folder") ? new FileHit(node, context) : new JCRNodeHit(node, context);
        try {
            searchHit.setUsageFilterSites(usageFilterSites);
            searchHit.setScore((float)(row.getScore() / 1000.0));
            searchHit.addRow(row);
        }
        catch (Exception e) {
            logger.warn("Search details cannot be retrieved", (Throwable)e);
        }
        return searchHit;
    }

    private String buildSQLQuery(SearchCriteria params, JCRSessionWrapper session) {
        StringBuilder query = new StringBuilder("select * from ");
        query.append("[");
        query.append(this.getNodeType(params));
        query.append("] as n ");
        String path = null;
        boolean includeChildren = false;
        if (!params.getFilePath().isEmpty()) {
            path = params.getFilePath().getValue().trim();
            includeChildren = params.getFilePath().isIncludeChildren();
        } else if (!params.getPagePath().isEmpty()) {
            path = params.getPagePath().getValue().trim();
            includeChildren = params.getPagePath().isIncludeChildren();
        }
        if (path != null) {
            query.append("where (");
            if (includeChildren) {
                query.append("isdescendantnode(n,'");
            } else {
                query.append("ischildnode(n,'");
            }
            query.append(JCRContentUtils.sqlEncode(path)).append("')");
            query.append(")");
        } else if (!params.getSites().isEmpty()) {
            query.append("where (");
            if ("-all-".equals(params.getSites().getValue())) {
                query.append("isdescendantnode(n,'/sites/')");
            } else {
                LinkedHashSet<Object> sites = new LinkedHashSet<Object>();
                for (String string : params.getSites().getValues()) {
                    sites.add(string);
                }
                if (!params.getSitesForReferences().isEmpty()) {
                    for (String string : params.getSitesForReferences().getValues()) {
                        sites.add(string);
                    }
                }
                for (String string : sites) {
                    query.append("isdescendantnode(n,'/sites/").append(JCRContentUtils.sqlEncode(string)).append("') or ");
                }
                query.delete(query.length() - 4, query.length());
            }
            query.append(")");
        }
        query = this.appendConstraints(params, query, false);
        query = this.appendOrdering(params, query, false);
        return query.toString();
    }

    private String buildXpathQuery(SearchCriteria params, JCRSessionWrapper session) {
        String xpathQuery = null;
        StringBuilder query = new StringBuilder(256);
        String path = null;
        boolean includeChildren = false;
        if (!params.getFilePath().isEmpty()) {
            path = params.getFilePath().getValue().trim();
            includeChildren = params.getFilePath().isIncludeChildren();
        } else if (!params.getPagePath().isEmpty()) {
            path = params.getPagePath().getValue().trim();
            includeChildren = params.getPagePath().isIncludeChildren();
        }
        if (path != null) {
            String[] pathTokens = Patterns.SLASH.split(StringEscapeUtils.unescapeHtml((String)path));
            String lastFolder = null;
            StringBuilder jcrPath = new StringBuilder(64);
            jcrPath.append("/jcr:root/");
            for (String folder : pathTokens) {
                if (folder.length() == 0) continue;
                folder = ISO9075.encode((String)folder);
                if (!includeChildren) {
                    if (lastFolder != null) {
                        jcrPath.append(lastFolder).append("/");
                    }
                    lastFolder = folder;
                    continue;
                }
                jcrPath.append(folder).append("/");
            }
            if (includeChildren) {
                jcrPath.append("/");
                lastFolder = "*";
            }
            query.append((CharSequence)jcrPath).append("element(").append(lastFolder).append(",").append(this.getNodeType(params)).append(")");
        } else if (!params.getSites().isEmpty()) {
            query.append("/jcr:root/sites/");
            if ("-all-".equals(params.getSites().getValue())) {
                query.append("*");
            } else {
                LinkedHashSet<String> sites = new LinkedHashSet<String>();
                for (String site : params.getSites().getValues()) {
                    sites.add(site);
                }
                if (!params.getSitesForReferences().isEmpty()) {
                    for (String site : params.getSitesForReferences().getValues()) {
                        sites.add(site);
                    }
                }
                if (sites.size() == 1) {
                    query.append(ISO9075.encode((String)((String)sites.iterator().next())));
                } else {
                    query.append("*[");
                    int i = 0;
                    for (String site : sites) {
                        if (i > 0) {
                            query.append(" or ");
                        }
                        query.append("fn:name() = ");
                        query.append(JCRContentUtils.stringToQueryLiteral(ISO9075.encode((String)site)));
                        ++i;
                    }
                    query.append("]");
                }
            }
            if (this.isSiteSearch(params)) {
                if (params.isExcludeFileReferences() && !this.isFileSearch(params)) {
                    query.append("/*[@j:isHomePage='true' or fn:name() = 'contents']");
                } else {
                    query.append("/*[@j:isHomePage='true' or fn:name() = 'files' or fn:name() = 'contents']");
                }
            }
            query.append("//element(*,").append(this.getNodeType(params)).append(")");
        } else {
            query.append("//element(*,").append(this.getNodeType(params)).append(")");
        }
        query = this.appendConstraints(params, query, true);
        query = this.appendOrdering(params, query, true);
        xpathQuery = query.toString();
        logger.debug("XPath query built: {}", (Object)xpathQuery);
        return xpathQuery;
    }

    private boolean isFileSearch(SearchCriteria params) {
        return params.isFileSearch();
    }

    private boolean isFieldSearch(SearchCriteria.Term.SearchFields searchFields) {
        return searchFields.isTags() || searchFields.isFileContent() || searchFields.isDescription() || searchFields.isTitle() || searchFields.isKeywords() || searchFields.isFilename();
    }

    private boolean isSiteSearch(SearchCriteria params) {
        return params.isSiteSearch();
    }

    private String getNodeType(SearchCriteria params) {
        if (StringUtils.isNotEmpty((String)params.getNodeType())) {
            return params.getNodeType();
        }
        if (this.isFileSearch(params) && !this.isSiteSearch(params)) {
            return "nt:hierarchyNode";
        }
        return "jmix:searchable";
    }

    private StringBuilder appendConstraints(SearchCriteria params, StringBuilder query, boolean xpath) {
        StringBuilder constraints = new StringBuilder(64);
        this.addTermConstraints(params, constraints, xpath);
        this.addDateAndAuthorConstraints(params, constraints, xpath);
        this.addFileTypeConstraints(params, constraints, xpath);
        this.addLanguageConstraints(params, constraints, xpath);
        List<SearchCriteria.NodeProperty> props = params.getPropertiesAll();
        if (!props.isEmpty()) {
            this.addPropertyConstraints(constraints, props, xpath);
        }
        if (constraints.length() > 0) {
            if (xpath) {
                query.append("[").append((CharSequence)constraints).append("]");
            } else {
                if (query.indexOf("where") > -1) {
                    query.append(" and ");
                } else {
                    query.append(" where ");
                }
                query.append("(").append((CharSequence)constraints).append(")");
            }
        }
        return query;
    }

    private StringBuilder appendOrdering(SearchCriteria params, StringBuilder query, boolean xpath) {
        StringBuilder orderByClause = new StringBuilder();
        if (params.getOrderings().isEmpty()) {
            orderByClause.append(xpath ? " order by jcr:score() descending" : " order by score() desc");
        } else {
            for (SearchCriteria.Ordering ordering : params.getOrderings()) {
                StringBuilder orderingBuilder = new StringBuilder();
                switch (ordering.getOperand()) {
                    case SCORE: {
                        orderingBuilder.append(xpath ? "jcr:score()" : "SCORE()");
                        break;
                    }
                    case PROPERTY: {
                        orderingBuilder.append(xpath ? "@" : "[").append(ordering.getPropertyName()).append(xpath ? "" : "]");
                    }
                }
                if (ordering.getCaseConversion() != null) {
                    orderingBuilder.insert(0, ordering.getCaseConversion() == SearchCriteria.Ordering.CaseConversion.LOWER ? (xpath ? "fn:lower-case(" : "LOWER(") : (xpath ? "fn:upper-case(" : "UPPER("));
                    orderingBuilder.append(")");
                }
                if (ordering.isNormalize() && xpath) {
                    orderingBuilder.insert(0, "rep:normalize(");
                    orderingBuilder.append(")");
                }
                orderingBuilder.append(ordering.getOrder() == SearchCriteria.Ordering.Order.ASCENDING ? (xpath ? " ascending" : " asc") : (xpath ? " descending" : " desc"));
                if (orderByClause.length() > 0) {
                    orderByClause.append(", ");
                }
                orderByClause.append((CharSequence)orderingBuilder);
            }
            orderByClause.insert(0, " order by ");
        }
        query.append((CharSequence)orderByClause);
        return query;
    }

    private StringBuilder addConstraint(StringBuilder constraints, String operand, String constraint) {
        if (constraints.length() > 0) {
            constraints.append(" ").append(operand).append(" ");
        }
        return constraints.append(constraint);
    }

    private void addDateAndAuthorConstraints(SearchCriteria params, StringBuilder constraints, boolean xpath) {
        if (params.getCreatedBy() != null && params.getCreatedBy().length() > 0) {
            this.addConstraint(constraints, AND, this.getContainsExpr(this.getPropertyName("jcr:createdBy", xpath), JCRContentUtils.stringToJCRSearchExp(params.getCreatedBy().trim()), xpath));
        }
        if (params.getLastModifiedBy() != null && params.getLastModifiedBy().length() > 0) {
            this.addConstraint(constraints, AND, this.getContainsExpr(this.getPropertyName("jcr:lastModifiedBy", xpath), JCRContentUtils.stringToJCRSearchExp(params.getLastModifiedBy().trim()), xpath));
        }
        if (!params.getCreated().isEmpty() && SearchCriteria.DateValue.Type.ANYTIME != params.getCreated().getType()) {
            this.addDateConstraint(constraints, params.getCreated(), "jcr:created", xpath);
        }
        if (!params.getLastModified().isEmpty() && SearchCriteria.DateValue.Type.ANYTIME != params.getLastModified().getType()) {
            this.addDateConstraint(constraints, params.getLastModified(), "jcr:lastModified", xpath);
        }
    }

    private void addDateConstraint(StringBuilder constraints, SearchCriteria.DateValue dateValue, String paramName, boolean xpath) {
        Calendar greaterThanDate = Calendar.getInstance();
        Calendar smallerThanDate = null;
        if (SearchCriteria.DateValue.Type.TODAY != dateValue.getType()) {
            if (SearchCriteria.DateValue.Type.LAST_WEEK == dateValue.getType()) {
                greaterThanDate.add(5, -7);
            } else if (SearchCriteria.DateValue.Type.LAST_MONTH == dateValue.getType()) {
                greaterThanDate.add(2, -1);
            } else if (SearchCriteria.DateValue.Type.LAST_THREE_MONTHS == dateValue.getType()) {
                greaterThanDate.add(2, -3);
            } else if (SearchCriteria.DateValue.Type.LAST_SIX_MONTHS == dateValue.getType()) {
                greaterThanDate.add(2, -6);
            } else if (SearchCriteria.DateValue.Type.RANGE == dateValue.getType()) {
                greaterThanDate = null;
                smallerThanDate = null;
                if (dateValue.getFromAsDate() != null) {
                    greaterThanDate = Calendar.getInstance();
                    greaterThanDate.setTime(dateValue.getFromAsDate());
                }
                if (dateValue.getToAsDate() != null) {
                    smallerThanDate = Calendar.getInstance();
                    smallerThanDate.setTime(dateValue.getToAsDate());
                }
            } else {
                throw new IllegalArgumentException("Unknown date value type '" + (Object)((Object)dateValue.getType()) + "'");
            }
        }
        try {
            if (greaterThanDate != null) {
                this.addConstraint(constraints, AND, this.getPropertyName(paramName, xpath) + " >= " + this.getDateLiteral(DateUtils.dayStart(greaterThanDate), xpath));
            }
            if (smallerThanDate != null) {
                this.addConstraint(constraints, AND, this.getPropertyName(paramName, xpath) + " <= " + this.getDateLiteral(DateUtils.dayEnd(smallerThanDate), xpath));
            }
        }
        catch (IllegalStateException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void addFileTypeConstraints(SearchCriteria params, StringBuilder constraints, boolean xpath) {
        if (StringUtils.isNotEmpty((String)params.getFileType())) {
            List<String> mimeTypes = JCRContentUtils.getInstance().getMimeTypes().get(params.getFileType());
            if (mimeTypes != null && !mimeTypes.isEmpty()) {
                if (mimeTypes.size() > 1) {
                    StringBuilder fileTypeConstraints = new StringBuilder(128);
                    for (String mimeType : mimeTypes) {
                        this.addConstraint(fileTypeConstraints, OR, this.getMimeTypeConstraint(mimeType, xpath));
                    }
                    this.addConstraint(constraints, AND, fileTypeConstraints.insert(0, "(").append(")").toString());
                } else {
                    this.addConstraint(constraints, AND, this.getMimeTypeConstraint(mimeTypes.get(0), xpath));
                }
            } else {
                logger.warn("Unsupported file type '" + params.getFileType() + "'. See applicationcontext-basejahiaconfig.xml file for configured file types.");
            }
        }
    }

    private void addPropertyConstraintCategory(StringBuilder categoryConstraints, String name, String value, boolean includeChildren, boolean xpath) {
        try {
            Category cat = Category.getCategoryByPath(value, JCRSessionFactory.getInstance().getCurrentUser());
            if (cat == null) {
                logger.warn("User " + JCRSessionFactory.getInstance().getCurrentUser().getUsername() + " has no right to read the category");
                return;
            }
            this.addConstraint(categoryConstraints, OR, this.getPropertyName(name, xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(cat.getID()));
            if (includeChildren) {
                this.addSubCategoriesConstraints(categoryConstraints, cat, name, xpath);
            }
        }
        catch (JahiaException e) {
            logger.warn("Category: " + value + " could not be retrieved", (Throwable)e);
        }
    }

    private void addSubCategoriesConstraints(StringBuilder categoryConstraints, Category category, String name, boolean xpath) throws JahiaException {
        List<Category> childs = category.getChildCategories();
        if (childs != null && childs.size() > 0) {
            for (Category cat : childs) {
                this.addConstraint(categoryConstraints, OR, this.getPropertyName(name, xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(cat.getID()));
                this.addSubCategoriesConstraints(categoryConstraints, cat, name, xpath);
            }
        }
    }

    private void addPropertyConstraints(StringBuilder constraints, List<SearchCriteria.NodeProperty> properties, boolean xpath) {
        for (SearchCriteria.NodeProperty property : properties) {
            if (property.isEmpty()) continue;
            if (SearchCriteria.NodeProperty.Type.CATEGORY == property.getType()) {
                StringBuilder categoryConstraints = new StringBuilder(64);
                for (String value : property.getCategoryValue().getValues()) {
                    this.addPropertyConstraintCategory(categoryConstraints, property.getName(), value, property.getCategoryValue().isIncludeChildren(), xpath);
                }
                if (categoryConstraints.length() <= 0) continue;
                this.addConstraint(constraints, AND, categoryConstraints.insert(0, "(").append(")").toString());
                continue;
            }
            if (SearchCriteria.NodeProperty.Type.DATE == property.getType()) {
                this.addDateConstraint(constraints, property.getDateValue(), property.getName(), xpath);
                continue;
            }
            if (SearchCriteria.NodeProperty.Type.TEXT == property.getType()) {
                StringBuilder propertyConstraints = new StringBuilder(64);
                for (String value : property.getValues()) {
                    if (property.isConstrained()) {
                        String matchType = "=";
                        if (property.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS || property.getMatch() == SearchCriteria.Term.MatchType.NO_EXACT_PROPERTY_VALUE) {
                            matchType = xpath ? "!=" : "<>";
                        }
                        this.addConstraint(propertyConstraints, OR, this.getPropertyName(property.getName(), xpath) + matchType + JCRContentUtils.stringToJCRSearchExp(value));
                        continue;
                    }
                    this.addConstraint(propertyConstraints, OR, this.getSearchExpression(this.getPropertyName(property.getName(), xpath), value, property.getMatch(), false, xpath));
                }
                if (propertyConstraints.length() <= 0) continue;
                if (property.getValues().length == 1) {
                    this.addConstraint(constraints, AND, propertyConstraints.toString());
                    continue;
                }
                this.addConstraint(constraints, AND, "(" + propertyConstraints.toString() + ")");
                continue;
            }
            if (SearchCriteria.NodeProperty.Type.BOOLEAN == property.getType()) {
                if (!Boolean.parseBoolean(property.getValue())) continue;
                this.addConstraint(constraints, AND, this.getPropertyName(property.getName(), xpath) + "='true'");
                continue;
            }
            throw new IllegalArgumentException("Unknown document property type '" + (Object)((Object)property.getType()) + "'");
        }
    }

    private void addTermConstraints(SearchCriteria params, StringBuilder constraints, boolean xpath) {
        for (SearchCriteria.Term textSearch : params.getTerms()) {
            if (textSearch.isEmpty()) continue;
            StringBuilder textSearchConstraints = new StringBuilder(256);
            if (textSearch.getFields().isSiteContent() || !this.isFieldSearch(textSearch.getFields())) {
                this.addConstraint(textSearchConstraints, OR, this.getSearchExpression(xpath ? "." : "n", textSearch.getTerm(), textSearch.getMatch(), textSearch.isApplyFilter(), xpath));
            }
            if (textSearch.getFields().isFileContent()) {
                this.addConstraint(textSearchConstraints, OR, this.getSearchExpression(xpath ? "jcr:content" : this.getPropertyName("jcr:content", false), textSearch.getTerm(), textSearch.getMatch(), textSearch.isApplyFilter(), xpath));
            }
            if (textSearchConstraints.length() == 0 || !this.isWithoutTermContraintInFulltextQuery(textSearch)) {
                this.addTermConstraintsOnFields(params, textSearch, textSearch.getFields(), textSearchConstraints, xpath);
            }
            if (textSearchConstraints.length() <= 0) continue;
            this.addConstraint(constraints, AND, "(" + textSearchConstraints.toString() + ")");
        }
    }

    private void addTermConstraintsOnFields(SearchCriteria params, SearchCriteria.Term textSearch, SearchCriteria.Term.SearchFields searchFields, StringBuilder textSearchConstraints, boolean xpath) {
        String[] nameSearchConstraints;
        if (searchFields.isDescription()) {
            this.addConstraint(textSearchConstraints, OR, this.getSearchExpression(this.getPropertyName("jcr:description", xpath), textSearch.getTerm(), textSearch.getMatch(), textSearch.isApplyFilter(), xpath));
        }
        if (searchFields.isTitle()) {
            this.addConstraint(textSearchConstraints, OR, this.getSearchExpression(this.getPropertyName("jcr:title", xpath), textSearch.getTerm(), textSearch.getMatch(), textSearch.isApplyFilter(), xpath));
        }
        if (searchFields.isKeywords()) {
            this.addConstraint(textSearchConstraints, OR, this.getSearchExpression(this.getPropertyName("j:keywords", xpath), textSearch.getTerm(), textSearch.getMatch(), textSearch.isApplyFilter(), xpath));
        }
        String[] terms = null;
        String constraint = OR;
        if (searchFields.isFilename() || searchFields.isTags()) {
            if (textSearch.getMatch() == SearchCriteria.Term.MatchType.ANY_WORD || textSearch.getMatch() == SearchCriteria.Term.MatchType.ALL_WORDS || textSearch.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS) {
                terms = Patterns.SPACE.split(this.cleanMultipleWhiteSpaces(textSearch.getTerm()));
                if (textSearch.getMatch() == SearchCriteria.Term.MatchType.ALL_WORDS || textSearch.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS) {
                    constraint = AND;
                }
            } else {
                terms = new String[]{textSearch.getTerm()};
            }
        }
        if (searchFields.isFilename() && !(nameSearchConstraints = this.createFilenameConstraints(textSearch, terms, constraint, xpath)).isEmpty()) {
            this.addConstraint(textSearchConstraints, OR, "(" + (String)nameSearchConstraints + ")");
        }
        if (searchFields.isTags() && this.getTaggingService() != null && (params.getSites().getValue() != null || params.getOriginSiteKey() != null) && !StringUtils.containsAny((String)textSearch.getTerm(), (String)"?*")) {
            String tag;
            for (String term : terms) {
                String tag2 = this.taggingService.getTagHandler().execute(term);
                if (StringUtils.isEmpty((String)tag2)) continue;
                this.addConstraint(textSearchConstraints, OR, this.getPropertyName("j:tagList", xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(tag2));
            }
            if (terms.length > 1 && !StringUtils.isEmpty((String)(tag = this.taggingService.getTagHandler().execute(textSearch.getTerm())))) {
                this.addConstraint(textSearchConstraints, OR, this.getPropertyName("j:tagList", xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(tag));
            }
        }
    }

    private boolean isWithoutTermContraintInFulltextQuery(SearchCriteria.Term textSearch) {
        boolean withoutTermContraint;
        boolean bl = withoutTermContraint = textSearch.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS;
        if (textSearch.getMatch() == SearchCriteria.Term.MatchType.AS_IS) {
            Matcher matcher = QUOTED_OR_PLAIN_TERMS_WITH_OPTIONAL_NEGATION_PATTERN.matcher(textSearch.getTerm());
            while (!withoutTermContraint && matcher.find()) {
                if (!(matcher.group(1) != null ? matcher.group().startsWith("-") : matcher.group(2).startsWith("-"))) continue;
                withoutTermContraint = true;
            }
        }
        return withoutTermContraint;
    }

    private String createFilenameConstraints(SearchCriteria.Term textSearch, String[] terms, String constraint, boolean xpath) {
        StringBuilder nameSearchConstraints = new StringBuilder(256);
        if (textSearch.getMatch() == SearchCriteria.Term.MatchType.AS_IS) {
            Matcher matcher = QUOTED_OR_PLAIN_TERMS_WITH_OPTIONAL_NEGATION_PATTERN.matcher(textSearch.getTerm());
            String previousOperand = null;
            while (matcher.find()) {
                String asIsTerm;
                boolean negation = false;
                if (matcher.group(1) != null) {
                    asIsTerm = matcher.group(1);
                    if (matcher.group().startsWith("-")) {
                        negation = true;
                    }
                } else {
                    asIsTerm = matcher.group(2);
                    if (asIsTerm.startsWith("-")) {
                        asIsTerm = StringUtils.substring((String)asIsTerm, (int)1);
                        negation = true;
                    }
                }
                if ((OR.equalsIgnoreCase(asIsTerm) || AND.equalsIgnoreCase(asIsTerm)) && previousOperand == null && nameSearchConstraints.length() != 0) {
                    previousOperand = asIsTerm.toLowerCase();
                    continue;
                }
                if (!asIsTerm.isEmpty()) {
                    String termConstraint = this.createNodenameLikeTermConstraint(asIsTerm, xpath);
                    if (negation) {
                        termConstraint = "not(" + termConstraint + ")";
                    }
                    if (previousOperand != null) {
                        this.addConstraint(nameSearchConstraints, previousOperand, termConstraint);
                        previousOperand = null;
                        continue;
                    }
                    this.addConstraint(nameSearchConstraints, AND, termConstraint);
                    continue;
                }
                previousOperand = null;
            }
            if (previousOperand != null) {
                this.addConstraint(nameSearchConstraints, AND, previousOperand);
            }
        } else {
            for (String term : terms) {
                if (term.isEmpty()) continue;
                String termConstraint = this.createNodenameLikeTermConstraint(term, xpath);
                if (textSearch.getMatch() == SearchCriteria.Term.MatchType.WITHOUT_WORDS) {
                    termConstraint = "not(" + termConstraint + ")";
                }
                this.addConstraint(nameSearchConstraints, constraint, termConstraint);
            }
        }
        return nameSearchConstraints.toString();
    }

    private String createNodenameLikeTermConstraint(String term, boolean xpath) {
        String likeTerm = term.contains("*") ? JCRContentUtils.stringToQueryLiteral(StringUtils.replaceChars((String)term, (char)'*', (char)'%')) : JCRContentUtils.stringToQueryLiteral("%" + term + "%");
        String lowerCaseTerm = likeTerm.toLowerCase();
        return xpath ? "jcr:like(fn:lower-case(fn:name()), " + lowerCaseTerm + ")" : "LOWER(n.[j:nodename]) like " + lowerCaseTerm;
    }

    /*
     * Unable to fully structure code
     */
    private void addLanguageConstraints(SearchCriteria params, StringBuilder constraints, boolean xpath) {
        languageSearchConstraints = new StringBuilder(256);
        if (!params.getLanguages().isEmpty()) {
            for (String languageCode : params.getLanguages().getValues()) {
                if (languageCode == null || languageCode.length() == 0) continue;
                this.addConstraint(languageSearchConstraints, "or", this.getPropertyName("jcr:language", xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(languageCode.trim()));
            }
        } else {
            try {
                jcrService = ServicesRegistry.getInstance().getJCRStoreService();
                session = jcrService.getSessionFactory().getCurrentUserSession();
                if (session.getLocale() == null) ** GOTO lbl18
                this.addConstraint(languageSearchConstraints, "or", this.getPropertyName("jcr:language", xpath) + "=" + JCRContentUtils.stringToJCRSearchExp(session.getLocale().toString()));
            }
            catch (RepositoryException var5_7) {
                // empty catch block
            }
        }
lbl18:
        // 4 sources

        if (languageSearchConstraints.length() > 0) {
            this.addConstraint(languageSearchConstraints, "or", xpath != false ? "not(@jcr:language)" : "[jcr:language] is null");
            this.addConstraint(constraints, "and", "(" + languageSearchConstraints.toString() + ")");
        }
    }

    private String getMimeTypeConstraint(String mimeType, boolean xpath) {
        if (xpath) {
            return mimeType.contains("*") ? "jcr:like(jcr:content/@jcr:mimeType," + JCRContentUtils.stringToQueryLiteral(StringUtils.replaceChars((String)mimeType, (char)'*', (char)'%')) + ")" : "jcr:content/@jcr:mimeType=" + JCRContentUtils.stringToQueryLiteral(mimeType);
        }
        return "n.[jcr:mimetype]=" + JCRContentUtils.stringToQueryLiteral(mimeType);
    }

    private String getDateLiteral(Calendar date, boolean xpath) {
        return xpath ? "xs:dateTime('" + ISO8601.format((Calendar)date) + "')" : "'" + ISO8601.format((Calendar)date) + "'";
    }

    private String getPropertyName(String paramName, boolean xpath) {
        return xpath ? "@" + paramName : "n.[" + paramName + "]";
    }

    private String getContainsExpr(String scope, String expr, boolean xpath) {
        if (xpath) {
            return "jcr:contains(" + scope + "," + expr + ")";
        }
        return "contains(" + scope + "," + expr + ")";
    }

    private String getSearchExpression(String scope, String term, SearchCriteria.Term.MatchType matchType, boolean applyFilter, boolean xpath) {
        if (applyFilter && StringUtils.containsAny((String)term, (String)"?*")) {
            term = TextUtils.removeAccents(term);
        }
        if (SearchCriteria.Term.MatchType.AS_IS != matchType && SearchCriteria.Term.MatchType.EXACT_PROPERTY_VALUE != matchType && SearchCriteria.Term.MatchType.NO_EXACT_PROPERTY_VALUE != matchType) {
            term = QueryParser.escape((String)NOT_PATTERN.matcher(OR_PATTERN.matcher(AND_PATTERN.matcher(term).replaceAll(" and ")).replaceAll(" or ")).replaceAll(" not "));
        }
        if (SearchCriteria.Term.MatchType.ALL_WORDS == matchType || SearchCriteria.Term.MatchType.AS_IS == matchType) {
            return this.getContainsExpr(scope, JCRContentUtils.stringToJCRSearchExp(term), xpath);
        }
        if (SearchCriteria.Term.MatchType.ANY_WORD == matchType) {
            term = StringUtils.replace((String)this.cleanMultipleWhiteSpaces(term), (String)" ", (String)" OR ");
            return this.getContainsExpr(scope, JCRContentUtils.stringToJCRSearchExp(term), xpath);
        }
        if (SearchCriteria.Term.MatchType.EXACT_PHRASE == matchType) {
            term = "\"" + term.trim() + "\"";
            return this.getContainsExpr(scope, JCRContentUtils.stringToJCRSearchExp(term), xpath);
        }
        if (SearchCriteria.Term.MatchType.WITHOUT_WORDS == matchType) {
            term = "* -" + StringUtils.replace((String)this.cleanMultipleWhiteSpaces(term), (String)" ", (String)" -");
            return this.getContainsExpr(scope, JCRContentUtils.stringToJCRSearchExp(term), xpath);
        }
        if (SearchCriteria.Term.MatchType.EXACT_PROPERTY_VALUE == matchType) {
            return scope + "=" + JCRContentUtils.stringToQueryLiteral(term);
        }
        if (SearchCriteria.Term.MatchType.NO_EXACT_PROPERTY_VALUE == matchType) {
            return scope + (xpath ? "!=" : "<>") + JCRContentUtils.stringToQueryLiteral(term);
        }
        throw new IllegalArgumentException("Unsupported match type: " + (Object)((Object)matchType));
    }

    private String cleanMultipleWhiteSpaces(String term) {
        return MULTIPLE_SPACES_PATTERN.matcher(term).replaceAll(" ");
    }

    @Override
    public Suggestion suggest(String originalQuery, RenderContext context, int maxTerms) {
        return this.suggest(originalQuery, new String[]{context.getSite().getSiteKey()}, context, maxTerms);
    }

    @Override
    public Suggestion suggest(SearchCriteria originalQuery, RenderContext context, int maxTermsToSuggest) {
        return this.suggest(originalQuery.getTerms().get(0).getTerm(), originalQuery.getSites().getValues(), context, maxTermsToSuggest);
    }

    public Suggestion suggest(String originalQuery, String[] sites, RenderContext context, int maxTermsToSuggest) {
        if (StringUtils.isBlank((String)originalQuery)) {
            return null;
        }
        if (sites.length == 1 && sites[0].equals("-all-")) {
            List<String> sitesNames = JahiaSitesService.getInstance().getSitesNames();
            sites = sitesNames.toArray(new String[sitesNames.size()]);
        }
        Locale locale = context.getMainResourceLocale();
        Suggestion suggestion = null;
        try {
            JCRSessionWrapper session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession(context.getWorkspace(), locale);
            QueryManagerWrapper qm = session.getWorkspace().getQueryManager();
            StringBuilder xpath = new StringBuilder(64);
            xpath.append("/jcr:root[rep:spellcheck(").append(JCRContentUtils.stringToJCRSearchExp(originalQuery + "#!#" + "maxTerms" + "=" + maxTermsToSuggest + "#!#" + "sites" + "=" + StringUtils.join((Object[])sites, (String)"*"))).append(")");
            if (locale != null) {
                xpath.append(" or @jcr:language='").append(locale).append("'");
            }
            xpath.append("]");
            xpath.append("/(rep:spellcheck())");
            Query query = qm.createQuery(xpath.toString(), "xpath");
            RowIterator rows = query.execute().getRows();
            if (rows.hasNext()) {
                Row r = rows.nextRow();
                Value v = r.getValue("rep:spellcheck()");
                if (v != null) {
                    String[] suggestions = StringUtils.splitByWholeSeparator((String)v.getString(), (String)"#!#");
                    suggestion = new Suggestion(originalQuery, suggestions[0], Arrays.asList(suggestions));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Making spell check suggestion for '" + originalQuery + "' site '" + Arrays.asList(sites) + "' and locale '" + locale + "' using XPath query [" + xpath.toString() + "]. Result suggestion: " + suggestion);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return suggestion;
    }

    public Query buildQuery(SearchCriteria criteria, JCRSessionWrapper session) throws InvalidQueryException, RepositoryException {
        QueryWrapper query = null;
        String xpathQuery = this.buildXpathQuery(criteria, session);
        String sql = this.buildSQLQuery(criteria, session);
        if (!StringUtils.isEmpty((String)xpathQuery)) {
            QueryManagerWrapper qm = session.getWorkspace().getQueryManager();
            query = qm.createDualQuery(xpathQuery, "xpath", sql);
        }
        return query;
    }

    public TaggingService getTaggingService() {
        return this.taggingService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setTypesToHideFromSearchResults(Set<String> typesToHideFromSearchResults) {
        this.typesToHideFromSearchResults = typesToHideFromSearchResults;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

