/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.seo.urlrewrite.ServerNameToSiteMapper;
import org.jahia.services.seo.urlrewrite.UrlRewriteEngine;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.util.UriUtils;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class UrlRewriteService
implements InitializingBean,
DisposableBean,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(UrlRewriteService.class);
    private List<Resource> configurationResources;
    private List<Resource> lastConfigurationResources;
    private List<Resource> seoConfigurationResources;
    private int confReloadCheckIntervalSeconds = 0;
    private long lastChecked;
    private Map<Integer, Long> lastModified = new ConcurrentHashMap<Integer, Long>(1);
    private List<HandlerMapping> renderMapping;
    private boolean seoRulesEnabled;
    private boolean seoRemoveCmsPrefix;
    private ServletContext servletContext;
    private UrlRewriteEngine urlRewriteEngine;
    private VanityUrlService vanityUrlService;
    private URLResolverFactory urlResolverFactory;
    private Set<String> reservedUrlPrefixSet;
    private JahiaSitesService siteService;
    private SettingsBean settingsBean;
    private transient boolean modified;

    public void afterPropertiesSet() throws Exception {
        long timer = System.currentTimeMillis();
        Log.setLevel((String)"SLF4J");
        if (this.hasConfigurationResources() && this.settingsBean.isDevelopmentMode() && (this.confReloadCheckIntervalSeconds < 0 || this.confReloadCheckIntervalSeconds > 5)) {
            this.confReloadCheckIntervalSeconds = 5;
            logger.info("Development mode is activated. Setting URL rewriter configuration check interval to 5 seconds.");
        }
        this.getEngine();
        logger.info("URL rewriting service started in {} ms using configurations [{}]. Configuration check interval set to {} seconds.", new Object[]{System.currentTimeMillis() - timer, this.getMergedConfigurationResources(), this.confReloadCheckIntervalSeconds});
    }

    private boolean hasConfigurationResources() {
        return this.configurationResources != null && !this.configurationResources.isEmpty() || this.seoConfigurationResources != null && !this.seoConfigurationResources.isEmpty() || this.lastConfigurationResources != null && !this.lastConfigurationResources.isEmpty();
    }

    private List<Resource> getMergedConfigurationResources() {
        ArrayList<Resource> merged;
        int seoSize = this.seoConfigurationResources != null ? this.seoConfigurationResources.size() : 0;
        int lastSize = this.lastConfigurationResources != null ? this.lastConfigurationResources.size() : 0;
        ArrayList<Resource> arrayList = merged = this.configurationResources == null ? new ArrayList<Resource>(seoSize + lastSize) : new ArrayList<Resource>(this.configurationResources);
        if (this.seoRulesEnabled && seoSize > 0) {
            this.addAllWithoutDuplicates(merged, this.seoConfigurationResources);
        }
        if (lastSize > 0) {
            this.addAllWithoutDuplicates(merged, this.lastConfigurationResources);
        }
        return merged;
    }

    private void addAllWithoutDuplicates(List<Resource> merged, List<Resource> resourcesToAdd) {
        for (Resource resource : resourcesToAdd) {
            if (merged.contains(resource)) continue;
            merged.add(resource);
        }
    }

    public void destroy() throws Exception {
        if (this.urlRewriteEngine != null) {
            this.urlRewriteEngine.destroy();
        }
    }

    public UrlRewriteEngine getEngine() {
        try {
            List<Resource> merged = this.getMergedResourcesIfReloadNeeded();
            if (this.urlRewriteEngine == null || merged != null) {
                if (this.urlRewriteEngine != null) {
                    this.urlRewriteEngine.destroy();
                }
                this.urlRewriteEngine = new UrlRewriteEngine(this.servletContext, merged.toArray(new Resource[merged.size()]));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return this.urlRewriteEngine;
    }

    protected List<HandlerMapping> getRenderMapping() {
        if (this.renderMapping == null) {
            LinkedList<HandlerMapping> mapping = new LinkedList<HandlerMapping>();
            ApplicationContext ctx = (ApplicationContext)this.servletContext.getAttribute("org.springframework.web.servlet.FrameworkServlet.CONTEXT.RendererDispatcherServlet");
            if (ctx != null) {
                mapping.addAll(ctx.getBeansOfType(HandlerMapping.class).values());
                mapping.addAll(ctx.getParent().getBeansOfType(HandlerMapping.class).values());
                this.renderMapping = mapping;
            }
        }
        if (this.renderMapping != null) {
            LinkedList<HandlerMapping> l = new LinkedList<HandlerMapping>(this.renderMapping);
            l.addAll(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().getSpringHandlerMappings());
            return l;
        }
        return null;
    }

    public boolean isSeoRulesEnabled() {
        return this.seoRulesEnabled;
    }

    public boolean isResrvedPrefix(String prefix) {
        return this.reservedUrlPrefixSet.contains(prefix);
    }

    private List<Resource> getMergedResourcesIfReloadNeeded() throws IOException {
        if (this.confReloadCheckIntervalSeconds > -1 && this.hasConfigurationResources()) {
            boolean doReload = false;
            List<Resource> result = null;
            if (this.modified || this.confReloadCheckIntervalSeconds == 0 || this.lastChecked == 0L || this.lastChecked + (long)this.confReloadCheckIntervalSeconds * 1000L < System.currentTimeMillis()) {
                logger.debug("Checking for modifications in URL rewriter configuration resources.");
                List<Resource> mergedConfigurationResources = this.getMergedConfigurationResources();
                for (Resource resource : mergedConfigurationResources) {
                    long resourceLastModified = FileUtils.getLastModified(resource);
                    int hash = resource.hashCode();
                    Long previous = this.lastModified.get(hash);
                    doReload = previous == null || resourceLastModified > previous;
                    if (!doReload) continue;
                    this.lastModified.put(hash, resourceLastModified);
                    result = mergedConfigurationResources;
                    break;
                }
                logger.debug(doReload ? "Changes detected" : "No changes detected");
            }
            this.lastChecked = System.currentTimeMillis();
            this.modified = false;
            return result;
        }
        return null;
    }

    public boolean prepareInbound(HttpServletRequest request, HttpServletResponse response) {
        String path;
        block23: {
            this.resetState(request);
            request.setAttribute("contextPath", (Object)request.getContextPath());
            String input = request.getRequestURI();
            if (request.getContextPath().length() > 0) {
                input = StringUtils.substringAfter((String)input, (String)request.getContextPath());
            }
            if (input.contains(";")) {
                input = StringUtils.substringBefore((String)input, (String)";");
            }
            String prefix = "";
            if (this.isSeoRemoveCmsPrefix() && input.length() > 1 && input.indexOf(47) == 0) {
                int end = input.indexOf(47, 1);
                String string = prefix = end != -1 ? input.substring(1, end) : input.substring(1);
            }
            if (prefix.length() > 1) {
                boolean contains = this.reservedUrlPrefixSet.contains(prefix);
                request.setAttribute("jahiaSeoAddCmsPrefix", (Object)(!contains ? 1 : 0));
                if (contains && !"cms".equals(prefix) && !"files".equals(prefix)) {
                    return false;
                }
            } else {
                request.setAttribute("jahiaSeoAddCmsPrefix", (Object)false);
            }
            path = request.getPathInfo() != null ? request.getPathInfo() : input;
            try {
                List<HandlerMapping> mappings = this.getRenderMapping();
                if (mappings == null) break block23;
                for (HandlerMapping mapping : mappings) {
                    if (mapping instanceof SimpleUrlHandlerMapping) {
                        SimpleUrlHandlerMapping simpleUrlHandlerMapping = (SimpleUrlHandlerMapping)mapping;
                        for (String registeredPattern : simpleUrlHandlerMapping.getUrlMap().keySet()) {
                            if (!simpleUrlHandlerMapping.getPathMatcher().match(registeredPattern, path)) continue;
                            request.setAttribute("jahiaSkipInboundSeoRules", (Object)Boolean.TRUE);
                            return false;
                        }
                        continue;
                    }
                    HandlerExecutionChain handlerExecutionChain = mapping.getHandler(request);
                    if (handlerExecutionChain == null) continue;
                    request.setAttribute("jahiaSkipInboundSeoRules", (Object)Boolean.TRUE);
                    return false;
                }
            }
            catch (Exception ex) {
                logger.warn("Unable to load the handler mappings", (Throwable)ex);
            }
        }
        String targetSiteKey = ServerNameToSiteMapper.getSiteKeyByServerName(request);
        request.setAttribute("vanityUrlTargetLang", (Object)"");
        request.setAttribute("vanityUrlTargetPath", (Object)"");
        if (StringUtils.isNotEmpty((String)targetSiteKey) && !path.startsWith("/sites")) {
            try {
                List<VanityUrl> vanityUrls = this.vanityUrlService.findExistingVanityUrls(UriUtils.decode((String)path, (String)"UTF-8"), targetSiteKey, "live");
                if (!vanityUrls.isEmpty()) {
                    VanityUrl vanityUrl = vanityUrls.get(0);
                    request.setAttribute("vanityUrlTargetLang", (Object)vanityUrl.getLanguage());
                    path = StringUtils.substringBefore((String)vanityUrl.getPath(), (String)"/vanityUrlMapping/");
                    request.setAttribute("vanityUrlTargetPath", (Object)path);
                    request.setAttribute("vanityUrlFiles", (Object)vanityUrl.isFile());
                }
            }
            catch (UnsupportedEncodingException | RepositoryException e) {
                logger.error("Cannot get vanity Url", e);
            }
        } else if (path.startsWith("/sites/")) {
            targetSiteKey = StringUtils.substringAfter((String)path, (String)"/sites/");
            if (targetSiteKey.contains("/")) {
                targetSiteKey = StringUtils.substringBefore((String)targetSiteKey, (String)"/");
            } else if (targetSiteKey.contains(".")) {
                targetSiteKey = StringUtils.substringBeforeLast((String)targetSiteKey, (String)".");
            }
        }
        try {
            String language = this.siteService.getSiteDefaultLanguage(targetSiteKey);
            if (language == null) {
                language = this.siteService.getSiteDefaultLanguage(StringUtils.substringBeforeLast((String)targetSiteKey, (String)"."));
            }
            request.setAttribute("siteDefaultLanguage", (Object)language);
        }
        catch (JahiaException e) {
            logger.error("Cannot get site for key " + targetSiteKey, (Throwable)e);
        }
        return true;
    }

    private void resetState(HttpServletRequest request) {
        request.removeAttribute("jahiaSeoCmsToken");
        request.removeAttribute("siteDefaultLanguage");
        request.removeAttribute("jahiaSiteKeyMatchesDefaultLanguage");
        request.removeAttribute("jahiaSeoLanguageToken");
        request.removeAttribute("jahiaSeoAddCmsPrefix");
        request.removeAttribute("jahiaSiteKeyForCurrentServerName");
        request.removeAttribute("jahiaSiteKeyForLink");
        request.removeAttribute("jahiaSeoServernameForLink");
        request.removeAttribute("jahiaSiteKeyMatchesCurrentServerName");
        request.removeAttribute("jahiaSkipInboundSeoRules");
        request.removeAttribute("vanityUrlTargetLang");
        request.removeAttribute("vanityUrlTargetPath");
    }

    public RewrittenUrl rewriteInbound(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, InvocationTargetException {
        return this.getEngine().processRequest(request, response);
    }

    public String rewriteOutbound(String url, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, InvocationTargetException {
        return this.getEngine().rewriteOutbound(url, request, response);
    }

    public void setConfigurationResources(Resource[] configurationResources) {
        this.configurationResources = this.createIfNeededAndAddAll(configurationResources, this.configurationResources);
    }

    public void addConfigurationResource(Resource resource) {
        this.configurationResources = this.addTo(resource, this.configurationResources);
    }

    public void removeConfigurationResource(Resource resource) {
        this.removeFrom(resource, this.configurationResources);
    }

    public void setConfReloadCheckIntervalSeconds(int confReloadCheckIntervalSeconds) {
        this.confReloadCheckIntervalSeconds = confReloadCheckIntervalSeconds;
    }

    public void setSeoConfigurationResources(Resource[] seoConfigurationResources) {
        this.seoConfigurationResources = this.createIfNeededAndAddAll(seoConfigurationResources, this.seoConfigurationResources);
    }

    public void addSeoConfigurationResource(Resource resource) {
        this.seoConfigurationResources = this.addTo(resource, this.seoConfigurationResources);
    }

    public void removeSeoConfigurationResource(Resource resource) {
        this.removeFrom(resource, this.seoConfigurationResources);
    }

    public void setSeoRulesEnabled(boolean seoRulesEnabled) {
        this.seoRulesEnabled = seoRulesEnabled;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setVanityUrlService(VanityUrlService vanityUrlService) {
        this.vanityUrlService = vanityUrlService;
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void setReservedUrlPrefixes(String reservedUrlPrefixes) {
        Set<Object> prefixes = new HashSet();
        if (StringUtils.isBlank((String)reservedUrlPrefixes)) {
            prefixes = Collections.emptySet();
        } else {
            for (String prefix : StringUtils.split((String)reservedUrlPrefixes, (String)",")) {
                if (!StringUtils.isNotBlank((String)prefix)) continue;
                prefixes.add(StringUtils.trim((String)prefix));
            }
        }
        this.reservedUrlPrefixSet = prefixes;
    }

    public void setSiteService(JahiaSitesService siteService) {
        this.siteService = siteService;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public void setLastConfigurationResources(Resource[] postSeoConfigurationResources) {
        this.lastConfigurationResources = this.createIfNeededAndAddAll(postSeoConfigurationResources, this.lastConfigurationResources);
    }

    public void addLastConfigurationResource(Resource resource) {
        this.lastConfigurationResources = this.addTo(resource, this.lastConfigurationResources);
    }

    public void removeLastConfigurationResource(Resource resource) {
        this.removeFrom(resource, this.lastConfigurationResources);
    }

    public boolean isSeoRemoveCmsPrefix() {
        return this.seoRemoveCmsPrefix;
    }

    public void setSeoRemoveCmsPrefix(boolean seoRemoveCmsPrefix) {
        this.seoRemoveCmsPrefix = seoRemoveCmsPrefix;
    }

    private List<Resource> addTo(Resource resource, List<Resource> resources) {
        if (resource != null) {
            if (resources == null) {
                resources = new ArrayList<Resource>();
            }
            if (!resources.contains(resource)) {
                resources.add(resource);
                this.modified = true;
            }
        }
        return resources;
    }

    private void removeFrom(Resource resource, List<Resource> resources) {
        if (resources != null && resource != null) {
            resources.remove(resource);
            this.modified = true;
        }
    }

    private List<Resource> createIfNeededAndAddAll(Resource[] newResources, List<Resource> resources) {
        if (newResources != null) {
            resources = new ArrayList<Resource>(newResources.length);
            Collections.addAll(resources, newResources);
        }
        return resources;
    }
}

