/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import org.jahia.registries.ServicesRegistry;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.templates.ModuleVersion;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearModuleNodesJob
extends BackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(ClearModuleNodesJob.class);
    private static final String MODULE_ID = "moduleId";
    private static final String MODULE_VERSION = "moduleVersion";

    public static JobDetail createJob(String moduleId, String moduleVersion) {
        JobDetail jobDetail = ClearModuleNodesJob.createJahiaJob("Cleanup module nodes for module " + moduleId + " v" + moduleVersion, ClearModuleNodesJob.class);
        jobDetail.setGroup("Maintenance");
        jobDetail.getJobDataMap().put(MODULE_ID, moduleId);
        jobDetail.getJobDataMap().put(MODULE_VERSION, moduleVersion);
        return jobDetail;
    }

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        String id = dataMap.getString(MODULE_ID);
        String version = dataMap.getString(MODULE_VERSION);
        logger.info("Executing cleanup of nodes for the module {} v{}", (Object)id, (Object)version);
        ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageDeployer().clearModuleNodes(id, new ModuleVersion(version));
        logger.info("...done cleanup of nodes for the module {} v{}", (Object)id, (Object)version);
    }
}

