/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ModuleVersion
implements Comparable<ModuleVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("[^0-9]+");
    private boolean isSnapshot;
    private List<Integer> orderedVersionNumbers = new ArrayList<Integer>();
    private String versionString;

    public ModuleVersion(String versionString) {
        String[] numbers;
        this.versionString = versionString;
        if (versionString.endsWith("SNAPSHOT")) {
            this.isSnapshot = true;
        }
        for (String number : numbers = VERSION_PATTERN.split(versionString)) {
            this.orderedVersionNumbers.add(Integer.parseInt(number));
        }
    }

    @Override
    public int compareTo(ModuleVersion o) {
        for (int i = 0; i < Math.min(this.orderedVersionNumbers.size(), o.orderedVersionNumbers.size()); ++i) {
            int c = this.orderedVersionNumbers.get(i).compareTo(o.getOrderedVersionNumbers().get(i));
            if (c == 0) continue;
            return c;
        }
        int c = Integer.valueOf(this.orderedVersionNumbers.size()).compareTo(o.orderedVersionNumbers.size());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(o.isSnapshot, this.isSnapshot);
        if (c != 0) {
            return c;
        }
        return this.versionString.compareTo(o.versionString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleVersion that = (ModuleVersion)o;
        return !(this.versionString != null ? !this.versionString.equals(that.versionString) : that.versionString != null);
    }

    public List<Integer> getOrderedVersionNumbers() {
        return this.orderedVersionNumbers;
    }

    public int hashCode() {
        return this.versionString != null ? this.versionString.hashCode() : 0;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public String toString() {
        return this.versionString;
    }
}

