/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.transform;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.remote.RemoteConverter;
import org.jodconverter.remote.office.RemoteOfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DocumentConverterService
implements ApplicationContextAware {
    protected static final Map<String, Object> DEF_PROPS = new HashMap<String, Object>();
    private static Logger logger = LoggerFactory.getLogger(DocumentConverterService.class);
    private Map<String, Object> defaultLoadProperties = DEF_PROPS;
    private boolean enabled;
    private DocumentFormatRegistry formatRegistry = DefaultDocumentFormatRegistry.getInstance();
    private OfficeManager officeManager;
    private String officeManagerBeanName;
    private ApplicationContext applicationContext;

    public void convert(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) throws OfficeException {
        if (!this.isEnabled()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            this.getDocumentConverter().convert(inputFile).as(inputFormat).to(outputFile).as(outputFormat).execute();
        }
        catch (OfficeException e) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Conversion from {} format to {} took {} ms", (Object[])new String[]{inputFormat != null ? inputFormat.getName() + " (" + inputFormat.getMediaType() + ")" : "", outputFormat != null ? outputFormat.getName() + " (" + outputFormat.getMediaType() + ")" : "", String.valueOf(System.currentTimeMillis() - startTime)});
                }
                throw throwable;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Conversion from {} format to {} took {} ms", (Object[])new String[]{inputFormat != null ? inputFormat.getName() + " (" + inputFormat.getMediaType() + ")" : "", outputFormat != null ? outputFormat.getName() + " (" + outputFormat.getMediaType() + ")" : "", String.valueOf(System.currentTimeMillis() - startTime)});
        }
    }

    public void convert(File inputFile, File outputFile) throws OfficeException {
        this.convert(inputFile, null, outputFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(InputStream inputStream, String inputMimeType, OutputStream outputStream, String outputMimeType) throws OfficeException {
        if (!this.isEnabled()) {
            return;
        }
        File inputFile = null;
        File outputFile = null;
        try {
            inputFile = this.getFile(inputStream);
            outputFile = this.createTempFile();
            this.convert(inputFile, this.getFormatByMimeType(inputMimeType), outputFile, this.getFormatByMimeType(outputMimeType));
            this.writeToOutputStream(outputStream, outputFile);
        }
        catch (IOException ioe) {
            logger.warn("A problem occurred during the transformation", (Throwable)ioe);
        }
        finally {
            FileUtils.deleteQuietly((File)inputFile);
            FileUtils.deleteQuietly((File)outputFile);
        }
    }

    public File convert(File inputFile, String inputFileMimeType, String outputMimeType) throws IOException, OfficeException {
        if (!this.isEnabled()) {
            return null;
        }
        File outputFile = this.createTempFile();
        this.convert(inputFile, this.getFormatByMimeType(inputFileMimeType), outputFile, this.getFormatByMimeType(outputMimeType));
        return outputFile;
    }

    protected File createTempFile() throws IOException {
        return File.createTempFile("doc-converter", null);
    }

    public String getMimeType(String extension) {
        DocumentFormat df = this.formatRegistry.getFormatByExtension(extension);
        if (df == null) {
            return null;
        }
        return df.getMediaType();
    }

    public String getExtension(String mimeType) {
        DocumentFormat df = this.formatRegistry.getFormatByMediaType(mimeType);
        if (df == null) {
            return null;
        }
        return df.getExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToOutputStream(OutputStream os, File file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException ioe) {
            try {
                logger.warn("File " + file.getName() + " can't be written into outputStream", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly((OutputStream)os);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    @NotNull
    private DocumentConverter getDocumentConverter() {
        if (this.officeManager instanceof RemoteOfficeManager) {
            return RemoteConverter.make((OfficeManager)this.officeManager);
        }
        return LocalConverter.make((OfficeManager)this.officeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(InputStream is) {
        if (is == null) {
            return null;
        }
        File file = null;
        FileOutputStream os = null;
        try {
            file = this.createTempFile();
            os = new FileOutputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException ioe) {
            try {
                logger.warn("inputStream from file " + (file != null ? file.getName() : null) + " can't be converted into file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        return file;
    }

    public DocumentFormat getFormat(File file) {
        return this.formatRegistry.getFormatByExtension(FilenameUtils.getExtension((String)file.getName()));
    }

    public DocumentFormat getFormatByMimeType(String mimeType) {
        return this.formatRegistry.getFormatByMediaType(mimeType);
    }

    public DocumentFormat getFormatByFileName(String fileName) {
        return this.formatRegistry.getFormatByExtension(FilenameUtils.getExtension((String)fileName));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setDefaultLoadProperties(Map<String, Object> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFormatRegistry(DocumentFormatRegistry formatRegistry) {
        this.formatRegistry = formatRegistry;
    }

    public void start() throws OfficeException {
        if (!this.isEnabled()) {
            return;
        }
        try {
            this.officeManager = (OfficeManager)this.applicationContext.getBean(this.officeManagerBeanName);
        }
        catch (Exception e) {
            logger.error("OfficeManager factory exception. Cause: " + e.getMessage(), (Throwable)e);
        }
        if (this.officeManager == null) {
            logger.warn("OfficeManager instance is not initialized correctly. Disabling service.");
            this.setEnabled(false);
            return;
        }
        logger.info("Starting OpenOffice manager...");
        try {
            this.officeManager.start();
            logger.info("...OpenOffice manager started.");
        }
        catch (Exception e) {
            logger.error("Error starting document converter service. Cause: " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() throws OfficeException {
        if (this.isEnabled() && this.officeManager != null) {
            try {
                logger.info("Stopping OfficeManager...");
                this.officeManager.stop();
                logger.info("...OfficeManager successfully stopped.");
            }
            catch (Exception e) {
                logger.warn("Error stopping OfficeManager. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setOfficeManagerBeanName(String officeManagerBeanName) {
        this.officeManagerBeanName = officeManagerBeanName != null ? officeManagerBeanName.trim() : null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static {
        DEF_PROPS.put("Hidden", true);
        DEF_PROPS.put("ReadOnly", true);
    }
}

