/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.transform;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.office.ExistingProcessAction;
import org.jodconverter.local.office.LocalOfficeManager;
import org.jodconverter.local.process.ProcessManager;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class LocalOfficeManagerFactory
extends AbstractFactoryBean<OfficeManager> {
    private LocalOfficeManager.Builder cfg = LocalOfficeManager.builder();
    private boolean killExistingOfficeProcessOnWindows = true;

    protected OfficeManager createInstance() throws Exception {
        if (this.killExistingOfficeProcessOnWindows && SystemUtils.IS_OS_WINDOWS) {
            this.cfg.existingProcessAction(ExistingProcessAction.KILL);
        }
        return this.cfg.build();
    }

    public Class<? extends OfficeManager> getObjectType() {
        return OfficeManager.class;
    }

    public void setMaxTasksPerProcess(int maxTasksPerProcess) {
        this.cfg.maxTasksPerProcess(Integer.valueOf(maxTasksPerProcess));
    }

    public void setOfficeHome(File officeHome) throws NullPointerException, IllegalArgumentException {
        this.cfg.officeHome(officeHome);
    }

    public void setOfficeHome(String officeHome) throws NullPointerException, IllegalArgumentException {
        this.cfg.officeHome(officeHome);
    }

    public void setPipeName(String pipeName) throws NullPointerException {
        this.cfg.pipeNames(new String[]{pipeName});
    }

    public void setPipeNames(String ... pipeNames) throws NullPointerException, IllegalArgumentException {
        this.cfg.pipeNames(pipeNames);
    }

    public void setPortNumber(int portNumber) {
        this.cfg.portNumbers(new int[]{portNumber});
    }

    public void setPortNumbers(int ... portNumbers) throws NullPointerException, IllegalArgumentException {
        this.cfg.portNumbers(portNumbers);
    }

    public void setProcessManager(ProcessManager processManager) throws NullPointerException {
        this.cfg.processManager(processManager);
    }

    public void setTaskExecutionTimeout(long taskExecutionTimeout) {
        this.cfg.taskExecutionTimeout(Long.valueOf(taskExecutionTimeout));
    }

    public void setTaskQueueTimeout(long taskQueueTimeout) {
        this.cfg.taskQueueTimeout(Long.valueOf(taskQueueTimeout));
    }

    public void setTemplateProfileDir(File templateProfileDir) throws IllegalArgumentException {
        this.cfg.templateProfileDir(templateProfileDir);
    }

    public void setKillExistingOfficeProcessOnWindows(boolean killExistingOfficeProcessOnWindows) {
        this.killExistingOfficeProcessOnWindows = killExistingOfficeProcessOnWindows;
    }
}

