/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import javax.jcr.RepositoryException;
import javax.jcr.query.RowIterator;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Searchable;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.expression.Criteria;
import net.sf.ehcache.search.expression.EqualTo;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.query.QueryWrapper;

public class UserCacheHelper {
    private static final int DEFAULT_TTL_FOR_NON_EXISTING_USERS = 600;
    private EhCacheProvider ehCacheProvider;
    private volatile SelfPopulatingCache userPathByUserNameCache;
    private int timeToLiveForNonExistingUsers = 600;

    public String getUserPath(String name, String site) {
        String value = (String)this.getUserPathByUserNameCache().get((Serializable)new UserPathCacheKey(name, StringUtils.isEmpty((String)site) ? null : site)).getObjectValue();
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelfPopulatingCache getUserPathByUserNameCache() {
        SelfPopulatingCache cache = this.userPathByUserNameCache;
        if (cache == null) {
            UserCacheHelper userCacheHelper = this;
            synchronized (userCacheHelper) {
                cache = this.userPathByUserNameCache;
                if (cache == null) {
                    this.userPathByUserNameCache = cache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.services.usermanager.JahiaUserManagerService.userPathByUserNameCache", new Searchable(), new UserPathByUserNameCacheEntryFactory());
                }
            }
        }
        return cache;
    }

    public void setEhCacheProvider(EhCacheProvider ehCacheProvider) {
        this.ehCacheProvider = ehCacheProvider;
    }

    public void setTimeToLiveForNonExistingUsers(int timeToLiveForNonExistingUsers) {
        this.timeToLiveForNonExistingUsers = timeToLiveForNonExistingUsers;
    }

    public void updateAdded(String userPath) {
        this.getUserPathByUserNameCache().put(new Element((Serializable)new UserPathCacheKey(StringUtils.substringAfterLast((String)userPath, (String)"/"), this.getSiteKey(userPath)), (Serializable)((Object)userPath)));
    }

    public void updateRemoved(String userPath) {
        this.getUserPathByUserNameCache().remove((Serializable)new UserPathCacheKey(StringUtils.substringAfterLast((String)userPath, (String)"/"), this.getSiteKey(userPath)));
    }

    private String getSiteKey(String userPath) {
        return userPath.startsWith("/sites/") ? StringUtils.substringBetween((String)userPath, (String)"/sites/", (String)"/") : null;
    }

    public void clearNonExistingUsersCache() {
        SelfPopulatingCache cache = this.getUserPathByUserNameCache();
        Results results = cache.createQuery().addCriteria((Criteria)new EqualTo("value", (Object)"")).includeKeys().execute();
        for (Result result : results.all()) {
            cache.remove(result.getKey());
        }
    }

    private static final class UserPathCacheKey
    implements Serializable {
        private static final long serialVersionUID = -727853070149556455L;
        private final int hash;
        private final String site;
        private final String user;

        private UserPathCacheKey(String user, String site) {
            this.user = user;
            this.site = site;
            this.hash = this.getHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (null == other || other.getClass() != this.getClass()) {
                return false;
            }
            UserPathCacheKey otherKey = (UserPathCacheKey)other;
            return StringUtils.equals((String)this.user, (String)otherKey.user) && StringUtils.equals((String)this.site, (String)otherKey.site);
        }

        private final int getHashCode() {
            int iTotal = 17;
            iTotal = 37 * iTotal + (this.user != null ? this.user.hashCode() : 0);
            iTotal = 37 * iTotal + (this.site != null ? this.site.hashCode() : 0);
            return iTotal;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private final class UserPathByUserNameCacheEntryFactory
    implements CacheEntryFactory {
        private UserPathByUserNameCacheEntryFactory() {
        }

        public Object createEntry(Object key) throws Exception {
            UserPathCacheKey k = (UserPathCacheKey)key;
            String path = this.internalGetUserPath(k.user, k.site);
            if (path != null) {
                return new Element(key, (Object)path);
            }
            return new Element(key, (Object)"", 0, UserCacheHelper.this.timeToLiveForNonExistingUsers);
        }

        private String internalGetUserPath(String name, String siteName) throws RepositoryException {
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT [j:nodename] from [jnt:user] where localname()='");
            statement.append(JCRContentUtils.sqlEncode(name));
            statement.append("' and isdescendantnode('");
            if (siteName != null) {
                statement.append("/sites");
                statement.append('/');
                statement.append(JCRContentUtils.sqlEncode(siteName));
            }
            statement.append("/users/')");
            String path = this.queryUserPathInWorkspace(statement, "live");
            if (path == null) {
                path = this.queryUserPathInWorkspace(statement, null);
            }
            return path;
        }

        private String queryUserPathInWorkspace(StringBuilder q, String workspace) throws RepositoryException {
            QueryWrapper query = JCRSessionFactory.getInstance().getCurrentSystemSession(workspace, null, null).getWorkspace().getQueryManager().createQuery(q.toString(), "JCR-SQL2");
            query.setLimit(1L);
            RowIterator it = query.execute().getRows();
            if (it.hasNext()) {
                return it.nextRow().getPath();
            }
            return null;
        }
    }
}

