/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.io.NotSerializableException;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.AcceptsTimerJobFactoryManager;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.jahia.bin.filters.jcr.JcrSessionFilter;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.core.timer.impl.QuartzSchedulerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleTrigger;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaQuartzSchedulerService
implements GlobalSchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(JahiaQuartzSchedulerService.class);
    private AtomicLong idCounter = new AtomicLong();
    private TimerService globalTimerService;
    private SchedulerServiceInterceptor interceptor = new DelegateSchedulerServiceInterceptor((GlobalSchedulerService)this);
    private Scheduler scheduler;

    public JahiaQuartzSchedulerService(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Long id = this.idCounter.getAndIncrement();
        String jobname = null;
        if (ctx instanceof TimerManager.ProcessJobContext) {
            TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
            jobname = processCtx.getSessionId() + "-" + processCtx.getProcessInstanceId() + "-" + processCtx.getTimer().getId();
            if (processCtx instanceof TimerManager.StartProcessJobContext) {
                jobname = "StartProcess-" + ((TimerManager.StartProcessJobContext)processCtx).getProcessId() + "-" + processCtx.getTimer().getId();
            }
        } else {
            jobname = ctx instanceof NamedJobContext ? ((NamedJobContext)ctx).getJobName() : "Timer-" + ctx.getClass().getSimpleName() + "-" + id;
        }
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobname, "jbpm");
            if (jobDetail != null) {
                TimerJobInstance timerJobInstance = (TimerJobInstance)jobDetail.getJobDataMap().get((Object)"timerJobInstance");
                return timerJobInstance.getJobHandle();
            }
        }
        catch (SchedulerException jobDetail) {
            // empty catch block
        }
        QuartzSchedulerService.GlobalQuartzJobHandle quartzJobHandle = new QuartzSchedulerService.GlobalQuartzJobHandle(id.longValue(), jobname, "jbpm");
        TimerJobInstance jobInstance = ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)quartzJobHandle, (InternalSchedulerService)this.globalTimerService);
        quartzJobHandle.setTimerJobInstance(jobInstance);
        this.interceptor.internalSchedule(jobInstance);
        return quartzJobHandle;
    }

    public boolean removeJob(JobHandle jobHandle) {
        QuartzSchedulerService.GlobalQuartzJobHandle quartzJobHandle = (QuartzSchedulerService.GlobalQuartzJobHandle)jobHandle;
        try {
            boolean removed = this.scheduler.deleteJob(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup());
            return removed;
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Exception while removing job", e);
        }
        catch (RuntimeException e) {
            try {
                SchedulerMetaData metadata = this.scheduler.getMetaData();
                if (metadata.getJobStoreClass().isAssignableFrom(JobStoreCMT.class)) {
                    return true;
                }
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
            throw e;
        }
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        QuartzSchedulerService.GlobalQuartzJobHandle quartzJobHandle = (QuartzSchedulerService.GlobalQuartzJobHandle)timerJobInstance.getJobHandle();
        JobDetail jobq = new JobDetail(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup(), QuartzJob.class);
        jobq.getJobDataMap().put((Object)"timerJobInstance", (Object)timerJobInstance);
        SimpleTrigger triggerq = new SimpleTrigger(quartzJobHandle.getJobName() + "_trigger", quartzJobHandle.getJobGroup(), timerJobInstance.getTrigger().hasNextFireTime());
        try {
            if (this.scheduler.isShutdown()) {
                return;
            }
            ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().addTimerJobInstance(timerJobInstance);
            JobDetail jobDetail = this.scheduler.getJobDetail(quartzJobHandle.getJobName(), quartzJobHandle.getJobGroup());
            if (jobDetail == null) {
                this.scheduler.scheduleJob(jobq, (org.quartz.Trigger)triggerq);
            } else {
                this.scheduler.addJob(jobq, true);
                triggerq.setJobName(quartzJobHandle.getJobName());
                triggerq.setJobGroup(quartzJobHandle.getJobGroup());
                this.scheduler.rescheduleJob(quartzJobHandle.getJobName() + "_trigger", quartzJobHandle.getJobGroup(), (org.quartz.Trigger)triggerq);
            }
        }
        catch (ObjectAlreadyExistsException e) {
            logger.warn("Job has already been scheduled, most likely running in cluster: {}", (Object)e.getMessage());
        }
        catch (JobPersistenceException e) {
            if (e.getCause() instanceof NotSerializableException) {
                this.internalSchedule((TimerJobInstance)new QuartzSchedulerService.InmemoryTimerJobInstanceDelegate(quartzJobHandle.getJobName(), ((GlobalTimerService)this.globalTimerService).getTimerServiceId()));
            }
            ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().removeTimerJobInstance(timerJobInstance);
            throw new RuntimeException(e);
        }
        catch (SchedulerException e) {
            ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().removeTimerJobInstance(timerJobInstance);
            throw new RuntimeException("Exception while scheduling job", e);
        }
    }

    public synchronized void initScheduler(TimerService timerService) {
        this.globalTimerService = timerService;
    }

    public void shutdown() {
    }

    public void forceShutdown() {
    }

    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return new QuartzSchedulerService.GlobalQuartzJobHandle(-1L, ctx.getJobName(), "jbpm");
    }

    public boolean isTransactional() {
        try {
            Class jobStoreClass = this.scheduler.getMetaData().getJobStoreClass();
            if (JobStoreSupport.class.isAssignableFrom(jobStoreClass)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("Unable to determine if quartz is transactional due to problems when checking job store class", (Throwable)e);
        }
        return false;
    }

    public void setInterceptor(SchedulerServiceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean retryEnabled() {
        return false;
    }

    public static class QuartzJob
    extends QuartzSchedulerService.QuartzJob {
        public void execute(JobExecutionContext quartzContext) throws JobExecutionException {
            try {
                super.execute(quartzContext);
            }
            finally {
                JcrSessionFilter.endRequest();
            }
        }
    }
}

