/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.services.workflow.jbpm.custom.AbstractWorkItemHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishWorkItemHandler
extends AbstractWorkItemHandler
implements WorkItemHandler {
    private static transient Logger logger = LoggerFactory.getLogger(PublishWorkItemHandler.class);

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        final List uuids = (List)workItem.getParameter("nodeIds");
        String workspace = (String)workItem.getParameter("workspace");
        String userKey = (String)workItem.getParameter("user");
        if (workItem.getParameter("currentUser") != null) {
            userKey = (String)workItem.getParameter("currentUser");
        }
        List<String> publicationPath = null;
        try {
            publicationPath = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<List<String>>(){

                @Override
                public List<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    ArrayList<String> result = new ArrayList<String>();
                    for (String uuid : uuids) {
                        try {
                            result.add(session.getNodeByIdentifier(uuid).getPath());
                        }
                        catch (RepositoryException e) {
                            logger.debug("Cannot get item " + uuid, (Throwable)e);
                        }
                    }
                    return result;
                }
            });
        }
        catch (RepositoryException e) {
            logger.debug("Error occured when getting node paths for uuids", (Throwable)e);
        }
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Publication", PublicationJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("userkey", userKey);
        jobDataMap.put((Object)"publicationInfos", (Object)uuids);
        jobDataMap.put((Object)"publicationPaths", publicationPath);
        if (workItem.getParameter("jcr:title") != null) {
            jobDataMap.put("publicationTitle", ((WorkflowVariable)workItem.getParameter("jcr:title")).getValue());
        }
        jobDataMap.put("source", workspace);
        jobDataMap.put("destination", "live");
        jobDataMap.put("lock", "publication-process-" + workItem.getProcessInstanceId());
        jobDataMap.put("checkPermissions", false);
        try {
            ServicesRegistry.getInstance().getSchedulerService().scheduleJobAtEndOfRequest(jobDetail);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        logger.debug("publish job schedule and send complete work item {}", (Object)workItem);
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        manager.abortWorkItem(workItem.getId());
    }
}

