/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.jahia.api.Constants;
import org.jahia.commons.Version;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.patches.GraphqlPatcher;
import org.jahia.tools.patches.GroovyPatcher;
import org.jahia.tools.patches.PatchExecutor;
import org.jahia.tools.patches.ProvisioningPatcher;
import org.jahia.tools.patches.SqlPatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class Patcher
implements JahiaAfterInitializationService,
DisposableBean {
    public static final String README = "README";
    public static final String SUFFIX_INSTALLED = ".installed";
    public static final String SUFFIX_FAILED = ".failed";
    public static final String SUFFIX_SKIPPED = ".skipped";
    public static final String KEEP = "keep";
    public static final String REMOVE = "remove";
    private static final Logger logger = LoggerFactory.getLogger(Patcher.class);
    private static final String[] LIFECYCLE_PHASES = new String[]{"beforeContextInitializing", "contextInitializing", "contextInitialized", "contextInitialized-processingServer", "contextInitialized-nonProcessingServer", "jcrStoreProviderStarted", "rootContextInitialized"};
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+).*");
    public static final Comparator<Resource> RESOURCE_COMPARATOR = Comparator.comparing(Resource::getFilename);
    private Version jahiaPreviousVersion;
    private List<PatchExecutor> patchers = Arrays.asList(new GroovyPatcher(), new SqlPatcher(), new GraphqlPatcher(), new ProvisioningPatcher());
    private long interval = 300000L;
    private String patchesLookup;
    private ServletContext servletContext;
    private Timer watchdog;

    private Patcher() {
        this.initPreviousVersion();
    }

    public static Patcher getInstance() {
        return InstanceHolder.instance;
    }

    public void executeScripts(String lifecyclePhase) {
        try {
            LinkedList patches;
            if (System.getProperty("skipPatches") != null) {
                return;
            }
            File lookupFolder = this.getPatchesFolder();
            if (lookupFolder == null) {
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Looking up patches in the folder {}", (Object)lookupFolder);
            }
            if ((patches = new LinkedList(FileUtils.listFiles((File)lookupFolder, (IOFileFilter)new AndFileFilter((IOFileFilter)new NotFileFilter((IOFileFilter)new SuffixFileFilter(new String[]{README, SUFFIX_INSTALLED, SUFFIX_FAILED, SUFFIX_SKIPPED})), (IOFileFilter)new LifecycleFilter(lifecyclePhase)), (IOFileFilter)TrueFileFilter.INSTANCE))).isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("No patches were found");
                }
                return;
            }
            List<Resource> resources = patches.stream().map(p -> p == null ? null : new FileSystemResource(p)).sorted(RESOURCE_COMPARATOR).collect(Collectors.toList());
            this.executeScripts(resources, lifecyclePhase);
        }
        catch (Exception e) {
            logger.error("Error executing patches", (Throwable)e);
        }
    }

    public void executeScripts(Collection<Resource> scripts, String lifecyclePhase) {
        this.executeScripts(scripts, lifecyclePhase, this::afterExecution);
    }

    public void executeScripts(Collection<Resource> scripts, String lifecyclePhase, BiConsumer<Resource, String> afterExecution) {
        if (scripts.isEmpty()) {
            return;
        }
        long timer = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info("Found patch scripts {}. Executing...", (Object)StringUtils.join(scripts, (char)','));
        }
        for (Resource script : scripts) {
            try {
                if (this.shouldSkipMigrationScript(script.getFilename())) {
                    afterExecution.accept(script, SUFFIX_SKIPPED);
                    continue;
                }
                this.executeScript(lifecyclePhase, script, afterExecution);
            }
            catch (Exception e) {
                logger.error("Execution of script {} failed with error: ", (Object)e.getMessage(), (Object)e);
                afterExecution.accept(script, SUFFIX_FAILED);
            }
        }
        logger.info("Execution took {} ms", (Object)(System.currentTimeMillis() - timer));
    }

    private void executeScript(String lifecyclePhase, Resource script, BiConsumer<Resource, String> afterExecution) throws IOException {
        long timerSingle = System.currentTimeMillis();
        String scriptContent = this.getContent(script);
        if (StringUtils.isNotEmpty((String)scriptContent)) {
            for (PatchExecutor patcher : this.patchers) {
                if (!patcher.canExecute(script.getURL().getPath(), lifecyclePhase)) continue;
                String result = patcher.executeScript(script.getURL().getPath(), scriptContent);
                logger.info("Execution of script {} : {} took {} ms", new Object[]{script.getFilename(), result, System.currentTimeMillis() - timerSingle});
                afterExecution.accept(script, result);
                break;
            }
        } else {
            logger.warn("Content of the script {} is either empty or cannot be read. Skipping.", (Object)script.getFilename());
            afterExecution.accept(script, SUFFIX_SKIPPED);
        }
    }

    private boolean shouldSkipMigrationScript(String filename) {
        Matcher matcher = VERSION_PATTERN.matcher(filename);
        return matcher.matches() && (this.jahiaPreviousVersion == null || new Version(matcher.group(1)).compareTo(this.jahiaPreviousVersion) <= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(Resource r) throws IOException {
        InputStream in = null;
        try {
            in = r.getInputStream();
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public File getPatchesFolder() {
        File lookupFolder;
        String varFolder = System.getProperty("jahiaVarDiskPath");
        if (varFolder == null) {
            String string = varFolder = SettingsBean.getInstance() != null ? SettingsBean.getInstance().getJahiaVarDiskPath() : null;
        }
        if (varFolder == null) {
            varFolder = this.servletContext.getRealPath("WEB-INF/var");
        }
        return (lookupFolder = new File(varFolder, "patches")).isDirectory() ? lookupFolder : null;
    }

    private void afterExecution(Resource script, String result) {
        try {
            File scriptFile = script.getFile();
            if (REMOVE.equals(result)) {
                Files.delete(scriptFile.toPath());
            } else if (result.startsWith(".")) {
                File dest = new File(scriptFile.getParentFile(), scriptFile.getName() + result);
                if (dest.exists()) {
                    FileUtils.deleteQuietly((File)dest);
                }
                if (!scriptFile.renameTo(dest)) {
                    logger.warn("Unable to rename script file {} to {}. Skip renaming.", (Object)script.getFile().getPath(), (Object)dest.getPath());
                }
            }
        }
        catch (IOException e) {
            logger.warn("Unable to rename the script file for resource {} due to an error: {}", new Object[]{script, e.getMessage(), e});
        }
    }

    public void destroy() throws Exception {
        if (this.watchdog != null) {
            this.watchdog.cancel();
        }
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
        if (!SettingsBean.getInstance().isProcessingServer()) {
            logger.info("Script watchdog is disabled on a non-processing Jahia server");
            return;
        }
        if (this.interval > 5000L && SettingsBean.getInstance().isDevelopmentMode()) {
            this.interval = 5000L;
        }
        if (this.interval <= 0L) {
            logger.info("The interval for the patcher is <= 0. Skip starting file watcher.");
            return;
        }
        if (StringUtils.isEmpty((String)this.getPatchesLookup())) {
            logger.info("The patches lookup path is not set. Skip starting file watcher.");
            return;
        }
        this.perform();
        this.watchdog = new Timer(true);
        this.watchdog.schedule(new TimerTask(){

            @Override
            public void run() {
                Patcher.this.perform();
            }
        }, 0L, this.interval);
    }

    private void perform() {
        this.executeScripts("");
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public String getPatchesLookup() {
        File patchesFolder;
        if (this.patchesLookup == null && (patchesFolder = this.getPatchesFolder()) != null) {
            String absolutePath = patchesFolder.getAbsolutePath();
            absolutePath = StringUtils.replaceChars((String)absolutePath, (char)'\\', (char)'/');
            absolutePath = StringUtils.replace((String)absolutePath, (String)" ", (String)"%20");
            this.patchesLookup = "file://" + absolutePath + "/**/*";
        }
        return this.patchesLookup;
    }

    public void setPatchesLookup(String patchesLookup) {
        this.patchesLookup = patchesLookup;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setPatchers(List<PatchExecutor> patchers) {
        this.patchers = patchers;
    }

    public Version getJahiaPreviousVersion() {
        return this.jahiaPreviousVersion;
    }

    private void initPreviousVersion() {
        File versionFile = new File(SettingsBean.getInstance().getJahiaVarDiskPath() + "/info/version.properties");
        if (versionFile.exists()) {
            try (FileInputStream inputStream = new FileInputStream(versionFile);){
                Properties p = new Properties();
                p.load(inputStream);
                this.jahiaPreviousVersion = new Version(p.getProperty("version"));
            }
            catch (IOException ioException) {
                logger.error("Cannot read version.txt", (Throwable)ioException);
            }
        }
        if (this.jahiaPreviousVersion == null) {
            this.initPreviousVersionFromBundlesDeployed();
        }
        if (!versionFile.getParentFile().exists()) {
            versionFile.getParentFile().mkdirs();
        }
        if (!versionFile.exists() || this.jahiaPreviousVersion == null || !this.jahiaPreviousVersion.toString().equals(Constants.JAHIA_PROJECT_VERSION)) {
            try {
                FileUtils.writeStringToFile((File)versionFile, (String)("version=" + Constants.JAHIA_PROJECT_VERSION), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioException) {
                logger.error("Cannot store version.txt", (Throwable)ioException);
            }
        }
    }

    private void initPreviousVersionFromBundlesDeployed() {
        Pattern p = Pattern.compile("^mvn:org.jahia.bundles/org.jahia.bundles.extender.jahiamodules/(.*)$");
        File file = new File(SettingsBean.getInstance().getJahiaVarDiskPath() + "/bundles-deployed");
        if (file.exists()) {
            Arrays.stream(file.listFiles(File::isDirectory)).map(f -> new File((File)f, "bundle.info")).filter(File::exists).flatMap(f -> {
                try {
                    return FileUtils.readLines((File)f, (Charset)StandardCharsets.UTF_8).stream();
                }
                catch (IOException ioException) {
                    logger.debug("Cannot read bundle.info", (Throwable)ioException);
                    return Stream.empty();
                }
            }).forEach(l -> {
                Matcher m = p.matcher((CharSequence)l);
                if (m.matches()) {
                    this.jahiaPreviousVersion = new Version(m.group(1));
                }
            });
        }
    }

    private static class LifecycleFilter
    implements IOFileFilter {
        private final String lifecyclePhase;

        public LifecycleFilter(String lifecyclePhase) {
            this.lifecyclePhase = lifecyclePhase;
        }

        private boolean isValid(String name) {
            String filePhase = StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)name, (String)"."), (String)".");
            if (this.lifecyclePhase.equals("")) {
                return Arrays.stream(LIFECYCLE_PHASES).noneMatch(filePhase::equals);
            }
            return filePhase.equals(this.lifecyclePhase);
        }

        public boolean accept(File file) {
            return this.isValid(file.getName());
        }

        public boolean accept(File dir, String name) {
            return this.isValid(name);
        }
    }

    private static class InstanceHolder {
        public static final Patcher instance = new Patcher();

        private InstanceHolder() {
        }
    }
}

