/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;

public class JcrUtils {
    public static final String TEMP_NODE_NAME = "tmp";

    private JcrUtils() {
    }

    public static JCRNodeWrapper getNodeCreateIfNeeded(JCRNodeWrapper parent, String name, String type) throws IllegalStateException {
        try {
            if (parent.hasNode(name)) {
                JCRNodeWrapper node = parent.getNode(name);
                if (!node.getPrimaryNodeTypeName().equals(type)) {
                    throw new IllegalStateException(String.format("Unexpected type of node %s: %s", node.getPath(), node.getPrimaryNodeTypeName()));
                }
                return node;
            }
            parent.addNode(name, type);
            parent.getSession().save();
            return parent.getNode(name);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    public static JCRNodeWrapper getTempNodeCreateIfNeeded(JCRSessionWrapper session) throws IllegalStateException {
        JCRNodeWrapper root;
        try {
            root = session.getRootNode();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
        return JcrUtils.getNodeCreateIfNeeded(root, TEMP_NODE_NAME, "nt:unstructured");
    }
}

