/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.LevelRangeFilter;

@Plugin(name="Log4jEventCollector", category="Core", elementType="appender", printObject=true)
public class Log4jEventCollector
extends AbstractAppender {
    private boolean closed;
    private List<LogEvent> events = new LinkedList<LogEvent>();

    @PluginFactory
    public static Log4jEventCollector createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="LevelRangeFilter") LevelRangeFilter filter) {
        if (name == null) {
            LOGGER.error("A name for the Appender must be specified");
            return null;
        }
        return new Log4jEventCollector(name, null, filter);
    }

    private Log4jEventCollector(String name, Layout<? extends Serializable> layout, LevelRangeFilter filter) {
        super(name, (Filter)filter, layout, false);
    }

    public synchronized void append(LogEvent event) {
        if (this.closed) {
            throw new IllegalStateException("Event collector is closed");
        }
        this.events.add(event);
    }

    public synchronized List<LogEvent> getCollectedEvents() {
        return Collections.unmodifiableList(this.events);
    }
}

